/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.record;

import com.google.common.collect.ImmutableMap;
import com.gtocore.common.item.ApothItem;
import com.gtocore.common.item.ColoringItems;
import com.gtocore.data.tag.Tags;
import com.gtolib.GTOCore;
import com.gtolib.utils.register.ItemRegisterUtils;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public record ApotheosisAffixRecord(String affixId, String enId, String cnId, int color, String processedId) {
    private static List<ApotheosisAffixRecord> AFFIXS = new ArrayList<ApotheosisAffixRecord>();
    public static final Map<Item, ApotheosisAffixRecord> AFFIX_ITEM_MAP;

    public static ApotheosisAffixRecord create(String apotheosisAffixId, String enId, String cnId) {
        int color = ApotheosisAffixRecord.generateColorFromId(apotheosisAffixId);
        String processedId = apotheosisAffixId.indexOf(58) > 0 ? apotheosisAffixId.substring(apotheosisAffixId.indexOf(58) + 1).replace("/", "_") : apotheosisAffixId;
        return new ApotheosisAffixRecord(apotheosisAffixId, enId, cnId, color, processedId);
    }

    private static int generateColorFromId(String apotheosisAffixId) {
        int hash = apotheosisAffixId.hashCode();
        int r = (hash & 0xFF0000) >> 16;
        int g = (hash & 0xFF00) >> 8;
        int b2 = hash & 0xFF;
        r = Math.max(r, 48);
        g = Math.max(g, 48);
        b2 = Math.max(b2, 48);
        return r << 16 | g << 8 | b2;
    }

    private static void addRecord(String affixId, String enId, String cnId) {
        AFFIXS.add(ApotheosisAffixRecord.create(affixId, enId, cnId));
    }

    public static Map<String, ItemEntry<ApothItem>> registerAffixEssence() {
        ImmutableMap.Builder entries = ImmutableMap.builder();
        for (ApotheosisAffixRecord record : AFFIXS) {
            String itemId = "affix_essence_" + record.processedId();
            String cnName = "\u523b\u5370\u7cbe\u7cb9 (" + record.cnId() + ")";
            String enName = "Affix Essence (" + record.enId() + ")";
            ItemEntry entry = ((ItemBuilder)ItemRegisterUtils.item((String)itemId, (String)cnName, p -> ApothItem.create(p, record.color())).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{GTOCore.id((String)"item/apoth/fabric0"), GTOCore.id((String)"item/apoth/fabric1")})).lang(enName).color(() -> ColoringItems::color).tag(new TagKey[]{Tags.AFFIX_ESSENCE}).onRegister(i -> AFFIX_ITEM_MAP.put((Item)i, record))).register();
            entries.put((Object)record.affixId(), (Object)entry);
        }
        AFFIXS = null;
        return entries.build();
    }

    static {
        ApotheosisAffixRecord.addRecord("original", "original", "\u539f\u59cb");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/attribute/ironforged", "Ironforged \u00b7 of Iron", "\u94c1\u94f8 \u00b7 \u94c1");
        ApotheosisAffixRecord.addRecord("apotheosis:sword/attribute/vampiric", "Vampiric \u00b7 of Bloodletting", "\u5438\u8840 \u00b7 \u653e\u8840");
        ApotheosisAffixRecord.addRecord("apotheosis:sword/special/festive", "Festive \u00b7 of Partying", "\u8282\u5e86 \u00b7 \u6d3e\u5bf9");
        ApotheosisAffixRecord.addRecord("apotheosis:ranged/mob_effect/fleeting", "Fleeting \u00b7 of the Ranger", "\u75be\u9a70 \u00b7 \u6e38\u4fa0");
        ApotheosisAffixRecord.addRecord("apotheosis:ranged/attribute/elven", "Elven \u00b7 of the First Archer", "\u7cbe\u7075 \u00b7 \u51a0\u519b\u5c04\u624b");
        ApotheosisAffixRecord.addRecord("apotheosis:heavy_weapon/attribute/shredding", "Shredding \u00b7 of Penetration", "\u7c89\u788e \u00b7 \u7a7f\u523a");
        ApotheosisAffixRecord.addRecord("apotheosis:shield/special/catalyzing", "Catalyzing \u00b7 of the Converted", "\u50ac\u5316 \u00b7 \u8f6c\u5316");
        ApotheosisAffixRecord.addRecord("apotheosis:sword/mob_effect/sophisticated", "Sophisticated \u00b7 of the Ancient Library", "\u8001\u7ec3 \u00b7 \u53e4\u4ee3\u56fe\u4e66\u9986");
        ApotheosisAffixRecord.addRecord("apotheosis:shield/attribute/stalwart", "Stalwart \u00b7 of Stubbornness", "\u575a\u6bc5 \u00b7 \u4e0d\u5c48");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/dmg_reduction/blast_forged", "Blast-Forged \u00b7 of the Forge God", "\u7206\u8bde \u00b7 \u953b\u9020\u4e4b\u795e");
        ApotheosisAffixRecord.addRecord("apotheosis:heavy_weapon/attribute/berserking", "Berserking \u00b7 of the Berserker", "\u72c2\u66b4 \u00b7 \u72c2\u6218\u58eb");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/attribute/stalwart", "Stalwart \u00b7 of Stubbornness", "\u575a\u5b9a \u00b7 \u987d\u56fa");
        ApotheosisAffixRecord.addRecord("apotheosis:ranged/mob_effect/ivy_laced", "Ivy Laced \u00b7 of Natural Toxins", "\u85e4\u7ed5 \u00b7 \u81ea\u7136\u6bd2\u7d20");
        ApotheosisAffixRecord.addRecord("apotheosis:ranged/mob_effect/satanic", "Satanic \u00b7 of the Burning Hells", "\u90aa\u6076 \u00b7 \u8bc5\u5492");
        ApotheosisAffixRecord.addRecord("apotheosis:sword/attribute/violent", "Violent \u00b7 of Slaying", "\u66b4\u529b \u00b7 \u6740\u622e");
        ApotheosisAffixRecord.addRecord("apotheosis:ranged/special/spectral", "Spectral \u00b7 of the Forlorn", "\u5149\u7075 \u00b7 \u88ab\u9057\u5f03\u8005");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/attribute/winged", "Winged \u00b7 of the Skies", "\u6709\u7ffc \u00b7 \u5929\u7a7a");
        ApotheosisAffixRecord.addRecord("apotheosis:heavy_weapon/attribute/annihilating", "Annihilating \u00b7 of the Titan", "\u6b7c\u706d \u00b7 \u6cf0\u5766");
        ApotheosisAffixRecord.addRecord("apotheosis:heavy_weapon/attribute/forceful", "Forceful \u00b7 of the Bull", "\u5f3a\u529b \u00b7 \u516c\u725b");
        ApotheosisAffixRecord.addRecord("apotheosis:shield/mob_effect/withering", "Withering \u00b7 of the Dark Skeleton", "\u51cb\u96f6 \u00b7 \u9ed1\u6697\u9ab7\u9ac5");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/mob_effect/nimble", "Nimble \u00b7 of the Fox", "\u7075\u654f \u00b7 \u72d0\u72f8");
        ApotheosisAffixRecord.addRecord("apotheosis:breaker/mob_effect/spelunkers", "Spelunker's \u00b7 of Cave Exploration", "\u63a2\u7a74\u8005 \u00b7 \u6d1e\u7a74\u63a2\u9669\u8005");
        ApotheosisAffixRecord.addRecord("apotheosis:breaker/special/omnetic", "Omnetic \u00b7 of the Singularity", "\u5168\u80fd \u00b7 \u5947\u70b9");
        ApotheosisAffixRecord.addRecord("apotheosis:heavy_weapon/mob_effect/caustic", "Caustic \u00b7 of the Caustic Realm", "\u8150\u8680 \u00b7 \u8150\u8680\u9886\u57df");
        ApotheosisAffixRecord.addRecord("apotheosis:ranged/attribute/agile", "Agile \u00b7 of Dexterity", "\u654f\u6377 \u00b7 \u8fc5\u654f");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/attribute/blessed", "Blessed \u00b7 of Health", "\u795d\u798f \u00b7 \u751f\u547d");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/dmg_reduction/feathery", "Feathery \u00b7 of the Eagle", "\u8986\u7fbd \u00b7 \u9e70");
        ApotheosisAffixRecord.addRecord("apotheosis:heavy_weapon/attribute/giant_slaying", "Giant Slaying \u00b7 of Colossal Strikes", "\u7206\u6740 \u00b7 \u5de8\u4eba\u6253\u51fb");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/attribute/aquatic", "Aquatic \u00b7 of the Ocean", "\u6c34\u884c \u00b7 \u6d77\u6d0b");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/attribute/spiritual", "Spiritual \u00b7 of the Witch Doctor", "\u7075\u9b42 \u00b7 \u5deb\u533b");
        ApotheosisAffixRecord.addRecord("apotheosis:shield/special/retreating", "Retreating \u00b7 of the Jester", "\u540e\u64a4 \u00b7 \u5f04\u81e3");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/attribute/elastic", "Elastic \u00b7 of the Climb", "\u7075\u6d3b \u00b7 \u6500\u722c");
        ApotheosisAffixRecord.addRecord("apotheosis:heavy_weapon/attribute/murderous", "Murderous \u00b7 of the Minotaur", "\u51f6\u6b8b \u00b7 \u7c73\u8bfa\u9676");
        ApotheosisAffixRecord.addRecord("apotheosis:sword/attribute/intricate", "Intricate \u00b7 of Critical Thinking", "\u590d\u6742 \u00b7 \u6279\u5224\u6027\u601d\u7ef4");
        ApotheosisAffixRecord.addRecord("apotheosis:ranged/attribute/streamlined", "Streamlined \u00b7 of the Sniper", "\u6d41\u7ebf\u578b \u00b7 \u72d9\u51fb\u624b");
        ApotheosisAffixRecord.addRecord("apotheosis:ranged/mob_effect/ensnaring", "Ensnaring \u00b7 of the Predator", "\u8bf1\u6355 \u00b7 \u6355\u98df\u8005");
        ApotheosisAffixRecord.addRecord("apotheosis:ranged/mob_effect/acidic", "Acidic \u00b7 of Corrosion", "\u9178\u8680 \u00b7 \u4fb5\u8680");
        ApotheosisAffixRecord.addRecord("apotheosis:breaker/attribute/lengthy", "Lengthy \u00b7 of Grasping", "\u4f38\u957f \u00b7 \u6293\u63e1");
        ApotheosisAffixRecord.addRecord("apotheosis:sword/attribute/lacerating", "Lacerating \u00b7 of Surgical Precision", "\u6495\u88c2 \u00b7 \u7cbe\u51c6\u6253\u51fb");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/mob_effect/revitalizing", "Revitalizing \u00b7 of the Wellspring", "\u65b0\u751f \u00b7 \u6e90\u6cc9");
        ApotheosisAffixRecord.addRecord("apotheosis:breaker/attribute/lucky", "Lucky \u00b7 of the Serendipitous", "\u5e78\u8fd0 \u00b7 \u5076\u7136");
        ApotheosisAffixRecord.addRecord("apotheosis:breaker/attribute/destructive", "Destructive \u00b7 of Quarrying", "\u7834\u574f \u00b7 \u51ff\u5ca9\u673a");
        ApotheosisAffixRecord.addRecord("apotheosis:breaker/mob_effect/swift", "Swift \u00b7 of Smashing", "\u8fc5\u6377 \u00b7 \u7c89\u788e");
        ApotheosisAffixRecord.addRecord("apotheosis:heavy_weapon/special/cleaving", "Cleaving \u00b7 of the Butcher", "\u6325\u5288 \u00b7 \u5c60\u592b");
        ApotheosisAffixRecord.addRecord("apotheosis:ranged/attribute/windswept", "Windswept \u00b7 of the Current", "\u98ce\u88ad \u00b7 \u6c14\u6d41");
        ApotheosisAffixRecord.addRecord("apotheosis:sword/attribute/elongated", "Elongated \u00b7 of Distant Battles", "\u5ef6\u5c55 \u00b7 \u8fdc\u6218");
        ApotheosisAffixRecord.addRecord("apotheosis:ranged/mob_effect/grievous", "Grievous \u00b7 of Wounding", "\u91cd\u521b \u00b7 \u4f24\u53e3");
        ApotheosisAffixRecord.addRecord("apotheosis:sword/attribute/piercing", "Piercing \u00b7 of the Sunderer", "\u7a7f\u523a \u00b7 \u6495\u88c2\u8005");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/attribute/gravitational", "Gravitational \u00b7 of Gravity", "\u91cd\u529b \u00b7 \u91cd\u529b");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/attribute/windswept", "Windswept \u00b7 the Windrider", "\u98ce\u88ad \u00b7 \u4e58\u98ce");
        ApotheosisAffixRecord.addRecord("apotheosis:breaker/special/enlightened", "Enlightened \u00b7 of the Lightbringer", "\u542f\u660e \u00b7 \u643a\u5149\u8005");
        ApotheosisAffixRecord.addRecord("apotheosis:ranged/special/magical", "Magical \u00b7 of the Arcane", "\u9b54\u6cd5 \u00b7 \u5965\u79d8");
        ApotheosisAffixRecord.addRecord("apotheosis:sword/attribute/infernal", "Infernal \u00b7 of the Sun", "\u5730\u72f1 \u00b7 \u592a\u9633");
        ApotheosisAffixRecord.addRecord("apotheosis:heavy_weapon/attribute/decimating", "Decimating \u00b7 of the God-King", "\u5c60\u622e \u00b7 \u795e\u738b");
        ApotheosisAffixRecord.addRecord("apotheosis:breaker/special/radial", "Radial \u00b7 of the Earthbreaker", "\u8303\u56f4 \u00b7 \u88c2\u5730\u8005");
        ApotheosisAffixRecord.addRecord("apotheosis:shield/special/psychic", "Psychic \u00b7 of the Vengeful", "\u901a\u7075 \u00b7 \u775a\u7726");
        ApotheosisAffixRecord.addRecord("apotheosis:sword/mob_effect/weakening", "Weakening \u00b7 of Weakness", "\u5f31\u5316 \u00b7 \u865a\u5f31");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/mob_effect/blinding", "Blinding \u00b7 of Darkness", "\u5931\u660e \u00b7 \u9ed1\u6697");
        ApotheosisAffixRecord.addRecord("apotheosis:heavy_weapon/attribute/nullifying", "Nullifying \u00b7 of the Magebreaker", "\u62b9\u9664 \u00b7 \u7834\u6cd5\u8005");
        ApotheosisAffixRecord.addRecord("apotheosis:telepathic", "Telepathic \u00b7 of Space and Time", "\u5ff5\u52a8 \u00b7 \u65f6\u7a7a");
        ApotheosisAffixRecord.addRecord("apotheosis:sword/special/thunderstruck", "Thunderstruck \u00b7 of the Storm", "\u96f7\u9e23 \u00b7 \u98ce\u66b4");
        ApotheosisAffixRecord.addRecord("apotheosis:heavy_weapon/mob_effect/bloodletting", "Caustic \u00b7 of the Slayer", "\u8150\u8680 \u00b7 \u6740\u622e\u8005");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/attribute/fortunate", "Fortunate \u00b7 of the Four-Leaf Clover", "\u5e78\u8fd0 \u00b7 \u56db\u53f6\u8349");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/attribute/steel_touched", "Steel Touched \u00b7 of the Defender", "\u94a2\u89e6 \u00b7 \u634d\u536b\u8005");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/dmg_reduction/runed", "Runed \u00b7 of the Spellwarden", "\u7b26\u6587 \u00b7 \u5492\u6cd5\u76d1\u5b88");
        ApotheosisAffixRecord.addRecord("apotheosis:shield/attribute/ironforged", "Ironforged \u00b7 the Unyielding", "\u94c1\u94f8 \u00b7 \u4e0d\u5c48");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/dmg_reduction/blockading", "Blockading \u00b7 of the Blockade", "\u5c01\u9501 \u00b7 \u5c4f\u969c");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/dmg_reduction/dwarven", "Dwarven \u00b7 of the Volcano", "\u77ee\u4eba \u00b7 \u706b\u5c71");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/mob_effect/bursting", "Bursting \u00b7 of Vitality", "\u8ff8\u53d1 \u00b7 \u6d3b\u529b");
        ApotheosisAffixRecord.addRecord("apotheosis:durable", "Durable \u00b7 of Durability", "\u8010\u7528 \u00b7 \u8010\u4e45");
        ApotheosisAffixRecord.addRecord("apotheosis:shield/mob_effect/venomous", "Venomous \u00b7 of the Snake", "\u6dec\u6bd2 \u00b7 \u6bd2\u86c7");
        ApotheosisAffixRecord.addRecord("apotheosis:ranged/mob_effect/shulkers", "Shulk-Touched \u00b7 of Levitation", "\u6f5c\u5f71 \u00b7 \u98d8\u6d6e");
        ApotheosisAffixRecord.addRecord("apotheosis:heavy_weapon/special/executing", "Executing \u00b7 of the Executioner", "\u884c\u5211 \u00b7 \u523d\u5b50\u624b");
        ApotheosisAffixRecord.addRecord("apotheosis:breaker/attribute/experienced", "Experienced \u00b7 of the Scholar", "\u7ecf\u9a8c \u00b7 \u5b66\u8005");
        ApotheosisAffixRecord.addRecord("apotheosis:sword/attribute/glacial", "Glacial \u00b7 of the Frostlands", "\u51b0\u5ddd \u00b7 \u51bb\u571f");
        ApotheosisAffixRecord.addRecord("apotheosis:shield/attribute/steel_touched", "Steel Touched \u00b7 the Oathkeeper", "\u94a2\u89e6 \u00b7 \u4e0d\u7834\u4e4b\u8a93");
        ApotheosisAffixRecord.addRecord("apotheosis:sword/mob_effect/elusive", "Elusive \u00b7 of Evasion", "\u7075\u5de7 \u00b7 \u95ea\u907f");
        ApotheosisAffixRecord.addRecord("apotheosis:sword/attribute/graceful", "Graceful \u00b7 of the Duelist", "\u4f18\u96c5 \u00b7 \u51b3\u6597\u8005");
        ApotheosisAffixRecord.addRecord("apotheosis:armor/mob_effect/bolstering", "Bolstering \u00b7 of Fortitude", "\u652f\u6491 \u00b7 \u575a\u97e7");
        ApotheosisAffixRecord.addRecord("apotheosis:sword/attribute/spellbreaking", "Spellbreaking \u00b7 of the Petricite Golem", "\u7834\u6cd5 \u00b7 \u5ca9\u77f3\u5080\u5121");
        ApotheosisAffixRecord.addRecord("apotheosis:shield/mob_effect/devilish", "Devilish \u00b7 of the Veteran", "\u6b8b\u5fcd \u00b7 \u8001\u5175");
        ApotheosisAffixRecord.addRecord("apotheosis:ftbu", "Chainbound \u00b7 of Veinseeking", "\u8fde\u9501 \u00b7 \u77ff\u8109\u7206\u7834");
        ApotheosisAffixRecord.addRecord("apotheosis:bedrock_ore", "Prospecting \u00b7 of the Bedrock Seer", "\u52d8\u63a2 \u00b7 \u57fa\u5ca9\u900f\u89c6\u8005");
        ApotheosisAffixRecord.addRecord("apotheosis:bedrock_fluid_ore", "Flowseeking \u00b7 of the Oil Penetrator", "\u5bfb\u6d41 \u00b7 \u77f3\u6cb9\u4e4b\u773c");
        ApotheosisAffixRecord.addRecord("apotheosis:stress", "Stress \u00b7 of the Brinkbreaker", "\u5e94\u529b \u00b7 \u5343\u94a7\u4e00\u53d1");
        ApotheosisAffixRecord.addRecord("apotheosis:kinetic", "Kinetic \u00b7 of the Momentum Master", "\u52a8\u80fd \u00b7 \u52bf\u5982\u7834\u7af9");
        AFFIX_ITEM_MAP = new Reference2ReferenceOpenHashMap();
    }
}

