/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.transaction;

import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TradingStationTool {
    public static int checkMaxMultiplier(IItemHandlerModifiable handler, List<ItemStack> requiredItems) {
        if (requiredItems.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        int maxMultiplier = Integer.MAX_VALUE;
        for (ItemStack required : requiredItems) {
            int requiredPerMulti;
            if (required.m_41619_() || (requiredPerMulti = required.m_41613_()) <= 0) continue;
            int totalInStock = 0;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack slotStack = handler.getStackInSlot(i);
                if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)required)) continue;
                totalInStock += slotStack.m_41613_();
            }
            int itemMaxMulti = totalInStock / requiredPerMulti;
            if ((maxMultiplier = Math.min(maxMultiplier, itemMaxMulti)) != 0) continue;
            break;
        }
        return maxMultiplier;
    }

    public static void deductMultipliedItems(IItemHandlerModifiable handler, List<ItemStack> items, int multiplier) {
        if (multiplier <= 0 || items.isEmpty()) {
            return;
        }
        for (ItemStack item : items) {
            int totalToDeduct;
            int perItemCount;
            if (item.m_41619_() || (perItemCount = item.m_41613_()) <= 0 || (totalToDeduct = perItemCount * multiplier) <= 0) continue;
            int remaining = totalToDeduct;
            for (int i = 0; i < handler.getSlots() && remaining > 0; ++i) {
                ItemStack slotStack = handler.getStackInSlot(i);
                if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)item)) continue;
                int take = Math.min(slotStack.m_41613_(), remaining);
                slotStack.m_41774_(take);
                if (slotStack.m_41619_()) {
                    handler.setStackInSlot(i, ItemStack.f_41583_);
                }
                remaining -= take;
            }
        }
    }

    public static void addMultipliedItems(IItemHandlerModifiable handler, List<ItemStack> items, int multiplier, Level level, BlockPos pos) {
        if (multiplier <= 0 || items.isEmpty()) {
            return;
        }
        block0: for (ItemStack item : items) {
            int totalToAdd;
            if (item.m_41619_() || item.m_41613_() <= 0 || (totalToAdd = item.m_41613_() * multiplier) <= 0) continue;
            ItemStack toAdd = item.m_41777_();
            toAdd.m_41764_(totalToAdd);
            ItemStack remaining = toAdd.m_41777_();
            int maxStackSize = toAdd.m_41741_();
            for (int i = 0; i < handler.getSlots() && !remaining.m_41619_(); ++i) {
                ItemStack existing = handler.getStackInSlot(i);
                if (existing.m_41619_() || !ItemStack.m_150942_((ItemStack)existing, (ItemStack)remaining) || existing.m_41613_() >= maxStackSize) continue;
                int addAmount = Math.min(remaining.m_41613_(), maxStackSize - existing.m_41613_());
                existing.m_41769_(addAmount);
                remaining.m_41774_(addAmount);
            }
            while (!remaining.m_41619_()) {
                boolean foundSlot = false;
                for (int i = 0; i < handler.getSlots() && !remaining.m_41619_(); ++i) {
                    if (!handler.getStackInSlot(i).m_41619_()) continue;
                    int putAmount = Math.min(remaining.m_41613_(), maxStackSize);
                    ItemStack toPut = remaining.m_41777_();
                    toPut.m_41764_(putAmount);
                    handler.setStackInSlot(i, toPut);
                    remaining.m_41774_(putAmount);
                    foundSlot = true;
                }
                if (foundSlot || !(level instanceof ServerLevel)) continue;
                ServerLevel server = (ServerLevel)level;
                while (!remaining.m_41619_()) {
                    int dropCount = Math.min(remaining.m_41613_(), maxStackSize);
                    ItemStack dropStack = remaining.m_41777_();
                    dropStack.m_41764_(dropCount);
                    ItemEntity itemEntity = new ItemEntity((Level)server, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, dropStack);
                    itemEntity.m_32061_();
                    server.m_7967_((Entity)itemEntity);
                    remaining.m_41774_(dropCount);
                }
                continue block0;
            }
        }
    }

    public static int checkMaxConsumeMultiplier(IFluidHandlerModifiable tank, List<FluidStack> requiredFluids) {
        if (requiredFluids.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        int maxMultiplier = Integer.MAX_VALUE;
        for (FluidStack required : requiredFluids) {
            if (required.isEmpty() || required.getAmount() <= 0) continue;
            int totalInTank = 0;
            for (int slot = 0; slot < tank.getTanks(); ++slot) {
                FluidStack stored = tank.getFluidInTank(slot);
                if (!stored.isFluidEqual(required)) continue;
                totalInTank += stored.getAmount();
            }
            int fluidMaxMulti = totalInTank / required.getAmount();
            if ((maxMultiplier = Math.min(maxMultiplier, fluidMaxMulti)) != 0) continue;
            break;
        }
        return maxMultiplier;
    }

    public static int checkMaxCapacityMultiplier(IFluidHandlerModifiable tank, List<FluidStack> inputFluids) {
        if (inputFluids.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        int maxMultiplier = Integer.MAX_VALUE;
        for (FluidStack input : inputFluids) {
            if (input.isEmpty() || input.getAmount() <= 0) continue;
            int totalRemainingCapacity = 0;
            for (int slot = 0; slot < tank.getTanks(); ++slot) {
                FluidStack stored;
                if (!tank.isFluidValid(slot, input) || !(stored = tank.getFluidInTank(slot)).isEmpty() && !stored.isFluidEqual(input)) continue;
                totalRemainingCapacity += tank.getTankCapacity(slot) - stored.getAmount();
            }
            int fluidMaxMulti = totalRemainingCapacity / input.getAmount();
            if ((maxMultiplier = Math.min(maxMultiplier, fluidMaxMulti)) != 0) continue;
            break;
        }
        return maxMultiplier;
    }

    public static int deductMultipliedFluids(IFluidHandlerModifiable tank, List<FluidStack> fluids, int multiplier) {
        if (multiplier <= 0 || fluids.isEmpty()) {
            return 0;
        }
        for (FluidStack fluid : fluids) {
            int totalToDeduct;
            if (fluid.isEmpty() || fluid.getAmount() <= 0 || (totalToDeduct = fluid.getAmount() * multiplier) <= 0) continue;
            FluidStack toDeduct = fluid.copy();
            toDeduct.setAmount(totalToDeduct);
            tank.drain(toDeduct, IFluidHandler.FluidAction.EXECUTE);
        }
        return multiplier;
    }

    public static int addMultipliedFluids(IFluidHandlerModifiable tank, List<FluidStack> fluids, int multiplier) {
        if (multiplier <= 0 || fluids.isEmpty()) {
            return 0;
        }
        for (FluidStack fluid : fluids) {
            int totalToAdd;
            if (fluid.isEmpty() || fluid.getAmount() <= 0 || (totalToAdd = fluid.getAmount() * multiplier) <= 0) continue;
            FluidStack toAdd = fluid.copy();
            toAdd.setAmount(totalToAdd);
            tank.fill(toAdd, IFluidHandler.FluidAction.EXECUTE);
        }
        return multiplier;
    }
}

