/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.transaction.manager;

import com.gtocore.data.transaction.manager.TradeEntry;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TradingManager {
    public static final TradingManager INSTANCE = new TradingManager();
    private final List<TradingShopGroup> shopGroups = new ArrayList<TradingShopGroup>();

    private TradingManager() {
    }

    private boolean isIndexValid(int index, int size) {
        return index >= 0 && index < size;
    }

    private void checkNotNull(@Nullable Object obj, String targetName, int index, int maxValidIndex) {
        if (obj == null) {
            throw new IndexOutOfBoundsException(String.format("%s index out of bounds: %d. Max valid index: %d", targetName, index, maxValidIndex));
        }
    }

    public int getGroupCount() {
        return this.shopGroups.size();
    }

    public int getShopCount(int groupIndex) {
        TradingShopGroup group = this.getShopGroup(groupIndex);
        this.checkNotNull(group, "Shop Group", groupIndex, this.getGroupCount() - 1);
        return group.getShopCount();
    }

    public int getTradeCount(int groupIndex, int shopIndex) {
        TradingShop shop = this.getShopByIndices(groupIndex, shopIndex);
        return shop.getTradeCount();
    }

    public boolean isTradeIndexValid(int groupIndex, int shopIndex, int entryIndex) {
        if (groupIndex < 0 || groupIndex >= this.getGroupCount()) {
            return false;
        }
        TradingShopGroup group = this.getShopGroup(groupIndex);
        if (group == null || shopIndex < 0 || shopIndex >= group.getShopCount()) {
            return false;
        }
        TradingShop shop = this.getShopByIndices(groupIndex, shopIndex);
        return entryIndex >= 0 && entryIndex < shop.getTradeCount();
    }

    public int addShopGroup(@NotNull String groupName, @Nullable IGuiTexture texture1, @Nullable IGuiTexture texture2) {
        Objects.requireNonNull(groupName, "Group name cannot be null");
        TradingShopGroup newGroup = new TradingShopGroup(groupName, texture1, texture2);
        this.shopGroups.add(newGroup);
        return this.shopGroups.size() - 1;
    }

    public int addShopByGroupIndex(int groupIndex, @NotNull String shopName, @Nullable String unlockCondition, @Nullable Set<String> currencies, @Nullable IGuiTexture texture) {
        Objects.requireNonNull(shopName, "Shop name cannot be null");
        TradingShopGroup group = this.getShopGroup(groupIndex);
        this.checkNotNull(group, "Shop Group", groupIndex, this.getGroupCount() - 1);
        return group.addShop(shopName, unlockCondition, currencies, texture);
    }

    public void addTradeEntryByIndices(int groupIndex, int shopIndex, @Nullable TradeEntry entry) {
        if (entry == null) {
            return;
        }
        TradingShop shop = this.getShopByIndices(groupIndex, shopIndex);
        shop.addTradeEntry(entry);
    }

    @Nullable
    public TradingShopGroup getShopGroup(int index) {
        return this.isIndexValid(index, this.getGroupCount()) ? this.shopGroups.get(index) : null;
    }

    @NotNull
    public TradingShop getShopByIndices(int groupIndex, int shopIndex) {
        TradingShopGroup group = this.getShopGroup(groupIndex);
        this.checkNotNull(group, "Shop Group", groupIndex, this.getGroupCount() - 1);
        TradingShop shop = group.getShop(shopIndex);
        this.checkNotNull(shop, "Shop", shopIndex, group.getShopCount() - 1);
        return shop;
    }

    @NotNull
    public TradeEntry getTradeEntryByIndices(int groupIndex, int shopIndex, int entryIndex) {
        TradingShop shop = this.getShopByIndices(groupIndex, shopIndex);
        TradeEntry entry = shop.getTradeEntry(entryIndex);
        this.checkNotNull(entry, "Trade Entry", entryIndex, shop.getTradeCount() - 1);
        return entry;
    }

    public class TradingShopGroup {
        private final String name;
        private final IGuiTexture texture1;
        private final IGuiTexture texture2;
        private final List<TradingShop> shops = new ArrayList<TradingShop>();

        private TradingShopGroup(@Nullable String name, @Nullable IGuiTexture texture1, IGuiTexture texture2) {
            this.name = name;
            this.texture1 = texture1;
            this.texture2 = texture2;
        }

        public int addShop(@NotNull String shopName, @Nullable String unlockCondition, @Nullable Set<String> currencies, @Nullable IGuiTexture texture) {
            Objects.requireNonNull(shopName, "Shop name cannot be null");
            TradingShop newShop = new TradingShop(shopName, unlockCondition, currencies, texture);
            this.shops.add(newShop);
            return this.shops.size() - 1;
        }

        public int getShopCount() {
            return this.shops.size();
        }

        @Nullable
        public TradingShop getShop(int index) {
            return TradingManager.this.isIndexValid(index, this.getShopCount()) ? this.shops.get(index) : null;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public IGuiTexture getTexture1() {
            return this.texture1;
        }

        @Generated
        public IGuiTexture getTexture2() {
            return this.texture2;
        }

        @Generated
        public List<TradingShop> getShops() {
            return this.shops;
        }
    }

    public class TradingShop {
        private final String name;
        private final String unlockCondition;
        private final Set<String> currencies;
        private final IGuiTexture texture;
        private final List<TradeEntry> tradeEntries = new ArrayList<TradeEntry>();

        private TradingShop(@Nullable String name, @Nullable String unlockCondition, @Nullable Set<String> currencies, IGuiTexture texture) {
            this.name = name;
            this.unlockCondition = unlockCondition;
            this.currencies = currencies;
            this.texture = texture;
        }

        public void addTradeEntry(@Nullable TradeEntry entry) {
            if (entry != null) {
                this.tradeEntries.add(entry);
            }
        }

        public int getTradeCount() {
            return this.tradeEntries.size();
        }

        @Nullable
        public TradeEntry getTradeEntry(int index) {
            return TradingManager.this.isIndexValid(index, this.getTradeCount()) ? this.tradeEntries.get(index) : null;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getUnlockCondition() {
            return this.unlockCondition;
        }

        @Generated
        public Set<String> getCurrencies() {
            return this.currencies;
        }

        @Generated
        public IGuiTexture getTexture() {
            return this.texture;
        }

        @Generated
        public List<TradeEntry> getTradeEntries() {
            return this.tradeEntries;
        }
    }
}

