/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.data.transaction.manager;

import com.fast.fastcollection.O2OOpenCacheHashMap;
import com.gtocore.data.transaction.manager.TradeEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class UnlockManager {
    public static final UnlockManager INSTANCE = new UnlockManager();
    private final O2OOpenCacheHashMap<String, List<TradeEntry>> unlockGroups = new O2OOpenCacheHashMap();

    private UnlockManager() {
    }

    public int getGroupCount() {
        return this.unlockGroups.size();
    }

    public int getEntryTradeCount(String key) {
        return ((List)this.unlockGroups.getOrDefault((Object)key, Collections.emptyList())).size();
    }

    @Nullable
    public Set<String> getKeySet() {
        return this.unlockGroups.keySet();
    }

    public void addTradeToEntry(String key, @Nullable TradeEntry entry) {
        if (entry == null) {
            return;
        }
        ((List)this.unlockGroups.computeIfAbsent((Object)key, k -> new ArrayList())).add(entry);
    }

    public List<TradeEntry> getTradeEntryList(String key) {
        List entries = (List)this.unlockGroups.getOrDefault((Object)key, Collections.emptyList());
        return Collections.unmodifiableList(entries);
    }

    @Nullable
    public TradeEntry getTradeEntry(String key, int index) {
        List tradeList = (List)this.unlockGroups.get((Object)key);
        if (tradeList == null || index < 0 || index >= tradeList.size()) {
            return null;
        }
        return (TradeEntry)tradeList.get(index);
    }
}

