/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.ae;

import appeng.api.behaviors.ExternalStorageStrategy;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.features.IPlayerRegistry;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.core.AppEng;
import appeng.core.stats.AdvancementTriggers;
import appeng.helpers.InterfaceLogicHost;
import appeng.items.parts.PartModels;
import appeng.me.GridNode;
import appeng.me.service.EnergyService;
import appeng.me.service.StorageService;
import appeng.me.storage.CompositeStorage;
import appeng.me.storage.MEInventoryHandler;
import appeng.me.storage.NullInventory;
import appeng.menu.me.items.CraftingTermMenu;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractTerminalPart;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import com.gtolib.GTOCore;
import com.gtolib.api.ae2.ExternalStorageCacheStrategy;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SimpleCraftingTerminal
extends AbstractTerminalPart
implements IAEPowerStorage,
IStorageProvider {
    public static final ResourceLocation INV_CRAFTING = AppEng.makeId((String)"crafting_terminal_crafting");
    @PartModels
    public static final ResourceLocation MODEL = GTOCore.id((String)"block/crafting_terminal");
    public static final IPartModel MODELS = new PartModel(MODEL);
    private final AppEngInternalInventory craftingGrid = new AppEngInternalInventory((InternalInventoryHost)this, 9);
    private final StorageBusInventory handler = new StorageBusInventory(NullInventory.of());
    @Nullable
    private Map<AEKeyType, ExternalStorageStrategy> externalStorageStrategies;
    private int tick;

    public SimpleCraftingTerminal(IPartItem<?> partItem) {
        super(partItem);
    }

    public boolean isActive() {
        return true;
    }

    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        this.updateTarget();
        return super.onPartActivate(player, hand, pos);
    }

    public void m_6211_() {
        super.m_6211_();
        this.craftingGrid.clear();
    }

    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.craftingGrid.readFromNBT(data, "craftingGrid");
    }

    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        this.craftingGrid.writeToNBT(data, "craftingGrid");
    }

    public MenuType<?> getMenuType(Player p) {
        return CraftingTermMenu.TYPE;
    }

    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)INV_CRAFTING)) {
            return this.craftingGrid;
        }
        return super.getSubInventory(id);
    }

    public IPartModel getStaticModels() {
        return MODELS;
    }

    public MEStorage getInventory() {
        if (this.getBlockEntity().m_58901_()) {
            return null;
        }
        if (!this.isClientSide()) {
            MEStorage mEStorage;
            if (this.tick % 10 == 0 && (mEStorage = this.handler.getDelegate()) instanceof CompositeStorage) {
                CompositeStorage compositeStorage = (CompositeStorage)mEStorage;
                compositeStorage.onTick();
            }
            ++this.tick;
        }
        return this.handler.getDelegate();
    }

    public void addToWorld() {
        super.addToWorld();
        this.updateNode();
    }

    public boolean canBePlacedOn(BusSupport what) {
        return false;
    }

    private void updateNode() {
        GridNode node = (GridNode)this.getMainNode().getNode();
        if (node != null) {
            node.addService(IAEPowerStorage.class, (IGridNodeService)this);
            node.addService(IStorageProvider.class, (IGridNodeService)this);
            node.setIdlePowerUsage(0.0);
            EnergyService energyService = (EnergyService)node.getGrid().getEnergyService();
            StorageService storageService = (StorageService)node.getGrid().getStorageService();
            storageService.addNode((IGridNode)node, null);
            energyService.addNode((IGridNode)node, null);
        }
    }

    private void updateTarget() {
        if (this.isClientSide()) {
            return;
        }
        Direction side = this.getSide();
        if (side == null) {
            return;
        }
        Reference2ReferenceOpenHashMap foundExternalApi = new Reference2ReferenceOpenHashMap(2);
        this.findExternalStorages((Map<AEKeyType, MEStorage>)foundExternalApi);
        Component component = this.handler.getDescription();
        if (component instanceof CompositeStorage) {
            CompositeStorage compositeStorage = (CompositeStorage)component;
            if (!foundExternalApi.isEmpty()) {
                compositeStorage.setStorages((Map)foundExternalApi);
                return;
            }
        }
        Object newInventory = !foundExternalApi.isEmpty() ? new CompositeStorage((Map)foundExternalApi) : NullInventory.of();
        this.handler.setDelegate((MEStorage)newInventory);
    }

    private Map<AEKeyType, ExternalStorageStrategy> getExternalStorageStrategies() {
        if (this.externalStorageStrategies == null) {
            BlockEntity host = this.getHost().getBlockEntity();
            Direction side = this.getSide();
            this.externalStorageStrategies = ExternalStorageCacheStrategy.createExternalStorageStrategies((BlockEntity)host, (BlockPos)host.m_58899_().m_121945_(side), (Direction)side, (Direction)side.m_122424_());
        }
        return this.externalStorageStrategies;
    }

    private void findExternalStorages(Map<AEKeyType, MEStorage> storages) {
        for (Map.Entry<AEKeyType, ExternalStorageStrategy> entry : this.getExternalStorageStrategies().entrySet()) {
            MEStorage wrapper = entry.getValue().createWrapper(false, this::invalidateOnExternalStorageChange);
            if (wrapper == null) continue;
            storages.put(entry.getKey(), wrapper);
        }
    }

    private void invalidateOnExternalStorageChange() {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
    }

    private void checkStorageBusOnInterface() {
        MinecraftServer server;
        ServerPlayer player;
        BlockEntity targetBe;
        Direction oppositeSide = this.getSide().m_122424_();
        BlockPos targetPos = this.getBlockEntity().m_58899_().m_121945_(this.getSide());
        BlockEntity targetHost = targetBe = this.getLevel().m_7702_(targetPos);
        if (targetBe instanceof IPartHost) {
            IPartHost partHost = (IPartHost)targetBe;
            targetHost = partHost.getPart(oppositeSide);
        }
        if (targetHost instanceof InterfaceLogicHost && (player = IPlayerRegistry.getConnected((MinecraftServer)(server = this.getLevel().m_7654_()), (int)this.getActionableNode().getOwningPlayerId())) != null) {
            AdvancementTriggers.RECURSIVE.trigger(player);
        }
    }

    public void addAdditionalDrops(List<ItemStack> drops, boolean wrenched) {
        super.addAdditionalDrops(drops, wrenched);
        for (ItemStack is : this.craftingGrid) {
            if (is.m_41619_()) continue;
            drops.add(is);
        }
    }

    public void mountInventories(IStorageMounts storageMounts) {
        storageMounts.mount((MEStorage)this.handler, 1);
    }

    public double injectAEPower(double amt, Actionable mode) {
        return 0.0;
    }

    public double getAEMaxPower() {
        return 9.223372036854776E14;
    }

    public double getAECurrentPower() {
        return 9.223372036854776E14;
    }

    public boolean isAEPublicPowerStorage() {
        return true;
    }

    public AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    public double extractAEPower(double amt, Actionable mode, PowerMultiplier pm) {
        return amt;
    }

    private static class StorageBusInventory
    extends MEInventoryHandler {
        StorageBusInventory(MEStorage inventory) {
            super(inventory);
        }

        protected MEStorage getDelegate() {
            return super.getDelegate();
        }

        protected void setDelegate(MEStorage delegate) {
            super.setDelegate(delegate);
        }
    }
}

