/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.emi.space;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.api.data.DimensionMarker;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTDimensionMarkers;
import com.gregtechceu.gtceu.common.data.GTRecipeCapabilities;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.machines.MultiBlockG;
import com.gtocore.common.machine.multiblock.electric.space.SatelliteControlCenterMachine;
import com.gtocore.integration.emi.space.SatelliteEmiRecipe;
import com.gtolib.GTOCore;
import com.gtolib.api.data.Dimension;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class SatelliteEmiCategory
extends EmiRecipeCategory {
    static final EmiRecipeCategory CATEGORY = new SatelliteEmiCategory();

    private SatelliteEmiCategory() {
        super(GTOCore.id((String)"satellite"), (EmiRenderable)EmiStack.of(GTOItems.PLANET_DATA_CHIP));
    }

    public Component getName() {
        return Component.m_237115_((String)"gtocore.satellite_control_center.emi.launch_satellite");
    }

    public static void register(EmiRegistry registry) {
        registry.addCategory(CATEGORY);
        registry.addWorkstation(CATEGORY, (EmiIngredient)EmiStack.of((ItemStack)MultiBlockG.SATELLITE_CONTROL_CENTER.asStack()));
        for (Dimension entry : SatelliteControlCenterMachine.getPlanets()) {
            ImmutableMap.Builder inputs = ImmutableMap.builder();
            ImmutableMap.Builder outputs = ImmutableMap.builder();
            if (SatelliteControlCenterMachine.getRocket(entry.getTier()) == null) continue;
            DimensionMarker dimMarker = (DimensionMarker)GTRegistries.DIMENSION_MARKERS.getOrDefault((Object)entry.getLocation(), (Object)GTDimensionMarkers.OVERWORLD);
            inputs.put((Object)GTRecipeCapabilities.ITEM, List.of(SatelliteEmiCategory.consume(GTRecipeCapabilities.ITEM.of(GTOItems.PLANET_DATA_CHIP)), SatelliteEmiCategory.consume(GTRecipeCapabilities.ITEM.of(GTOItems.PLANET_SCAN_SATELLITE)), SatelliteEmiCategory.consume(GTRecipeCapabilities.ITEM.of((Object)SatelliteControlCenterMachine.getRocket(entry.getTier())))));
            inputs.put((Object)GTRecipeCapabilities.FLUID, List.of(SatelliteEmiCategory.consume(GTRecipeCapabilities.FLUID.of((Object)SatelliteControlCenterMachine.getFuel(entry.getTier())))));
            outputs.put((Object)GTRecipeCapabilities.ITEM, List.of(SatelliteEmiCategory.consume(GTRecipeCapabilities.ITEM.of((Object)dimMarker.getIcon()))));
            registry.addRecipe((EmiRecipe)SatelliteEmiRecipe.fromInputOutput(GTOCore.id((String)"gtocoresatellite").m_266382_("/launch_satellite/" + entry.getKey()), inputs.build(), outputs.build()));
        }
    }

    private static Content consume(Object ing) {
        return new Content(ing, 10000, 0);
    }
}

