/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.jade.provider;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.capabilities.Capabilities;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.integration.jade.provider.CapabilityBlockProvider;
import com.gtolib.GTOCore;
import com.gtolib.api.ae2.IExpandedGrid;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.blockentity.IObserved;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

@DataGeneratorScanned
public final class AEGridProvider
extends CapabilityBlockProvider<IExpandedGrid> {
    public static boolean OBSERVE = false;
    @RegisterLanguage(cn="\u8282\u70b9\u6570\u91cf\uff1a%s", en="Node Amount: %s")
    private static final String NODE_AMOUNT = "gtocore.jade.node_amount";
    @RegisterLanguage(cn="\u7f51\u7edc\u5ef6\u8fdf\uff1a%s", en="Grid Latency: %s")
    public static final String LATENCY = "gtocore.jade.grid_latency";

    public AEGridProvider() {
        super(GTOCore.id((String)"ae_grid_provider"));
    }

    @Nullable
    protected IExpandedGrid getCapability(Level level, BlockPos pos, BlockEntity blockEntity, @Nullable Direction side) {
        IInWorldGridNodeHost host;
        if (side != null || blockEntity == null) {
            return null;
        }
        if (blockEntity instanceof IObserved) {
            IObserved observed = (IObserved)blockEntity;
            observed.onObserved();
        } else {
            MetaMachine machine = MetaMachine.getMachine((BlockEntity)blockEntity);
            if (machine != null) {
                machine.observe();
            }
        }
        IInWorldGridNodeHost cap = blockEntity instanceof IInWorldGridNodeHost ? (host = (IInWorldGridNodeHost)blockEntity) : (IInWorldGridNodeHost)blockEntity.getCapability(Capabilities.IN_WORLD_GRID_NODE_HOST).orElse(null);
        if (cap != null) {
            for (Direction s : Direction.values()) {
                IGrid iGrid;
                IGridNode node = cap.getGridNode(s);
                if (node == null || !((iGrid = node.getGrid()) instanceof IExpandedGrid)) continue;
                IExpandedGrid grid = (IExpandedGrid)iGrid;
                grid.observe();
                return grid;
            }
        }
        return null;
    }

    protected void write(CompoundTag data, IExpandedGrid capability) {
        if (capability != null) {
            data.m_128359_("name", capability.toString());
            data.m_128405_("size", capability.size());
            data.m_128356_("latency", capability.getLatency());
        }
    }

    protected void addTooltip(CompoundTag capData, ITooltip tooltip, Player player, BlockAccessor block, BlockEntity blockEntity, IPluginConfig config) {
        String name = capData.m_128461_("name");
        if (name.isEmpty()) {
            return;
        }
        tooltip.add((Component)Component.m_237115_((String)name));
        tooltip.add((Component)Component.m_237110_((String)NODE_AMOUNT, (Object[])new Object[]{capData.m_128451_("size")}));
        long latency = capData.m_128451_("latency");
        if (latency == 0L) {
            return;
        }
        tooltip.add((Component)Component.m_237110_((String)LATENCY, (Object[])new Object[]{latency}).m_130946_(" \u03bcs"));
    }
}

