/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.steam.SimpleSteamMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.client.util.TooltipHelper;
import com.gregtechceu.gtceu.common.machine.multiblock.steam.SteamParallelMultiblockMachine;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gregtechceu.gtceu.utils.PosUtils;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.machine.feature.DummyEnergyMachine;
import com.gtolib.api.machine.feature.ICustomElectricMachine;
import com.gtolib.api.machine.feature.multiblock.ICrossRecipeMachine;
import com.gtolib.api.machine.mana.feature.IManaEnergyMachine;
import com.gtolib.api.machine.trait.IEnhancedRecipeLogic;
import com.gtolib.api.recipe.RecipeHelper;
import com.gtolib.utils.NumberUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

@DataGeneratorScanned
public final class RecipeLogicProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    @RegisterLanguage(cn="\u8be5\u673a\u5668\u6240\u5728\u533a\u5757\u672a\u5f3a\u5236\u52a0\u8f7d", en="The chunk the machine is in is not forced loaded")
    private static final String LOADED = "gtocore.machine.forced_loaded";

    public ResourceLocation getUid() {
        return GTCEu.id((String)"recipe_logic_provider");
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        CompoundTag capData = blockAccessor.getServerData();
        if (capData.m_128471_("notLoaded")) {
            tooltip.add((Component)Component.m_237115_((String)LOADED).m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
        if (capData.m_128471_("Working")) {
            CompoundTag recipeInfo = capData.m_128469_("Recipe");
            if (!recipeInfo.m_128456_()) {
                double totalEu = recipeInfo.m_128459_("totalEu");
                if (totalEu > 0.0) {
                    MutableComponent text = Component.m_237115_((String)(recipeInfo.m_128471_("isGenerator") ? "gtceu.top.energy_production" : "gtceu.top.energy_consumption")).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)NumberUtils.formatDouble((double)totalEu)).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)" EU").m_130940_(ChatFormatting.RESET)).m_7220_((Component)Component.m_237113_((String)" (").m_130940_(ChatFormatting.GREEN));
                    byte tier = GTUtil.getOCTierByVoltage((long)(totalEu > 9.223372036854776E18 ? Long.MAX_VALUE : (long)totalEu));
                    text = text.m_7220_((Component)Component.m_237113_((String)String.format("%sA", FormattingUtil.formatNumber2Places((double)(totalEu / (double)GTValues.VEX[tier])))));
                    if (tier < GTValues.TIER_COUNT) {
                        text = text.m_7220_((Component)Component.m_237113_((String)GTValues.VNF[tier]).m_130938_(style -> style.m_178520_(GTValues.VC[tier])));
                    } else {
                        int speed = tier - 14;
                        text = text.m_7220_((Component)Component.m_237113_((String)"MAX").m_130938_(style -> style.m_131148_(TooltipHelper.rainbowColor((float)speed))).m_7220_((Component)Component.m_237113_((String)"+").m_130938_(style -> style.m_178520_(GTValues.VC[Math.min(14, speed)])).m_7220_((Component)Component.m_237113_((String)FormattingUtil.formatNumbers((int)(tier - 14)))).m_130938_(style -> style.m_178520_(GTValues.VC[Math.min(14, speed)]))));
                    }
                    text = text.m_7220_((Component)Component.m_237113_((String)")").m_130940_(ChatFormatting.GREEN));
                    tooltip.add((Component)text);
                } else {
                    long EUt = recipeInfo.m_128454_("EUt");
                    long Manat = recipeInfo.m_128454_("Manat");
                    boolean isSteam = false;
                    BlockEntity blockEntity = blockAccessor.getBlockEntity();
                    if (blockEntity instanceof MetaMachineBlockEntity) {
                        DummyEnergyMachine energyMachine;
                        MetaMachineBlockEntity mbe = (MetaMachineBlockEntity)blockEntity;
                        MetaMachine machine = mbe.getMetaMachine();
                        if (machine instanceof DummyEnergyMachine && !(energyMachine = (DummyEnergyMachine)machine).jade()) {
                            return;
                        }
                        if (machine instanceof SimpleSteamMachine) {
                            SimpleSteamMachine ssm = (SimpleSteamMachine)machine;
                            EUt = (long)((double)EUt * ssm.getConversionRate());
                            isSteam = true;
                        } else if (machine instanceof SteamParallelMultiblockMachine) {
                            SteamParallelMultiblockMachine smb = (SteamParallelMultiblockMachine)machine;
                            EUt = (long)((double)EUt * smb.getConversionRate());
                            isSteam = true;
                        } else if (EUt > 0L && machine instanceof IManaEnergyMachine) {
                            Manat += EUt;
                            EUt = 0L;
                        }
                    }
                    ArrayList<Component> list = new ArrayList<Component>();
                    RecipeLogicProvider.getEUtTooltip(list, EUt, isSteam);
                    tooltip.addAll(list);
                    if (Manat != 0L) {
                        boolean isInput = Manat > 0L;
                        MutableComponent text = Component.m_237113_((String)FormattingUtil.formatNumbers((long)Math.abs(Manat))).m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)" Mana/t").m_130940_(ChatFormatting.RESET));
                        if (isInput) {
                            tooltip.add((Component)Component.m_237115_((String)"gtocore.recipe.mana_consumption").m_130946_(" ").m_7220_((Component)text));
                        } else {
                            tooltip.add((Component)Component.m_237115_((String)"gtocore.recipe.mana_production").m_130946_(" ").m_7220_((Component)text));
                        }
                    }
                    if (recipeInfo.m_128441_("Origin")) {
                        long parallel = capData.m_128454_("parallel");
                        parallel = Math.max(1L, parallel);
                        long batchParallel = capData.m_128454_("batch_parallel");
                        batchParallel = Math.max(1L, batchParallel);
                        CompoundTag origin = recipeInfo.m_128469_("Origin");
                        if (!origin.m_128456_()) {
                            String key;
                            long originEUt = origin.m_128454_("EUt");
                            long originManat = origin.m_128454_("Manat");
                            double energyEfficiency = 0.0;
                            if (originEUt != 0L && EUt != 0L) {
                                energyEfficiency = (double)EUt * (double)batchParallel / (double)(parallel * originEUt) * 100.0;
                            }
                            double manaEfficiency = 0.0;
                            if (originManat != 0L && Manat != 0L) {
                                manaEfficiency = (double)Manat * (double)batchParallel / (double)(parallel * originManat) * 100.0;
                            }
                            if (energyEfficiency != 0.0) {
                                key = EUt > 0L ? "gtocore.recipe.efficiency" : "gtocore.recipe.efficiency.o";
                                tooltip.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{Component.m_237113_((String)String.format("%s%%", FormattingUtil.formatNumber2Places((double)Math.abs(energyEfficiency)))).m_130940_(ChatFormatting.GOLD)}));
                            }
                            if (manaEfficiency != 0.0) {
                                key = Manat > 0L ? "gtocore.recipe.mana_efficiency" : "gtocore.recipe.mana_efficiency.o";
                                tooltip.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{Component.m_237113_((String)String.format("%s%%", FormattingUtil.formatNumber2Places((double)Math.abs(manaEfficiency)))).m_130940_(ChatFormatting.GOLD)}));
                            }
                            if (origin.m_128441_("MaxProgress")) {
                                int originMaxProgress = origin.m_128451_("MaxProgress");
                                int currentProgress = RecipeLogicProvider.getCurrentMaxProgress(capData);
                                if (originMaxProgress > 0 && currentProgress > 0) {
                                    double timeCost = (double)currentProgress / (double)batchParallel / (double)originMaxProgress * 100.0;
                                    tooltip.add((Component)Component.m_237110_((String)"gtocore.recipe.time_cost_multiplier", (Object[])new Object[]{Component.m_237113_((String)String.format("%s%%", FormattingUtil.formatNumber2Places((double)timeCost))).m_130940_(ChatFormatting.GOLD)}));
                                }
                            }
                        }
                    }
                }
            }
        } else {
            String reason = capData.m_128461_("reason");
            if (reason.isEmpty()) {
                return;
            }
            MutableComponent c = Component.Serializer.m_130701_((String)reason);
            if (c == null) {
                return;
            }
            tooltip.add((Component)c.m_130940_(ChatFormatting.GRAY));
        }
    }

    private static int getCurrentMaxProgress(CompoundTag capData) {
        CompoundTag workable;
        if (capData.m_128441_(GTCEu.id((String)"workable_provider").toString()) && (workable = capData.m_128469_(GTCEu.id((String)"workable_provider").toString())).m_128441_("null")) {
            CompoundTag progress = workable.m_128469_("null");
            return progress.m_128451_("MaxProgress");
        }
        return 0;
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof MetaMachineBlockEntity) {
            IRecipeLogicMachine recipeLogicMachine;
            RecipeLogic capability;
            MetaMachineBlockEntity machineBlock = (MetaMachineBlockEntity)blockEntity;
            Level level = machineBlock.m_58904_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!serverLevel.m_7726_().f_8325_.m_143145_().shouldForceTicks(PosUtils.getChunkLong((BlockPos)machineBlock.m_58899_()))) {
                    compoundTag.m_128379_("notLoaded", true);
                }
            }
            if ((level = machineBlock.metaMachine) instanceof IRecipeLogicMachine && (capability = (recipeLogicMachine = (IRecipeLogicMachine)level).getRecipeLogic()) instanceof IEnhancedRecipeLogic) {
                IEnhancedRecipeLogic recipeLogic = (IEnhancedRecipeLogic)capability;
                if (capability.isIdle() && recipeLogic.gtolib$getIdleReason() != null) {
                    compoundTag.m_128359_("reason", Component.Serializer.m_130703_((Component)recipeLogic.gtolib$getIdleReason()));
                } else if (capability.isWaiting()) {
                    if (!capability.getFancyTooltip().isEmpty()) {
                        compoundTag.m_128359_("reason", Component.Serializer.m_130703_((Component)((Component)capability.getFancyTooltip().get(0))));
                    } else if (recipeLogic.gtolib$getIdleReason() != null) {
                        compoundTag.m_128359_("reason", Component.Serializer.m_130703_((Component)recipeLogic.gtolib$getIdleReason()));
                    }
                } else {
                    compoundTag.m_128379_("Working", capability.isWorking());
                    CompoundTag recipeInfo = RecipeLogicProvider.getRecipeInfo(capability);
                    compoundTag.m_128365_("Recipe", (Tag)recipeInfo);
                }
            }
        }
    }

    @NotNull
    private static CompoundTag getRecipeInfo(RecipeLogic capability) {
        CompoundTag recipeInfo = new CompoundTag();
        GTRecipe recipe = capability.getLastRecipe();
        if (recipe != null) {
            IRecipeLogicMachine iRecipeLogicMachine;
            GTRecipe originRecipe;
            ICustomElectricMachine machine;
            long inputEUt = recipe.getInputEUt();
            long outputEUt = recipe.getOutputEUt();
            long inputManat = RecipeHelper.getInputMANAt((GTRecipe)recipe);
            long outputManat = RecipeHelper.getOutputMANAt((GTRecipe)recipe);
            recipeInfo.m_128356_("EUt", inputEUt - outputEUt);
            recipeInfo.m_128356_("Manat", inputManat - outputManat);
            IRecipeLogicMachine iRecipeLogicMachine2 = capability.machine;
            if (iRecipeLogicMachine2 instanceof ICustomElectricMachine && (machine = (ICustomElectricMachine)iRecipeLogicMachine2).isActivated()) {
                recipeInfo.m_128347_("totalEu", machine.getTotalEu());
                if (machine.isGenerator()) {
                    recipeInfo.m_128379_("isGenerator", true);
                }
            }
            if ((originRecipe = capability.getLastOriginRecipe()) == null && (iRecipeLogicMachine = capability.machine) instanceof ICrossRecipeMachine) {
                ICrossRecipeMachine c = (ICrossRecipeMachine)iRecipeLogicMachine;
                originRecipe = c.getLastRecipes().stream().findFirst().orElse(null);
            }
            if (originRecipe != null) {
                int maxProgress;
                long originInputEUt = originRecipe.getInputEUt();
                long originOutputEUt = originRecipe.getOutputEUt();
                long originInputManat = RecipeHelper.getInputMANAt((GTRecipe)originRecipe);
                long originOutputManat = RecipeHelper.getOutputMANAt((GTRecipe)originRecipe);
                CompoundTag origin = new CompoundTag();
                if (originInputEUt != inputEUt || originOutputEUt != outputEUt || originInputManat != inputManat || originOutputManat != outputManat) {
                    origin.m_128356_("EUt", originInputEUt - originOutputEUt);
                    origin.m_128356_("Manat", originInputManat - originOutputManat);
                }
                if ((maxProgress = originRecipe.duration) > 0) {
                    origin.m_128405_("MaxProgress", maxProgress);
                }
                recipeInfo.m_128365_("Origin", (Tag)origin);
            }
        }
        return recipeInfo;
    }

    public static void getEUtTooltip(List<Component> tooltip, long EUt, boolean isSteam) {
        if (EUt != 0L) {
            MutableComponent text;
            boolean isInput = EUt > 0L;
            EUt = Math.abs(EUt);
            if (isSteam) {
                text = Component.m_237113_((String)FormattingUtil.formatNumbers((long)EUt)).m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)" mB/t").m_130940_(ChatFormatting.RESET));
            } else {
                byte tier = GTUtil.getOCTierByVoltage((long)EUt);
                text = Component.m_237113_((String)FormattingUtil.formatNumbers((long)EUt)).m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237113_((String)" EU/t").m_130940_(ChatFormatting.RESET).m_7220_((Component)Component.m_237113_((String)" (").m_130940_(ChatFormatting.GREEN)));
                text = text.m_7220_((Component)Component.m_237113_((String)String.format("%sA", FormattingUtil.formatNumber2Places((float)((float)EUt / (float)GTValues.VEX[tier])))));
                if (tier < GTValues.TIER_COUNT) {
                    text = text.m_7220_((Component)Component.m_237113_((String)GTValues.VNF[tier]).m_130938_(style -> style.m_178520_(GTValues.VC[tier])));
                } else {
                    int speed = tier - 14;
                    text = text.m_7220_((Component)Component.m_237113_((String)"MAX").m_130938_(style -> style.m_131148_(TooltipHelper.rainbowColor((float)speed))).m_7220_((Component)Component.m_237113_((String)"+").m_130938_(style -> style.m_178520_(GTValues.VC[Math.min(14, speed)])).m_7220_((Component)Component.m_237113_((String)FormattingUtil.formatNumbers((int)(tier - 14)))).m_130938_(style -> style.m_178520_(GTValues.VC[Math.min(14, speed)]))));
                }
                text = text.m_7220_((Component)Component.m_237113_((String)")").m_130940_(ChatFormatting.GREEN));
            }
            if (isInput) {
                tooltip.add((Component)Component.m_237115_((String)"gtceu.top.energy_consumption").m_130946_(" ").m_7220_((Component)text));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"gtceu.top.energy_production").m_130946_(" ").m_7220_((Component)text));
            }
        }
    }
}

