/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.ae2;

import appeng.api.networking.IGridNode;
import appeng.hooks.ticking.TickHandler;
import appeng.me.Grid;
import com.google.common.collect.SetMultimap;
import com.gtocore.integration.jade.provider.AEGridProvider;
import com.gtolib.api.ae2.IExpandedGrid;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Grid.class})
public abstract class GridMixin
implements IExpandedGrid {
    @Unique
    private long gtocore$averageTickTime;
    @Unique
    private long gtocore$totaTickCount;
    @Unique
    private long gtocore$startTime;
    @Unique
    private boolean gtocore$observe;
    @Shadow(remap=false)
    @Final
    private SetMultimap<Class<?>, IGridNode> machines;

    public SetMultimap<Class<?>, IGridNode> getMachines() {
        return this.machines;
    }

    public long getLatency() {
        return this.gtocore$averageTickTime;
    }

    public void observe() {
        this.gtocore$observe = true;
    }

    @Inject(method={"onServerStartTick"}, at={@At(value="INVOKE", target="Lappeng/me/helpers/GridServiceContainer;serverStartTickServices()[Lappeng/api/networking/IGridServiceProvider;")}, remap=false)
    private void onServerStartTick(CallbackInfo ci) {
        if (this.gtocore$observe || AEGridProvider.OBSERVE) {
            this.gtocore$startTime = System.nanoTime();
        }
    }

    @Inject(method={"onServerStartTick"}, at={@At(value="TAIL")}, remap=false)
    private void onServerStartTick2(CallbackInfo ci) {
        if (this.gtocore$observe || AEGridProvider.OBSERVE) {
            this.gtocore$totaTickCount += System.nanoTime() - this.gtocore$startTime;
        }
    }

    @Inject(method={"onServerEndTick"}, at={@At(value="INVOKE", target="Lappeng/me/helpers/GridServiceContainer;serverEndTickServices()[Lappeng/api/networking/IGridServiceProvider;")}, remap=false)
    private void onServerEndTick(CallbackInfo ci) {
        if (this.gtocore$observe || AEGridProvider.OBSERVE) {
            this.gtocore$startTime = System.nanoTime();
        }
    }

    @Inject(method={"onServerEndTick"}, at={@At(value="TAIL")}, remap=false)
    private void onServerEndTick2(CallbackInfo ci) {
        if (this.gtocore$observe || AEGridProvider.OBSERVE) {
            this.gtocore$totaTickCount += System.nanoTime() - this.gtocore$startTime;
            if ((TickHandler.instance().getCurrentTick() & 0x3FL) == 0L) {
                this.gtocore$observe = false;
                this.gtocore$averageTickTime = this.gtocore$totaTickCount / 128000L;
                this.gtocore$totaTickCount = 0L;
            }
            if (AEGridProvider.OBSERVE) {
                IExpandedGrid.PERFORMANCE_MAP.put(this, this.gtocore$averageTickTime);
            }
        }
    }

    @Inject(method={"onLevelStartTick"}, at={@At(value="INVOKE", target="Lappeng/me/helpers/GridServiceContainer;levelStartTickServices()[Lappeng/api/networking/IGridServiceProvider;")}, remap=false)
    private void onLevelStartTick(CallbackInfo ci) {
        if (this.gtocore$observe || AEGridProvider.OBSERVE) {
            this.gtocore$startTime = System.nanoTime();
        }
    }

    @Inject(method={"onLevelStartTick"}, at={@At(value="TAIL")}, remap=false)
    private void onLevelStartTick2(CallbackInfo ci) {
        if (this.gtocore$observe || AEGridProvider.OBSERVE) {
            this.gtocore$totaTickCount += System.nanoTime() - this.gtocore$startTime;
        }
    }
}

