/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.ae2.menu;

import appeng.api.config.Actionable;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.MEStorage;
import appeng.core.definitions.AEItems;
import appeng.helpers.IMenuCraftingPacket;
import appeng.helpers.IPatternTerminalMenuHost;
import appeng.menu.guisync.GuiSync;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.parts.encoding.PatternEncodingLogic;
import appeng.util.ConfigInventory;
import com.gtocore.api.ae2.pattern.IEncodingLogic;
import com.gtolib.api.ae2.IPatterEncodingTermMenu;
import com.gtolib.api.ae2.pattern.PatternUtils;
import com.gtolib.api.player.IEnhancedPlayer;
import com.gtolib.utils.ClientUtil;
import com.gtolib.utils.RLUtils;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PatternEncodingTermMenu.class})
public abstract class PatternEncodingTermMenuMixin
extends MEStorageMenu
implements IMenuCraftingPacket,
IPatterEncodingTermMenu {
    @Unique
    @GuiSync(value=122)
    public boolean gtolib$extraInfoEnabled = true;
    @Shadow(remap=false)
    @Final
    private ConfigInventory encodedInputsInv;
    @Shadow(remap=false)
    @Final
    private ConfigInventory encodedOutputsInv;
    @Final
    @Shadow(remap=false)
    private RestrictedInputSlot encodedPatternSlot;
    @Final
    @Shadow(remap=false)
    private RestrictedInputSlot blankPatternSlot;
    @Shadow(remap=false)
    @Final
    private PatternEncodingLogic encodingLogic;
    @Unique
    @GuiSync(value=120)
    public String gtocore$recipe = "";
    @Unique
    private UUID gtocore$UUID;
    @Unique
    private static final String TITLE_ENABLED = "gtocore.pattern.recipeInfoButton.title.enabled";
    @Unique
    private static final String TITLE_DISABLED = "gtocore.pattern.recipeInfoButton.title.disabled";
    @Unique
    private static final String CLICK_TO_ENABLE = "gtocore.pattern.recipeInfoButton.clickToEnable";
    @Unique
    private static final String CLICK_TO_DISABLE = "gtocore.pattern.recipeInfoButton.clickToDisable";
    @Unique
    private static final String CLICK_TO_CLEAR = "gtocore.pattern.recipeInfoButton.clickToClear";

    protected PatternEncodingTermMenuMixin(MenuType<?> menuType, int id, Inventory ip, ITerminalHost host) {
        super(menuType, id, ip, host);
    }

    @Unique
    private IEncodingLogic gtolib$logic() {
        return (IEncodingLogic)this.encodingLogic;
    }

    public void gtolib$addRecipe(String id) {
        if (this.isClientSide()) {
            this.sendClientAction("addRecipe", id);
        } else {
            this.gtolib$logic().gtocore$setRecipe(id);
        }
    }

    public void gtolib$addUUID(UUID id) {
        if (this.isClientSide()) {
            this.sendClientAction("addUUID", id);
        } else {
            this.gtocore$UUID = id;
        }
    }

    public void gtolib$clickRecipeInfo() {
        if (this.isClientSide()) {
            this.sendClientAction("clickRecipeInfo");
            return;
        }
        if (this.gtolib$extraInfoEnabled && !this.gtolib$logic().gtocore$getRecipe().isEmpty()) {
            this.gtolib$logic().gtocore$clearExtraRecipeInfo();
            return;
        }
        this.gtolib$logic().gtocore$clearExtraRecipeInfo();
        this.gtolib$extraInfoEnabled = !this.gtolib$extraInfoEnabled;
    }

    public Component gtolib$getRecipeInfoTooltip() {
        MutableComponent title = Component.m_237119_();
        title.m_7220_((Component)(this.gtolib$extraInfoEnabled ? Component.m_237115_((String)TITLE_ENABLED) : Component.m_237115_((String)TITLE_DISABLED)));
        title.m_130946_("\n");
        if (!this.gtolib$extraInfoEnabled) {
            return title.m_7220_((Component)Component.m_237115_((String)CLICK_TO_ENABLE));
        }
        if (!this.gtocore$recipe.isEmpty()) {
            MutableComponent tooltip = Component.m_237119_();
            tooltip.m_7220_((Component)Component.m_237115_((String)"gtocore.pattern.recipe")).m_130946_("\n");
            String key = RLUtils.parse((String)this.gtocore$recipe.split("/")[0]).m_214298_();
            tooltip.m_7220_((Component)Component.m_237110_((String)"gtocore.pattern.type", (Object[])new Object[]{Component.m_237115_((String)key)})).m_130946_("\n");
            return title.m_7220_((Component)tooltip.m_7220_((Component)Component.m_237115_((String)CLICK_TO_CLEAR)));
        }
        return title.m_7220_((Component)Component.m_237115_((String)CLICK_TO_DISABLE));
    }

    @Inject(method={"encodeProcessingPattern"}, at={@At(value="RETURN")}, remap=false)
    private void encodeProcessingPatternHook(CallbackInfoReturnable<ItemStack> cir) {
        if (this.gtolib$extraInfoEnabled && !this.gtolib$logic().gtocore$getRecipe().isEmpty()) {
            ((ItemStack)cir.getReturnValue()).m_41784_().m_128359_("recipe", this.gtolib$logic().gtocore$getRecipe());
        }
        if (this.gtocore$UUID != null) {
            ((ItemStack)cir.getReturnValue()).m_41784_().m_128362_("uuid", this.gtocore$UUID);
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/world/inventory/MenuType;ILnet/minecraft/world/entity/player/Inventory;Lappeng/helpers/IPatternTerminalMenuHost;Z)V"}, at={@At(value="TAIL")}, remap=false)
    private void initHooks(MenuType<?> menuType, int id, Inventory ip, IPatternTerminalMenuHost host, boolean bindInventory, CallbackInfo ci) {
        this.registerClientAction("modifyPatter", Integer.class, this::gtolib$modifyPatter);
        this.registerClientAction("clearSecOutput", this::gtolib$clearSecOutput);
        this.blankPatternSlot.setStackLimit(1);
        this.registerClientAction("addRecipe", String.class, this::gtolib$addRecipe);
        this.registerClientAction("clickRecipeInfo", this::gtolib$clickRecipeInfo);
        this.registerClientAction("addUUID", UUID.class, this::gtolib$addUUID);
    }

    public void gtolib$modifyPatter(Integer data) {
        if (this.isClientSide()) {
            this.sendClientAction("modifyPatter", data);
        } else {
            PatternUtils.mulPatternEncodingArea((ConfigInventory)this.encodedInputsInv, (ConfigInventory)this.encodedOutputsInv, (int)data);
        }
    }

    @Unique
    public void gtolib$clearSecOutput() {
        if (this.isClientSide()) {
            this.sendClientAction("clearSecOutput");
        } else {
            for (int i = 1; i <= 8; ++i) {
                this.encodedOutputsInv.setStack(i, null);
            }
        }
    }

    @Inject(method={"encode"}, at={@At(value="INVOKE", target="Lappeng/menu/me/items/PatternEncodingTermMenu;sendClientAction(Ljava/lang/String;)V")}, remap=false)
    private void encode(CallbackInfo ci) {
        this.gtolib$addUUID(ClientUtil.getUUID());
    }

    @Inject(method={"encode"}, at={@At(value="INVOKE", target="Lappeng/menu/slot/RestrictedInputSlot;set(Lnet/minecraft/world/item/ItemStack;)V", ordinal=1, remap=true)}, remap=false, cancellable=true)
    private void encoding(CallbackInfo ci, @Local(name={"encodedPattern"}) ItemStack stack) {
        Player player = this.getPlayer();
        if (player instanceof IEnhancedPlayer) {
            Inventory inventory;
            IEnhancedPlayer enhancedPlayer = (IEnhancedPlayer)player;
            if (enhancedPlayer.getPlayerData().shiftState && (inventory = player.m_150109_()).m_36054_(stack)) {
                this.encodedPatternSlot.clearStack();
                ci.cancel();
            }
        }
    }

    @Inject(method={"clearPattern"}, at={@At(value="HEAD")}, remap=false)
    private void clearInventoryPattern(CallbackInfo ci) {
        Player player = this.getPlayer();
        if (player instanceof IEnhancedPlayer) {
            IEnhancedPlayer enhancedPlayer = (IEnhancedPlayer)player;
            if (enhancedPlayer.getPlayerData().shiftState) {
                Inventory inventory = player.m_150109_();
                for (int i = 0; i < inventory.m_6643_(); ++i) {
                    ItemStack itemStack = inventory.m_8020_(i);
                    if (!PatternDetailsHelper.isEncodedPattern((ItemStack)itemStack)) continue;
                    inventory.m_6836_(i, AEItems.BLANK_PATTERN.stack(itemStack.m_41613_()));
                }
            }
        }
    }

    @Inject(method={"broadcastChanges"}, at={@At(value="TAIL")})
    public void broadcastChanges(CallbackInfo ci) {
        if (this.isServerSide()) {
            this.gtocore$recipe = this.gtolib$logic().gtocore$getRecipe();
        }
    }

    @Shadow(remap=false)
    protected abstract boolean isPattern(ItemStack var1);

    @Shadow(remap=false)
    public abstract void encode();

    @Inject(method={"encode"}, at={@At(value="INVOKE", target="Lappeng/menu/me/items/PatternEncodingTermMenu;isPattern(Lnet/minecraft/world/item/ItemStack;)Z", remap=false)}, remap=false, cancellable=true)
    private void tryAutoRefillBlankPattern(CallbackInfo ci, @Local(name={"encodeOutput"}) ItemStack blankPattern) {
        if (!this.isPattern(blankPattern) && this.gtolib$tryRefillBlankPattern()) {
            ci.cancel();
            this.encode();
        }
    }

    @Unique
    private boolean gtolib$tryRefillBlankPattern() {
        ITerminalHost host = this.getHost();
        if (host == null) {
            return false;
        }
        MEStorage inventory = host.getInventory();
        if (inventory == null) {
            return false;
        }
        AEItemKey blankPattern = AEItemKey.of((ItemLike)AEItems.BLANK_PATTERN);
        long supplier = inventory.getAvailableStacks().get((AEKey)blankPattern);
        if (supplier <= 0L) {
            return false;
        }
        int stock = this.blankPatternSlot.m_7993_().m_41613_();
        long demand = Math.min(supplier, (long)(1 - stock));
        if (demand <= 0L) {
            return false;
        }
        long extracted = inventory.extract((AEKey)blankPattern, demand, Actionable.MODULATE, this.getActionSource());
        if (extracted <= 0L) {
            return false;
        }
        this.blankPatternSlot.m_5852_(blankPattern.toStack().m_255036_(stock + (int)extracted));
        return true;
    }

    @Redirect(method={"transferStackToMenu"}, at=@At(value="INVOKE", target="Lappeng/menu/slot/RestrictedInputSlot;mayPlace(Lnet/minecraft/world/item/ItemStack;)Z", remap=true), remap=false)
    private boolean gtolib$modifyTransferStackToMenu(RestrictedInputSlot instance, ItemStack itemStack) {
        return itemStack.m_41720_() != AEItems.BLANK_PATTERN.m_5456_() && instance.m_5857_(itemStack);
    }
}

