/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.ae2.storage;

import appeng.api.config.Actionable;
import appeng.api.config.IncludeExclude;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyMap;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.me.cells.BasicCellInventory;
import appeng.util.prioritylist.IPartitionList;
import com.gregtechceu.gtceu.GTCEu;
import com.gtolib.api.ae2.stacks.IKeyCounter;
import com.gtolib.api.ae2.storage.CellDataStorage;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BasicCellInventory.class})
public abstract class BasicCellInventoryMixin
implements StorageCell {
    @Unique
    private static final String USED_BYTE = "byte";
    @Unique
    private static final String USED_TYPE = "type";
    @Unique
    private CellDataStorage gtolib$cache;
    @Unique
    private AEKeyMap<AEKey> gtocore$aeKeyMap;
    @Unique
    private UUID gtolib$uuid;
    @Unique
    private int gtolib$totalbytes;
    @Unique
    private long gtolib$totalAmount;
    @Shadow(remap=false)
    @Final
    private ItemStack i;
    @Shadow(remap=false)
    @Final
    private ISaveProvider container;
    @Shadow(remap=false)
    @Final
    private IBasicCellItem cellType;
    @Shadow(remap=false)
    @Final
    private AEKeyType keyType;
    @Shadow(remap=false)
    @Final
    private boolean hasVoidUpgrade;
    @Shadow(remap=false)
    @Final
    private IPartitionList partitionList;
    @Shadow(remap=false)
    @Final
    private IncludeExclude partitionListMode;

    @Shadow(remap=false)
    public abstract boolean isPreformatted();

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void gtolib$init(IBasicCellItem cellType, ItemStack o, ISaveProvider container, CallbackInfo ci) {
        this.gtolib$totalbytes = Math.min(262144, cellType.getBytes(o));
        this.gtolib$totalAmount = (long)this.gtolib$totalbytes * (long)this.keyType.getAmountPerByte();
    }

    @Unique
    @Nullable
    private UUID gtolib$getUUID() {
        Tag uuid;
        CompoundTag tag;
        if (this.gtolib$uuid == null && (tag = this.i.m_41783_()) != null && (uuid = tag.m_128423_("u")) != null && uuid.m_6458_() == IntArrayTag.f_128599_ && ((IntArrayTag)uuid).m_128648_().length == 4) {
            this.gtolib$uuid = NbtUtils.m_129233_((Tag)uuid);
        }
        return this.gtolib$uuid;
    }

    @Unique
    @NotNull
    private AEKeyMap<AEKey> gtolib$getCellStoredMap() {
        if (this.gtocore$aeKeyMap == null) {
            CellDataStorage storage = this.gtolib$getCellStorage();
            if (storage == CellDataStorage.EMPTY) {
                return CellDataStorage.EMPTY.getStoredMap();
            }
            this.gtocore$aeKeyMap = storage.getStoredMap();
            if (this.gtocore$aeKeyMap == null) {
                this.gtocore$aeKeyMap = new AEKeyMap();
                storage.setStoredMap(this.gtocore$aeKeyMap);
            } else {
                double totalAmount = 0.0;
                LongIterator longIterator = this.gtocore$aeKeyMap.values().iterator();
                while (longIterator.hasNext()) {
                    long amount = (Long)longIterator.next();
                    totalAmount += (double)amount / (double)this.keyType.getAmountPerByte();
                }
                storage.setBytes(totalAmount);
                CompoundTag tag = this.i.m_41783_();
                if (tag != null) {
                    tag.m_128356_(USED_BYTE, (long)totalAmount);
                    tag.m_128405_(USED_TYPE, this.gtocore$aeKeyMap.size());
                }
            }
        }
        return this.gtocore$aeKeyMap;
    }

    @Unique
    @NotNull
    private CellDataStorage gtolib$getCellStorage() {
        if (this.gtolib$cache != null) {
            return this.gtolib$cache;
        }
        if (GTCEu.isClientThread()) {
            return CellDataStorage.EMPTY;
        }
        UUID uuid = this.gtolib$getUUID();
        if (uuid == null) {
            this.gtolib$cache = CellDataStorage.EMPTY;
            return this.gtolib$cache;
        }
        this.gtolib$cache = CellDataStorage.get((UUID)uuid);
        return this.gtolib$cache;
    }

    @Overwrite(remap=false)
    public long getTotalBytes() {
        return this.gtolib$totalbytes;
    }

    @Overwrite(remap=false)
    public boolean canHoldNewItem() {
        CellDataStorage data = this.gtolib$getCellStorage();
        return data.getBytes() <= (double)this.gtolib$totalbytes;
    }

    @Overwrite(remap=false)
    public long getUsedBytes() {
        if (GTCEu.isClientThread()) {
            CompoundTag tag = this.i.m_41783_();
            if (tag == null) {
                return 0L;
            }
            return tag.m_128454_(USED_BYTE);
        }
        return (long)this.gtolib$getCellStorage().getBytes();
    }

    @Overwrite(remap=false)
    public long getStoredItemCount() {
        return (long)this.gtolib$getCellStorage().getBytes();
    }

    @Overwrite(remap=false)
    public long getStoredItemTypes() {
        if (GTCEu.isClientThread()) {
            CompoundTag tag = this.i.m_41783_();
            if (tag == null) {
                return 0L;
            }
            return tag.m_128454_(USED_TYPE);
        }
        return this.gtolib$getCellStoredMap().size();
    }

    @Overwrite(remap=false)
    public void persist() {
        AEKeyMap<AEKey> map = this.gtolib$getCellStoredMap();
        double totalAmount = 0.0;
        LongIterator longIterator = map.values().iterator();
        while (longIterator.hasNext()) {
            long amount = (Long)longIterator.next();
            totalAmount += (double)amount / (double)this.keyType.getAmountPerByte();
        }
        CellDataStorage storage = this.gtolib$getCellStorage();
        storage.setBytes(totalAmount);
        CompoundTag tag = this.i.m_41783_();
        if (tag != null) {
            tag.m_128356_(USED_BYTE, (long)totalAmount);
            tag.m_128405_(USED_TYPE, map.size());
        }
    }

    @Overwrite(remap=false)
    protected void saveChanges() {
        if (this.container != null) {
            double totalAmount = 0.0;
            LongIterator longIterator = this.gtolib$getCellStoredMap().values().iterator();
            while (longIterator.hasNext()) {
                long amount = (Long)longIterator.next();
                totalAmount += (double)amount / (double)this.keyType.getAmountPerByte();
            }
            this.gtolib$getCellStorage().setBytes(totalAmount);
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    @Overwrite(remap=false)
    public void getAvailableStacks(KeyCounter out) {
        AEKeyMap<AEKey> map = this.gtolib$getCellStoredMap();
        IKeyCounter.addAll((KeyCounter)out, (int)map.size(), m -> map.reference2LongEntrySet().fastForEach(e -> m.addTo((Object)((AEKey)e.getKey()), e.getLongValue())));
    }

    @Overwrite(remap=false)
    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount == 0L || !this.keyType.contains(what)) {
            return 0L;
        }
        if (!this.partitionList.matchesFilter(what, this.partitionListMode)) {
            return 0L;
        }
        if (this.cellType.isBlackListed(this.i, what)) {
            return 0L;
        }
        long inserted = this.innerInsert(what, amount, mode);
        if (!this.isPreformatted() && this.hasVoidUpgrade && !this.canHoldNewItem()) {
            return this.gtolib$getCellStoredMap().containsKey((Object)what) ? amount : inserted;
        }
        return this.hasVoidUpgrade ? amount : inserted;
    }

    @Overwrite(remap=false)
    private long innerInsert(AEKey what, long amount, Actionable mode) {
        CellDataStorage data;
        if (this.gtolib$getUUID() == null) {
            UUID uuid = UUID.randomUUID();
            this.i.m_41784_().m_128362_("u", uuid);
            this.gtolib$cache = CellDataStorage.get((UUID)uuid);
        }
        if ((data = this.gtolib$getCellStorage()) == CellDataStorage.EMPTY) {
            return 0L;
        }
        amount = Math.min(this.gtolib$totalAmount - (long)(data.getBytes() * (double)this.keyType.getAmountPerByte()), amount);
        if (amount < 1L) {
            return 0L;
        }
        if (mode == Actionable.MODULATE) {
            this.gtolib$getCellStoredMap().addTo((Object)what, amount);
            data.setDirty();
            this.saveChanges();
        }
        return amount;
    }

    @Overwrite(remap=false)
    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        AEKeyMap<AEKey> map = this.gtolib$getCellStoredMap();
        long currentAmount = map.getLong((Object)what);
        if (currentAmount > 0L) {
            if (amount >= currentAmount) {
                if (mode == Actionable.MODULATE) {
                    map.remove((Object)what, currentAmount);
                    this.gtolib$getCellStorage().setDirty();
                    this.saveChanges();
                }
                return currentAmount;
            }
            if (mode == Actionable.MODULATE) {
                map.put((Object)what, currentAmount - amount);
                this.gtolib$getCellStorage().setDirty();
                this.saveChanges();
            }
            return amount;
        }
        return 0L;
    }
}

