/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.buildinggadgets2;

import appeng.core.definitions.AEItems;
import com.direwolf20.buildinggadgets2.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketUpdateTemplateManager;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.MiscHelpers;
import com.gtocore.integration.ae.CreateEncodedPattern;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PacketUpdateTemplateManager.class}, remap=false)
public abstract class PacketUpdateTemplateManagerMixin {
    @Inject(method={"handle"}, at={@At(value="HEAD")}, cancellable=true)
    private static void handleAe2PatternPreemptively(PacketUpdateTemplateManager message, Supplier<NetworkEvent.Context> context, CallbackInfo ci) {
        int mode = ((PacketUpdateTemplateManagerMixin)message).getMode();
        String templateName = ((PacketUpdateTemplateManagerMixin)message).getTemplateName();
        ServerPlayer sender = context.get().getSender();
        if (sender == null) {
            return;
        }
        AbstractContainerMenu container = sender.f_36096_;
        if (!(container instanceof TemplateManagerContainer)) {
            return;
        }
        if (mode != 0) {
            return;
        }
        ItemStack templateStack = container.m_38853_(1).m_7993_();
        if (!templateStack.m_150930_(AEItems.BLANK_PATTERN.m_5456_()) && !templateStack.m_150930_(AEItems.PROCESSING_PATTERN.m_5456_())) {
            return;
        }
        ItemStack gadgetStack = container.m_38853_(0).m_7993_();
        UUID sourceUUID = GadgetNBT.getUUID((ItemStack)gadgetStack);
        BG2Data bg2Data = BG2Data.get((ServerLevel)Objects.requireNonNull(sender.m_20194_()).m_129783_());
        ArrayList buildList = bg2Data.getCopyPasteList(sourceUUID, false);
        if (buildList == null || buildList.isEmpty()) {
            MiscHelpers.playSound((ServerPlayer)sender, (Holder)Holder.m_205709_((Object)SoundEvent.m_262824_((ResourceLocation)SoundEvents.f_276627_.m_11660_())));
            ci.cancel();
            return;
        }
        ItemStack encodedPattern = CreateEncodedPattern.FromBuildList(buildList, templateName);
        container.m_182406_(1, container.m_182424_(), encodedPattern);
        MiscHelpers.playSound((ServerPlayer)sender, (Holder)Holder.m_205709_((Object)SoundEvent.m_262824_((ResourceLocation)SoundEvents.f_11887_.m_11660_())));
        ci.cancel();
    }

    @Accessor(value="mode")
    public abstract int getMode();

    @Accessor(value="templateName")
    public abstract String getTemplateName();
}

