/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm.api.machine;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtolib.api.recipe.ingredient.FastSizedIngredient;
import com.gtolib.api.recipe.ingredient.SimpleIngredient;
import com.gtolib.utils.MathUtil;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={NotifiableItemStackHandler.class})
public abstract class NotifiableItemStackHandlerMiixn
implements IItemHandlerModifiable {
    @Overwrite(remap=false)
    public static List<Ingredient> handleRecipe(IO io, GTRecipe recipe, List<Ingredient> left, boolean simulate, IO handlerIO, CustomItemStackHandler storage) {
        if (io != handlerIO) {
            return left;
        }
        if (io != IO.IN && io != IO.OUT) {
            return left.isEmpty() ? null : left;
        }
        Runnable listener = null;
        if (!simulate) {
            listener = storage.getOnContentsChanged();
            storage.setOnContentsChangedAndfreeze(GTUtil.NOOP);
        }
        boolean changed = false;
        SimpleIngredient[] visited = new SimpleIngredient[storage.size];
        Iterator<Ingredient> it = left.iterator();
        while (it.hasNext()) {
            long amount;
            Ingredient ingredient = it.next();
            if (ingredient.m_43947_()) {
                it.remove();
                continue;
            }
            ItemStack[] items = FastSizedIngredient.getInner((Ingredient)ingredient).m_43908_();
            if (items.length == 0 || items[0].m_41619_()) {
                it.remove();
                continue;
            }
            ItemStack itemStack = items[0];
            Item item = itemStack.m_41720_();
            if (ingredient instanceof FastSizedIngredient) {
                FastSizedIngredient si = (FastSizedIngredient)ingredient;
                amount = si.getAmount();
            } else {
                amount = itemStack.m_41613_();
            }
            if (amount < 1L) {
                it.remove();
                continue;
            }
            for (int slot = 0; slot < storage.size; ++slot) {
                int remainder;
                int count;
                ItemStack stored = storage.stacks[slot];
                int n = count = visited[slot] == null ? stored.m_41613_() : visited[slot].amount();
                if (io == IO.IN) {
                    int extracted;
                    if (count == 0) continue;
                    if ((visited[slot] == null && ingredient.test(stored) || visited[slot] != null && ingredient.test(visited[slot].stack())) && (extracted = storage.extractItem(slot, Math.min(count, MathUtil.saturatedCast((long)amount)), simulate).m_41613_()) > 0) {
                        if (simulate) {
                            visited[slot] = new SimpleIngredient(stored, count - extracted);
                        }
                        changed = true;
                        amount -= (long)extracted;
                    }
                } else if (count < itemStack.m_41741_() && count < storage.getSlotLimit(slot) && (count == 0 || stored.m_150930_(item)) && (visited[slot] == null || visited[slot].stack().m_150930_(item)) && (long)(remainder = storage.insertItemFast(slot, itemStack, MathUtil.saturatedCast((long)amount), simulate)) < amount) {
                    if (simulate) {
                        visited[slot] = new SimpleIngredient(itemStack, remainder);
                    }
                    changed = true;
                    amount = remainder;
                }
                if (amount > 0L) continue;
                it.remove();
                break;
            }
            if (amount <= 0L) continue;
            if (ingredient instanceof FastSizedIngredient) {
                FastSizedIngredient si = (FastSizedIngredient)ingredient;
                si.setAmount(amount);
                continue;
            }
            items[0].m_41764_(MathUtil.saturatedCast((long)amount));
        }
        if (listener != null) {
            storage.setOnContentsChangedAndfreeze(listener);
            if (changed) {
                listener.run();
            }
        }
        return left.isEmpty() ? null : left;
    }
}

