/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm.recipe;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.data.recipe.WoodTypeEntry;
import com.gregtechceu.gtceu.data.recipe.misc.WoodMachineRecipes;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.data.recipe.generated.WoodRecipes;
import com.gtolib.utils.RLUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WoodMachineRecipes.class})
public final class WoodMachineRecipesMixin {
    @Shadow(remap=false)
    private static List<WoodTypeEntry> DEFAULT_ENTRIES;

    @Inject(method={"getDefaultEntries"}, at={@At(value="INVOKE", target="Ljava/util/Arrays;asList([Ljava/lang/Object;)Ljava/util/List;")}, remap=false, cancellable=true)
    private static void addEntries(CallbackInfoReturnable<List<WoodTypeEntry>> cir) {
        DEFAULT_ENTRIES = WoodRecipes.getEntries();
        cir.setReturnValue(DEFAULT_ENTRIES);
    }

    @Inject(method={"hardWoodRecipes"}, at={@At(value="TAIL")}, remap=false)
    private static void hardWoodRecipes(Consumer<ResourceLocation> registry, CallbackInfo ci) {
        DEFAULT_ENTRIES = null;
    }

    @Inject(method={"hardWoodTypeRecipes"}, at={@At(value="HEAD")}, remap=false)
    private static void hardWoodTypeRecipes(Consumer<ResourceLocation> registry, @NotNull WoodTypeEntry entry, CallbackInfo ci) {
        if (entry.modid.equals("biomeswevegone")) {
            registry.accept(RLUtils.fromNamespaceAndPath((String)"biomeswevegone", (String)(entry.woodName + "_crafting_table")));
        }
    }

    @Overwrite(remap=false)
    public static void registerWoodTypeRecipe(@NotNull WoodTypeEntry entry) {
        Object recipeName;
        boolean hasPlanksRecipe;
        String name = entry.woodName;
        TagKey logTag = entry.logTag;
        boolean bl = hasPlanksRecipe = entry.planksRecipeName != null;
        if (entry.log != null && entry.strippedLog != null) {
            GTORecipeTypes.LATHE_RECIPES.recipeBuilder("strip_" + entry.woodName + "_log").inputItems(entry.log).outputItems(entry.strippedLog).outputItems(TagPrefix.dust, GTMaterials.Wood, 1).duration(160).EUt((long)GTValues.VA[0]).save();
        }
        if (entry.wood != null && entry.strippedWood != null) {
            GTORecipeTypes.LATHE_RECIPES.recipeBuilder("strip_" + entry.woodName + "_wood").inputItems(entry.wood).outputItems(entry.strippedWood).outputItems(TagPrefix.dust, GTMaterials.Wood, 1).duration(160).EUt((long)GTValues.VA[0]).save();
        }
        if (entry.strippedLog != null) {
            GTORecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_stripped_" + entry.woodName + "_log").inputItems(entry.strippedLog).outputItems(TagPrefix.rodLong, GTMaterials.Wood, 4).outputItems(TagPrefix.dust, GTMaterials.Wood, 1).duration(160).EUt((long)GTValues.VA[0]).save();
        }
        if (entry.strippedWood != null) {
            GTORecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_stripped_" + entry.woodName + "_wood").inputItems(entry.strippedWood).outputItems(TagPrefix.rodLong, GTMaterials.Wood, 4).outputItems(TagPrefix.dust, GTMaterials.Wood, 1).duration(160).EUt((long)GTValues.VA[0]).save();
        }
        if (entry.generateLogToPlankRecipe) {
            VanillaRecipeHelper.addShapelessRecipe((String)(hasPlanksRecipe ? entry.planksRecipeName : name + "_planks"), (ItemStack)new ItemStack((ItemLike)entry.planks, 2), (Object[])new Object[]{logTag});
            VanillaRecipeHelper.addShapedRecipe((String)(name + "_planks_saw"), (ItemStack)new ItemStack((ItemLike)entry.planks, 4), (Object[])new Object[]{"s", "L", Character.valueOf('L'), logTag});
            GTORecipeTypes.CUTTER_RECIPES.recipeBuilder(name + "_planks").inputItems(logTag).outputItems(entry.planks, 6).outputItems(TagPrefix.dust, GTMaterials.Wood, 2).duration(200).EUt((long)GTValues.VA[0]).save();
        }
        if (entry.door != null) {
            boolean hasDoorRecipe = entry.doorRecipeName != null;
            Object object = recipeName = hasDoorRecipe ? entry.doorRecipeName : name + "_door";
            if (entry.trapdoor != null) {
                VanillaRecipeHelper.addShapedRecipe((String)recipeName, (ItemStack)new ItemStack((ItemLike)entry.door), (Object[])new Object[]{"PTd", "PRS", "PPs", Character.valueOf('P'), entry.planks, Character.valueOf('T'), entry.trapdoor, Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron)});
                GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_door").inputItems(entry.trapdoor).inputItems(entry.planks, 4).inputFluids(GTMaterials.Iron.getFluid(16)).outputItems(entry.door).duration(400).EUt(4L).save();
            } else {
                VanillaRecipeHelper.addShapedRecipe((String)recipeName, (ItemStack)new ItemStack((ItemLike)entry.door), (Object[])new Object[]{"PTd", "PRS", "PPs", Character.valueOf('P'), entry.planks, Character.valueOf('T'), ItemTags.f_13178_, Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron)});
                GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_door").inputItems(ItemTags.f_13178_).inputItems(entry.planks, 4).inputFluids(GTMaterials.Iron.getFluid(16)).outputItems(entry.door).duration(400).EUt(4L).save();
            }
        }
        if (entry.sign != null && entry.slab != null) {
            boolean hasSignRecipe = entry.signRecipeName != null;
            recipeName = hasSignRecipe ? entry.signRecipeName : name + "_sign";
            VanillaRecipeHelper.addShapedRecipe((String)recipeName, (ItemStack)new ItemStack((ItemLike)entry.sign), (Object[])new Object[]{"LLL", "RPR", "sSd", Character.valueOf('P'), entry.planks, Character.valueOf('R'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron), Character.valueOf('L'), entry.slab, Character.valueOf('S'), entry.getStick()});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder((String)recipeName).circuitMeta(4).inputItems(entry.slab, 1).inputItems(entry.getStick(), 1).inputFluids(GTMaterials.Iron.getFluid(16)).outputItems(entry.sign, 3).duration(200).EUt(4L).save();
            if (entry.hangingSign != null && entry.strippedLog != null) {
                boolean hasHangingSignRecipe = entry.hangingSignRecipeName != null;
                Object recipeNameHanging = hasHangingSignRecipe ? entry.hangingSignRecipeName : name + "_hanging_sign";
                VanillaRecipeHelper.addShapedRecipe((String)recipeNameHanging, (ItemStack)new ItemStack((ItemLike)entry.hangingSign), (Object[])new Object[]{"LLL", "C C", "RSR", Character.valueOf('C'), Items.f_42026_, Character.valueOf('R'), new MaterialEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new ItemStack((ItemLike)entry.sign), Character.valueOf('L'), new ItemStack((ItemLike)entry.slab)});
                GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_hanging_sign").inputItems(entry.slab, 3).inputItems(entry.sign).inputItems(Items.f_42026_, 2).outputItems(entry.hangingSign).circuitMeta(5).duration(150).EUt(4L).save();
            }
        }
        if (entry.trapdoor != null) {
            boolean hasTrapdoorRecipe = entry.trapdoorRecipeName != null;
            recipeName = hasTrapdoorRecipe ? entry.trapdoorRecipeName : name + "_trapdoor";
            VanillaRecipeHelper.addShapedRecipe((String)recipeName, (ItemStack)new ItemStack((ItemLike)entry.trapdoor), (Object[])new Object[]{"BPS", "PdP", "SPB", Character.valueOf('P'), entry.planks, Character.valueOf('B'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Iron), Character.valueOf('S'), entry.getStick()});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder((String)recipeName).circuitMeta(3).inputItems(entry.planks, 2).inputFluids(GTMaterials.Iron.getFluid(16)).outputItems(entry.trapdoor).duration(200).EUt(4L).save();
        }
        if (entry.stairs != null) {
            boolean hasStairRecipe;
            boolean bl2 = hasStairRecipe = entry.stairsRecipeName != null;
            if (entry.addStairsCraftingRecipe) {
                VanillaRecipeHelper.addShapedRecipe((String)(hasStairRecipe ? entry.stairsRecipeName : name + "_stairs"), (ItemStack)new ItemStack((ItemLike)entry.stairs, 4), (Object[])new Object[]{"P  ", "PP ", "PPP", Character.valueOf('P'), entry.planks});
            }
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_stairs").inputItems(entry.planks, 3).outputItems(entry.stairs, 4).circuitMeta(7).EUt(1L).duration(100).save();
        }
        if (entry.slab != null) {
            VanillaRecipeHelper.addShapedRecipe((String)(name + "_slab_saw"), (ItemStack)new ItemStack((ItemLike)entry.slab, 2), (Object[])new Object[]{"sS", Character.valueOf('S'), entry.planks});
            GTORecipeTypes.CUTTER_RECIPES.recipeBuilder(name + "_slab").inputItems(entry.planks).outputItems(entry.slab, 2).duration(200).EUt((long)GTValues.VA[0]).save();
        }
        if (entry.fence != null) {
            boolean hasFenceRecipe = entry.fenceRecipeName != null;
            VanillaRecipeHelper.addShapedRecipe((String)(hasFenceRecipe ? entry.fenceRecipeName : name + "_fence"), (ItemStack)new ItemStack((ItemLike)entry.fence), (Object[])new Object[]{"PSP", "PSP", "PSP", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.getStick()});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_fence").inputItems(entry.planks).outputItems(entry.fence).circuitMeta(13).duration(100).EUt(4L).save();
        }
        if (entry.fenceGate != null) {
            boolean hasFenceGateRecipe = entry.fenceGateRecipeName != null;
            VanillaRecipeHelper.addShapedRecipe((String)(hasFenceGateRecipe ? entry.fenceGateRecipeName : name + "_fence_gate"), (ItemStack)new ItemStack((ItemLike)entry.fenceGate), (Object[])new Object[]{"F F", "SPS", "SPS", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.getStick(), Character.valueOf('F'), Items.f_42484_});
            VanillaRecipeHelper.addShapedRecipe((String)(name + "_fence_gate_screws"), (ItemStack)new ItemStack((ItemLike)entry.fenceGate, 2), (Object[])new Object[]{"IdI", "SPS", "SPS", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.getStick(), Character.valueOf('I'), new MaterialEntry(TagPrefix.screw, GTMaterials.Iron)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_fence_gate").inputItems(entry.planks, 2).inputItems(Tags.Items.RODS_WOODEN, 2).outputItems(entry.fenceGate).circuitMeta(2).duration(100).EUt(4L).save();
        }
        if (entry.boat != null) {
            boolean hasBoatRecipe;
            boolean bl3 = hasBoatRecipe = entry.boatRecipeName != null;
            if (entry.slab != null) {
                VanillaRecipeHelper.addShapedRecipe((String)(hasBoatRecipe ? entry.boatRecipeName : name + "_boat"), (ItemStack)new ItemStack((ItemLike)entry.boat), (Object[])new Object[]{"PHP", "PkP", "SSS", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.slab, Character.valueOf('H'), ItemTags.f_271138_});
            }
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_boat").inputItems(entry.planks, 5).outputItems(entry.boat).circuitMeta(15).duration(100).EUt(4L).save();
            if (entry.chestBoat != null) {
                boolean hasChestBoatRecipe = entry.chestBoatRecipeName != null;
                Object recipeName2 = hasChestBoatRecipe ? entry.chestBoatRecipeName : name + "_chest_boat";
                VanillaRecipeHelper.addShapedRecipe((String)recipeName2, (ItemStack)new ItemStack((ItemLike)entry.chestBoat), (Object[])new Object[]{" B ", "SCS", " w ", Character.valueOf('B'), entry.boat, Character.valueOf('S'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('C'), Tags.Items.CHESTS_WOODEN});
                GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_chest_boat").inputItems(entry.boat).inputItems(Tags.Items.CHESTS_WOODEN).outputItems(entry.chestBoat).circuitMeta(16).duration(100).EUt(4L).save();
            }
        }
        if (entry.button != null && entry.pressurePlate != null) {
            VanillaRecipeHelper.addShapedRecipe((String)(name + "_button"), (ItemStack)new ItemStack((ItemLike)entry.button, 6), (Object[])new Object[]{"sP", Character.valueOf('P'), new ItemStack((ItemLike)entry.pressurePlate)});
            GTORecipeTypes.CUTTER_RECIPES.recipeBuilder(name + "_button").inputItems(entry.pressurePlate).outputItems(entry.button, 12).duration(250).EUt((long)GTValues.VA[0]).save();
        }
        if (entry.pressurePlate != null && entry.slab != null) {
            VanillaRecipeHelper.addShapedRecipe((String)(name + "_pressure_plate"), (ItemStack)new ItemStack((ItemLike)entry.pressurePlate, 2), (Object[])new Object[]{"SrS", "LCL", "SdS", Character.valueOf('S'), new MaterialEntry(TagPrefix.bolt, GTMaterials.Wood), Character.valueOf('L'), entry.slab.m_5456_(), Character.valueOf('C'), new MaterialEntry(TagPrefix.spring, GTMaterials.Iron)});
            GTORecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(name + "_pressure_plate").inputItems(entry.slab, 2).inputItems(TagPrefix.spring, GTMaterials.Iron).outputItems(entry.pressurePlate).circuitMeta(7).duration(100).EUt((long)GTValues.VA[0]).save();
        }
    }
}

