/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.mc.mob;

import com.gtocore.config.GTOConfig;
import com.gtolib.GTOCore;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLLoader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import snownee.jade.util.CommonProxy;

@Mixin(value={Mob.class}, priority=0)
public abstract class MobMixin
extends LivingEntity {
    @Unique
    private static final UUID RANDOM_HEALTH_UUID = UUID.fromString("f3bbe254-3008-48cf-9774-f69d1e81d16b");
    @Unique
    private static final UUID RANDOM_DAMAGE_UUID = UUID.fromString("88b9a4ec-7cb6-4533-bed3-69ee0e823fd3");

    protected MobMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        AttributeInstance attackDamageInstance;
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (GTOCore.isEasy() || this.m_9236_().m_46791_().m_19028_() == 0) {
            return;
        }
        boolean isBoss = CommonProxy.isBoss((Entity)this);
        if (!isBoss && this.m_217043_().m_188499_()) {
            return;
        }
        double difficultyValue = (double)this.m_9236_().m_46791_().m_19028_() / 2.0;
        AttributeInstance maxHealthInstance = this.m_21051_(Attributes.f_22276_);
        if (maxHealthInstance != null) {
            double value = maxHealthInstance.m_22135_();
            maxHealthInstance.m_22125_(new AttributeModifier(RANDOM_HEALTH_UUID, "addRandomHealth", (double)this.m_217043_().m_216339_((int)(value / (double)(isBoss ? 2 : 10) * difficultyValue), (int)(value * difficultyValue + 0.5)), AttributeModifier.Operation.ADDITION));
        }
        if ((attackDamageInstance = this.m_21051_(Attributes.f_22281_)) != null) {
            double value = attackDamageInstance.m_22135_();
            attackDamageInstance.m_22125_(new AttributeModifier(RANDOM_DAMAGE_UUID, "addRandomDamage", (double)this.m_217043_().m_216339_((int)(value / (double)(isBoss ? 2 : 10) * difficultyValue), (int)(value * difficultyValue + 0.5)), AttributeModifier.Operation.ADDITION));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void readAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        AttributeInstance attackDamageInstance;
        AttributeInstance maxHealthInstance = this.m_21051_(Attributes.f_22276_);
        if (maxHealthInstance != null) {
            maxHealthInstance.m_22120_(RANDOM_HEALTH_UUID);
        }
        if ((attackDamageInstance = this.m_21051_(Attributes.f_22281_)) != null) {
            attackDamageInstance.m_22120_(RANDOM_DAMAGE_UUID);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        if (GTOConfig.INSTANCE.mobConfig.naturalRegeneration && !this.m_9236_().m_5776_() && this.f_19797_ % 80 == 8 && this.m_217043_().m_188499_()) {
            int value = Math.max(1, (int)(Math.log(this.m_21233_() * (float)Math.max(1, this.m_9236_().m_46791_().m_19028_())) + 0.5));
            this.m_5634_(value);
        }
    }

    @Inject(method={"checkDespawn"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkDespawn(CallbackInfo ci) {
        if (this.f_19797_ % 20 != 5) {
            ci.cancel();
        }
    }

    @Redirect(method={"checkDespawn"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getDifficulty()Lnet/minecraft/world/Difficulty;"))
    private Difficulty getDifficulty(Level instance) {
        return FMLLoader.isProduction() ? Difficulty.HARD : instance.m_46791_();
    }

    public boolean m_6779_(LivingEntity target) {
        return target.m_142066_();
    }
}

