/*
 * Decompiled with CFR 0.152.
 */
package cx.y3.mc.LaunchHelper;

import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * Exception performing whole class analysis ignored.
 */
public class Main {
    public static String agentJarPath;
    public static String agentOptions;
    public static String execJarPath;

    public static void main(String[] args) {
        Main.printSplash();
        String propsFileName = "launchhelper.properties";
        File propsFile = new File(propsFileName);
        if (!propsFile.exists()) {
            Main.log((String)("Properties file " + propsFileName + " does not exist"));
            InputStream examplePropsFileIs = Main.class.getResourceAsStream("/" + propsFileName);
            try {
                Files.copy(examplePropsFileIs, Paths.get(propsFileName, new String[0]), new CopyOption[0]);
            }
            catch (IOException e) {
                Main.log((String)("Failed to generate " + propsFileName));
                Main.log((String)e.getLocalizedMessage());
                return;
            }
            Main.log((String)"A sample version has been created");
            Main.log((String)"Please modify it as needed.");
            return;
        }
        try {
            Properties props = Main.readPropertiesFile((String)propsFileName);
            agentJarPath = props.getProperty("javaAgentJarPath");
            agentOptions = props.getProperty("javaAgentOptions");
            execJarPath = props.getProperty("execJarPath");
        }
        catch (IOException e) {
            Main.log((String)("Failed to read " + propsFileName));
            Main.log((String)e.getLocalizedMessage());
            return;
        }
        if (!Main.runJar()) {
            Main.log((String)"Failed to launch");
        }
    }

    public static Properties readPropertiesFile(String fileName) throws IOException {
        FileInputStream fis = null;
        Properties prop = null;
        fis = new FileInputStream(fileName);
        prop = new Properties();
        prop.load(fis);
        fis.close();
        return prop;
    }

    public static boolean attachJavaAgent() {
        VirtualMachine vm;
        Main.log((String)String.format("Loading Java agent %s=%s", agentJarPath, agentOptions));
        String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        try {
            vm = VirtualMachine.attach(pid);
        }
        catch (Exception e) {
            Main.log((String)"Failed to attach to the JVM");
            Main.log((String)e.getLocalizedMessage());
            return false;
        }
        try {
            vm.loadAgent(agentJarPath, agentOptions);
            vm.detach();
        }
        catch (Exception e) {
            Main.log((String)e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public static boolean runJar() {
        String className;
        JarFile jarFile;
        Main.log((String)("Loading executable Jar " + execJarPath));
        try {
            jarFile = new JarFile(execJarPath);
        }
        catch (IOException e) {
            Main.log((String)"Failed to open the specified executable jar");
            Main.log((String)e.getLocalizedMessage());
            return false;
        }
        try {
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            className = attributes.getValue(Attributes.Name.MAIN_CLASS);
            jarFile.close();
        }
        catch (IOException e) {
            Main.log((String)"Failed to get manifest from the specified executable jar");
            Main.log((String)e.getLocalizedMessage());
            return false;
        }
        File file = new File(execJarPath);
        try {
            URL[] urls = new URL[]{file.toURI().toURL()};
            URLClassLoader loader = new URLClassLoader(urls);
            Class<?> cls = loader.loadClass(className);
            Method mcMain = cls.getDeclaredMethod("main", String[].class);
            String[] mcArgs = new String[]{};
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(cls.getClassLoader());
            if (!Main.attachJavaAgent()) {
                Main.log((String)"Failed to attach Java agent");
                loader.close();
                return false;
            }
            mcMain.invoke(null, new Object[]{mcArgs});
            Thread.currentThread().setContextClassLoader(oldCl);
            loader.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public static void printSplash() {
        Main.log((String)"");
        Main.log((String)"    //       ////   //  //  //  //   /////  //  //");
        Main.log((String)"   //      //  //  //  //  /// //  //      //  //  ___");
        Main.log((String)"  //      //////  //  //  // ///  //      //////  ____");
        Main.log((String)" //      //  //  //  //  //  //  //      //  //  _____");
        Main.log((String)"//////  //  //   ////   //  //   /////  //  //  ______");
        Main.log((String)"");
        Main.log((String)"      //  //  //////  //      /////   //////  /////");
        Main.log((String)"     //  //  //      //      //  //  //      //  //  ___");
        Main.log((String)"    //////  /////   //      /////   /////   /////   ____");
        Main.log((String)"   //  //  //      //      //      //      //  //  _____");
        Main.log((String)"  //  //  //////  //////  //      //////  //  //  ______");
        Main.log((String)"");
        Properties buildInfo = new Properties();
        try {
            InputStream biif = Main.class.getResourceAsStream("/META-INF/build-info.properties");
            if (biif == null) {
                throw new IOException();
            }
            buildInfo.load(biif);
        }
        catch (IOException e) {
            Main.log((String)("Failed to read build information: " + e.getLocalizedMessage()));
        }
        String name = "LaunchHelper";
        String version = buildInfo.getProperty("build.version");
        String info = String.format("%s (%s) Created with \u2665 by Codex in Somnio", name, version);
        String rule = "";
        for (int i = 0; i < info.length(); ++i) {
            rule = rule + "=";
        }
        Main.log((String)rule);
        Main.log((String)info);
        Main.log((String)"https://github.com/Codex-in-somnio/LaunchHelper");
        Main.log((String)rule);
        Main.log((String)"");
    }

    public static void log(String message) {
        System.out.println("[LH] " + message);
    }
}

