# 交互与输入

Kimi Code CLI 提供了丰富的交互功能，帮助你高效地与 AI 协作。

## Agent 与 Shell 模式

Kimi Code CLI 有两种输入模式：

- **Agent 模式**：默认模式，输入的内容会发送给 AI 处理
- **Shell 模式**：直接执行 Shell 命令，无需离开 Kimi Code CLI

按 `Ctrl-X` 可以在两种模式之间切换。当前模式会显示在底部状态栏中。

在 Shell 模式下，你可以像在普通终端中一样执行命令：

```sh
$ ls -la
$ git status
$ npm run build
```

Shell 模式也支持部分斜杠命令，包括 `/help`、`/exit`、`/version`、`/changelog` 和 `/feedback`。

::: warning 注意
Shell 模式中每个命令独立执行，`cd`、`export` 等改变环境的命令不会影响后续命令。
:::

## Thinking 模式

Thinking 模式让 AI 在回答前进行更深入的思考，适合处理复杂问题。

你可以通过 `/model` 命令切换模型和 Thinking 模式。在选择模型后，如果模型支持 Thinking 模式，系统会询问是否开启。也可以在启动时通过 `--thinking` 参数启用：

```sh
kimi --thinking
```

::: tip 提示
Thinking 模式需要当前模型支持。部分模型（如 `kimi-k2-thinking-turbo`）始终使用 Thinking 模式，无法关闭。
:::

## 多行输入

有时你需要输入多行内容，比如贴入一段代码或错误日志。按 `Ctrl-J` 或 `Alt-Enter` 可以插入换行，而不是直接发送消息。

输入完成后，按 `Enter` 发送整条消息。

## 剪贴板与图片粘贴

按 `Ctrl-V` 可以粘贴剪贴板中的文本或图片。

如果剪贴板中是图片，Kimi Code CLI 会自动将图片作为附件添加到消息中。发送消息后，AI 可以看到并分析这张图片。

::: tip 提示
图片输入需要当前模型支持 `image_in` 能力，视频输入需要支持 `video_in` 能力。
:::

## 斜杠命令

斜杠命令是以 `/` 开头的特殊指令，用于执行 Kimi Code CLI 的内置功能，如 `/help`、`/setup`、`/sessions` 等。输入 `/` 后会自动显示可用命令列表。完整的斜杠命令列表请参考 [斜杠命令参考](../reference/slash-commands.md)。

## @ 路径补全

在消息中输入 `@` 后，Kimi Code CLI 会自动补全工作目录中的文件和目录路径。这让你可以方便地引用项目中的文件：

```
帮我看一下 @src/components/Button.tsx 这个文件有没有问题
```

输入 `@` 后开始输入文件名，会显示匹配的补全项。按 `Tab` 或 `Enter` 选择补全项。

## 审批与确认

当 AI 需要执行可能有影响的操作（如修改文件、运行命令）时，Kimi Code CLI 会请求你的确认。

确认提示会显示操作的详情，包括 Shell 命令和文件 Diff 预览。如果内容较长被截断，可以按 `Ctrl-E` 展开查看完整内容。你可以选择：

- **允许**：执行这次操作
- **本会话允许**：在当前会话中自动批准同类操作
- **拒绝**：不执行此操作

如果你信任 AI 的操作，或者你正在安全的隔离环境中运行 Kimi Code CLI，可以启用「YOLO 模式」来自动批准所有请求：

```sh
# 启动时启用
kimi --yolo

# 或在运行中切换
/yolo
```

开启 YOLO 模式后，底部状态栏会显示黄色的 YOLO 标识。再次输入 `/yolo` 可关闭。

::: warning 注意
YOLO 模式会跳过所有确认，请确保你了解可能的风险。建议仅在可控环境中使用。
:::

