/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector.adaptors;

import de.oceanlabs.mcp.mcinjector.InheratanceMap;
import de.oceanlabs.mcp.mcinjector.MCInjectorImpl;
import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class AccessFixer
extends ClassVisitor {
    private static final Logger log = Logger.getLogger("MCInjector");
    private MCInjectorImpl mci;
    private String className;
    private InheratanceMap.Class meta;

    public AccessFixer(ClassVisitor cv, MCInjectorImpl mci) {
        super(327680, cv);
        this.mci = mci;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        if (this.mci.inheratance != null) {
            this.meta = this.mci.inheratance.getClass(name);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String sig = this.className + "." + name + desc;
        if (this.mci.inheratance == null) {
            InheratanceMap.Access change = this.mci.getAccess(sig);
            if (change != null) {
                log.info("  Access Change: " + (Object)((Object)InheratanceMap.Access.getFromBytecode(access)) + " -> " + (Object)((Object)change) + " " + sig);
                access = change.setAccess(access);
            }
        } else if ((access & 2) != 2 && (access & 8) != 8) {
            InheratanceMap.Access top;
            InheratanceMap.Access old;
            InheratanceMap.Node parent = this.meta.traverseMethod(name, desc);
            if (!this.meta.name.equals(parent.owner.name) && (old = InheratanceMap.Access.getFromBytecode(access)).compareTo(top = InheratanceMap.Access.getFromBytecode(parent.access)) < 0) {
                log.info("  Access Change: " + (Object)((Object)old) + " -> " + (Object)((Object)top) + " " + sig);
                access = top.setAccess(access);
                this.mci.setAccess(sig, top);
            }
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }
}

