/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector.adaptors;

import de.oceanlabs.mcp.mcinjector.MCInjectorImpl;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class LVTRenamer
extends ClassVisitor {
    private static final Logger log = Logger.getLogger("MCInjector");
    private MCInjectorImpl mci;
    String className;
    private boolean isInMethod = false;

    public LVTRenamer(ClassVisitor cn, MCInjectorImpl mci) {
        super(327680, cn);
        this.mci = mci;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        super.visitOuterClass(owner, name, desc);
        if (desc != null) {
            this.isInMethod = true;
        }
    }

    @Override
    public void visitEnd() {
        String tmp;
        super.visitEnd();
        String suffix = null;
        if (this.isInMethod && (tmp = this.mci.getMarker(this.className)) != null) {
            tmp = tmp.replace("CL_", "");
            while (tmp.charAt(0) == '0') {
                tmp = tmp.substring(1);
            }
            suffix = tmp;
        }
        ClassNode cls = MCInjectorImpl.getClassNode(this.cv);
        for (final MethodNode mn : cls.methods) {
            if (mn.localVariables == null || mn.localVariables.size() <= 0) continue;
            Collections.sort(mn.localVariables, new Comparator<LocalVariableNode>(){

                @Override
                public int compare(LocalVariableNode o1, LocalVariableNode o2) {
                    int o2Start;
                    if (o1.index < o2.index) {
                        return -1;
                    }
                    if (o1.index > o2.index) {
                        return 1;
                    }
                    int o1Start = mn.instructions.indexOf(o1.start);
                    if (o1Start < (o2Start = mn.instructions.indexOf(o2.start))) {
                        return -1;
                    }
                    if (o2Start > o2Start) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (LocalVariableNode lvn : mn.localVariables) {
                if ('\u2603' != lvn.name.charAt(0)) continue;
                String name = this.getNewName(mn, lvn);
                if (suffix != null) {
                    if (!name.endsWith("_")) {
                        name = name + "_";
                    }
                    name = name + suffix + "_";
                }
                log.info("    Renaming LVT: " + lvn.index + " " + lvn.name + " " + lvn.desc + " -> " + name);
                lvn.name = name;
            }
        }
    }

    protected abstract String getNewName(MethodNode var1, LocalVariableNode var2);
}

