/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource.util;

import com.google.common.base.CharMatcher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import net.md_5.specialsource.SpecialSource;

public class FileLocator {
    public static boolean useCache = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File download(String url) throws IOException {
        String id;
        File file;
        File tempDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "ss-cache");
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        if ((file = new File(tempDir, id = CharMatcher.JAVA_LETTER_OR_DIGIT.or(CharMatcher.anyOf("-_.")).negate().replaceFrom((CharSequence)url.toString(), '_'))).exists() && useCache) {
            System.out.println("Using cached file " + file.getPath() + " for " + url);
            return file;
        }
        System.out.println("Downloading " + url);
        Channel rbc = null;
        FileOutputStream fos = null;
        try {
            rbc = Channels.newChannel(new URL(url.replace('\\', '/')).openStream());
            fos = new FileOutputStream(file);
            fos.getChannel().transferFrom((ReadableByteChannel)rbc, 0L, 0x1000000L);
        }
        finally {
            if (rbc != null) {
                rbc.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        if (SpecialSource.verbose()) {
            System.out.println("Downloaded to " + file.getPath());
        }
        return file;
    }

    public static File getFile(String path) throws IOException {
        if (FileLocator.isHTTPURL(path)) {
            return FileLocator.download(path);
        }
        return new File(path);
    }

    public static boolean isHTTPURL(String string) {
        return string.startsWith("http://") || string.startsWith("https://");
    }
}

