/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf;

import COM.rl.MapSignatureAdapter;
import COM.rl.NameProvider;
import COM.rl.obf.Cl;
import COM.rl.obf.Fd;
import COM.rl.obf.Md;
import COM.rl.obf.Pk;
import COM.rl.obf.PkCl;
import COM.rl.obf.RgsEntryType;
import COM.rl.obf.SimpleName;
import COM.rl.obf.TreeAction;
import COM.rl.obf.TreeItem;
import COM.rl.obf.classfile.ClassConstants;
import COM.rl.obf.classfile.ClassFile;
import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.FieldInfo;
import COM.rl.obf.classfile.MethodInfo;
import COM.rl.obf.classfile.NameMapper;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.objectweb.asm.signature.SignatureException;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureWriter;

public class ClassTree
implements NameMapper,
ClassConstants {
    public static final char PACKAGE_LEVEL = '/';
    public static final char CLASS_LEVEL = '$';
    public static final char METHOD_FIELD_LEVEL = '/';
    private static final String LOG_PRE_UNOBFUSCATED = "# Names reserved from obfuscation:";
    private static final String LOG_PRE_OBFUSCATED = "# Obfuscated name mappings (some of these may be unchanged due to polymorphism constraints):";
    private static final String LOG_DANGER_HEADER1 = "# WARNING - Reflection methods are called which may unavoidably break in the";
    private static final String LOG_DANGER_HEADER2 = "# obfuscated version at runtime. Please review your source code to ensure";
    private static final String LOG_DANGER_HEADER3 = "# these methods do not act on classes in the obfuscated Jar file.";
    private List<String> retainAttrs = new ArrayList<String>();
    private Pk root = Pk.createRoot(this);

    public static List<SimpleName> getNameList(String name) throws ClassFileException {
        ArrayList<SimpleName> list = new ArrayList<SimpleName>();
        String nameOrig = name;
        while (name != null && !name.equals("")) {
            int posP = name.indexOf(47);
            int posC = name.indexOf(36);
            SimpleName simpleName = null;
            if (posP == -1 && posC == -1) {
                simpleName = new SimpleName(name).setAsClass();
                name = "";
            }
            if (posP == -1 && posC != -1) {
                simpleName = new SimpleName(name.substring(0, posC)).setAsClass();
                name = name.substring(posC + 1, name.length());
            }
            if (posP != -1 && posC == -1) {
                simpleName = new SimpleName(name.substring(0, posP)).setAsPackage();
                name = name.substring(posP + 1, name.length());
            }
            if (posP != -1 && posC != -1) {
                if (posP < posC) {
                    simpleName = new SimpleName(name.substring(0, posP)).setAsPackage();
                    name = name.substring(posP + 1, name.length());
                } else {
                    throw new ClassFileException("Invalid fully qualified name (a): " + nameOrig);
                }
            }
            list.add(simpleName);
        }
        if (!nameOrig.equals("") && nameOrig.charAt(nameOrig.length() - 1) == '$') {
            list.add(new SimpleName("").setAsClass());
        }
        return list;
    }

    public String getOutName(String inName) {
        try {
            Pk ti = this.root;
            StringBuilder sb = new StringBuilder();
            for (SimpleName simpleName : ClassTree.getNameList(inName)) {
                String name = simpleName.getName();
                if (simpleName.isAsPackage()) {
                    if (ti != null) {
                        Pk pk = ti;
                        if ((ti = pk.getPackage(name)) != null) {
                            Pk pk2 = ti;
                            String repackageName = pk2.getRepackageName();
                            if (repackageName != null) {
                                sb = new StringBuilder(repackageName);
                            } else {
                                sb.append(ti.getOutName());
                            }
                        } else {
                            sb.append(name);
                        }
                    } else {
                        sb.append(name);
                    }
                    sb.append('/');
                    continue;
                }
                if (simpleName.isAsClass()) {
                    sb.append(name);
                    return sb.toString();
                }
                throw new ClassFileException("Internal error: illegal package/class name tag");
            }
        }
        catch (ClassFileException classFileException) {
            // empty catch block
        }
        return inName;
    }

    public void addClassFile(ClassFile cf) throws ClassFileException {
        Cl cl;
        PkCl ti = this.root;
        String className = cf.getName();
        Iterator<SimpleName> nameIter = ClassTree.getNameList(className).iterator();
        while (nameIter.hasNext()) {
            SimpleName simpleName = nameIter.next();
            String name = simpleName.getName();
            if (simpleName.isAsPackage()) {
                Pk pk = ti;
                ti = pk.addPackage(name);
                continue;
            }
            if (simpleName.isAsClass()) {
                PkCl pkCl = ti;
                if (nameIter.hasNext()) {
                    ti = pkCl.addPlaceholderClass(name);
                    continue;
                }
                ti = pkCl.addClass(name, cf.getSuper(), cf.getInterfaces(), cf.getModifiers());
                continue;
            }
            throw new ClassFileException("Internal error: illegal package/class name tag");
        }
        if (ti instanceof Cl) {
            cl = (Cl)ti;
            for (MethodInfo mi : cf.getMethods()) {
                cl.addMethod(cf, mi);
            }
            for (FieldInfo fi : cf.getFields()) {
                cl.addField(cf, fi);
            }
        } else {
            throw new ClassFileException("Inconsistent class file.");
        }
        cl.setWarnings(cf);
    }

    public void noWarnClass(String name) throws ClassFileException {
        for (Cl cl : this.getClList(name)) {
            cl.setNoWarn();
        }
    }

    public void logWarnings(PrintWriter log) {
        try {
            final ArrayList hasWarnings = new ArrayList();
            this.walkTree(new TreeAction(){

                @Override
                public void classAction(Cl cl) {
                    if (cl.hasWarnings()) {
                        hasWarnings.add(true);
                    }
                }
            });
            if (hasWarnings.size() > 0) {
                log.println("#");
                log.println(LOG_DANGER_HEADER1);
                log.println(LOG_DANGER_HEADER2);
                log.println(LOG_DANGER_HEADER3);
                final PrintWriter flog = log;
                this.walkTree(new TreeAction(){

                    @Override
                    public void classAction(Cl cl) {
                        cl.logWarnings(flog);
                    }
                });
            }
        }
        catch (ClassFileException classFileException) {
            // empty catch block
        }
    }

    public void retainAttribute(String name) {
        this.retainAttrs.add(name);
    }

    public void retainClass(String name, boolean retainToPublic, boolean retainToProtected, boolean retainPubProtOnly, boolean retainFieldsOnly, boolean retainMethodsOnly, String extendsName, boolean invert, int accessMask, int accessSetting) throws ClassFileException {
        List<Cl> classes = this.getClList(name);
        if (classes.size() == 0) {
            throw new ClassFileException("ClassNotFound");
        }
        for (Cl cl : classes) {
            if (extendsName != null && !cl.hasAsSuperOrInterface(extendsName) || !cl.modifiersMatchMask(accessMask, accessSetting)) continue;
            this.retainHierarchy(cl, invert);
            if (!retainToPublic && !retainToProtected && !retainPubProtOnly) continue;
            if (!retainFieldsOnly) {
                for (Md md : cl.getMethods()) {
                    if (!(retainToPublic && Modifier.isPublic(md.getModifiers()) || retainToProtected && !Modifier.isPrivate(md.getModifiers())) && (!retainPubProtOnly || !Modifier.isPublic(md.getModifiers()) && !Modifier.isProtected(md.getModifiers()))) continue;
                    if (invert) {
                        md.setOutName(null);
                        md.clearFromScript();
                        continue;
                    }
                    md.setOutName(md.getInName());
                    md.setFromScript();
                }
            }
            if (retainMethodsOnly) continue;
            for (Fd fd : cl.getFields()) {
                if (!(retainToPublic && Modifier.isPublic(fd.getModifiers()) || retainToProtected && !Modifier.isPrivate(fd.getModifiers())) && (!retainPubProtOnly || !Modifier.isPublic(fd.getModifiers()) && !Modifier.isProtected(fd.getModifiers()))) continue;
                if (invert) {
                    fd.setOutName(null);
                    fd.clearFromScript();
                    continue;
                }
                fd.setOutName(fd.getInName());
                fd.setFromScript();
            }
        }
    }

    public void retainMethod(String name, String descriptor, boolean retainAndClass, String extendsName, boolean invert, int accessMask, int accessSetting) throws ClassFileException {
        List<Md> methods = this.getMdList(name, descriptor);
        if (methods.size() == 0) {
            throw new ClassFileException("MethodNotFound");
        }
        for (Md md : methods) {
            Cl thisCl = (Cl)md.getParent();
            if (extendsName != null && !thisCl.hasAsSuperOrInterface(extendsName) || !md.modifiersMatchMask(accessMask, accessSetting)) continue;
            if (invert) {
                md.setOutName(null);
                md.clearFromScript();
            } else {
                md.setOutName(md.getInName());
                md.setFromScript();
            }
            if (!retainAndClass) continue;
            this.retainHierarchy(thisCl, invert);
        }
    }

    public void retainField(String name, String descriptor, boolean retainAndClass, String extendsName, boolean invert, int accessMask, int accessSetting) throws ClassFileException {
        List<Fd> fields = this.getFdList(name, descriptor);
        if (fields.size() == 0) {
            throw new ClassFileException("FieldNotFound");
        }
        for (Fd fd : fields) {
            Cl thisCl = (Cl)fd.getParent();
            if (extendsName != null && !thisCl.hasAsSuperOrInterface(extendsName) || !fd.modifiersMatchMask(accessMask, accessSetting)) continue;
            if (invert) {
                fd.setOutName(null);
                fd.clearFromScript();
            } else {
                fd.setOutName(fd.getInName());
                fd.setFromScript();
            }
            if (!retainAndClass) continue;
            this.retainHierarchy(thisCl, invert);
        }
    }

    public TreeItem retainPackageMap(String name, String obfName) throws ClassFileException {
        Pk pk = this.getPk(name);
        if (pk == null) {
            throw new ClassFileException("PackageNotFound");
        }
        return ClassTree.retainItemMap(pk, obfName);
    }

    public TreeItem retainRepackageMap(String name, String obfName) throws ClassFileException {
        Pk pk = this.getPk(name);
        if (pk == null) {
            throw new ClassFileException("PackageNotFound");
        }
        if (!pk.isFixed()) {
            pk.setRepackageName(obfName);
            pk.setOutName(pk.getInName());
        }
        return pk;
    }

    public TreeItem retainClassMap(String name, String obfName) throws ClassFileException {
        Cl cl = this.getCl(name);
        if (cl == null) {
            throw new ClassFileException("ClassNotFound");
        }
        return ClassTree.retainItemMap(cl, obfName);
    }

    public TreeItem retainMethodMap(String name, String descriptor, String obfName) throws ClassFileException {
        Md md = this.getMd(name, descriptor);
        if (md == null) {
            throw new ClassFileException("MethodNotFound");
        }
        return ClassTree.retainItemMap(md, obfName);
    }

    public TreeItem retainFieldMap(String name, String obfName) throws ClassFileException {
        Fd fd = this.getFd(name);
        if (fd == null) {
            throw new ClassFileException("FieldNotFound");
        }
        return ClassTree.retainItemMap(fd, obfName);
    }

    private static TreeItem retainItemMap(TreeItem item, String obfName) {
        if (item.isFixed()) {
            if (obfName.equals("")) {
                obfName = ".";
            }
            if (!obfName.equals(item.getOutName(true))) {
                if (item.isFromScriptMap()) {
                    NameProvider.errorLog("# Trying to remap " + item.getFullInName(true) + " = " + item.getOutName(true) + " to " + obfName + " fixed by ScriptMap");
                } else if (item.isFromScript()) {
                    NameProvider.errorLog("# Trying to remap " + item.getFullInName(true) + " = " + item.getOutName(true) + " to " + obfName + " fixed by Script");
                } else {
                    NameProvider.errorLog("# Trying to remap " + item.getFullInName(true) + " = " + item.getOutName(true) + " to " + obfName);
                }
            }
            return item;
        }
        item.setOutName(obfName);
        item.setFromScriptMap();
        return item;
    }

    public void generateNames() throws ClassFileException {
        HashMap<String, Pk> rootMap = new HashMap<String, Pk>();
        rootMap.put("", this.root);
        PkCl.generateNames(rootMap);
        this.walkTree(new TreeAction(){

            @Override
            public void packageAction(Pk pk) throws ClassFileException {
                pk.generateNames();
            }

            @Override
            public void classAction(Cl cl) throws ClassFileException {
                cl.generateNames();
            }
        });
    }

    public void resolveClasses() throws ClassFileException {
        this.walkTree(new TreeAction(){

            @Override
            public void classAction(Cl cl) {
                cl.resetResolve();
            }
        });
        this.walkTree(new TreeAction(){

            @Override
            public void classAction(Cl cl) throws ClassFileException {
                cl.setupNameListDowns();
            }
        });
        Cl.nameSpace = 0;
        this.walkTree(new TreeAction(){

            @Override
            public void classAction(Cl cl) throws ClassFileException {
                cl.resolveOptimally();
            }
        });
    }

    @Override
    public List<String> getAttrsToKeep() {
        return this.retainAttrs;
    }

    public List<Cl> getClList(String fullName) throws ClassFileException {
        final ArrayList<Cl> list = new ArrayList<Cl>();
        if (fullName.indexOf(42) != -1) {
            if (fullName.indexOf(33) == 0) {
                final String fName = fullName.substring(1);
                this.walkTree(new TreeAction(){

                    @Override
                    public void classAction(Cl cl) {
                        if (cl.isOldStyleMatch(fName)) {
                            list.add(cl);
                        }
                    }
                });
            } else {
                final String fName = fullName;
                this.walkTree(new TreeAction(){

                    @Override
                    public void classAction(Cl cl) {
                        if (cl.isWildcardMatch(fName)) {
                            list.add(cl);
                        }
                    }
                });
            }
        } else {
            Cl cl = this.getCl(fullName);
            if (cl != null) {
                list.add(cl);
            }
        }
        return list;
    }

    public List<Md> getMdList(String fullName, String descriptor) throws ClassFileException {
        final ArrayList<Md> list = new ArrayList<Md>();
        final String fDesc = descriptor;
        if (fullName.indexOf(42) != -1 || descriptor.indexOf(42) != -1) {
            if (fullName.indexOf(33) == 0) {
                final String fName = fullName.substring(1);
                this.walkTree(new TreeAction(){

                    @Override
                    public void methodAction(Md md) {
                        if (md.isOldStyleMatch(fName, fDesc)) {
                            list.add(md);
                        }
                    }
                });
            } else {
                final String fName = fullName;
                this.walkTree(new TreeAction(){

                    @Override
                    public void methodAction(Md md) {
                        if (md.isWildcardMatch(fName, fDesc)) {
                            list.add(md);
                        }
                    }
                });
            }
        } else {
            Md md = this.getMd(fullName, descriptor);
            if (md != null) {
                list.add(md);
            }
        }
        return list;
    }

    public List<Fd> getFdList(String fullName, String descriptor) throws ClassFileException {
        final ArrayList<Fd> list = new ArrayList<Fd>();
        if (fullName.indexOf(42) != -1) {
            if (fullName.indexOf(33) == 0) {
                final String fName = fullName.substring(1);
                this.walkTree(new TreeAction(){

                    @Override
                    public void fieldAction(Fd fd) {
                        if (fd.isOldStyleMatch(fName)) {
                            list.add(fd);
                        }
                    }
                });
            } else {
                final String fName = fullName;
                final String fDesc = descriptor;
                this.walkTree(new TreeAction(){

                    @Override
                    public void fieldAction(Fd fd) {
                        if (fd.isWildcardMatch(fName, fDesc)) {
                            list.add(fd);
                        }
                    }
                });
            }
        } else {
            Fd fd = this.getFd(fullName);
            if (fd != null) {
                list.add(fd);
            }
        }
        return list;
    }

    public Cl getCl(String fullName) throws ClassFileException {
        PkCl ti = this.root;
        for (SimpleName simpleName : ClassTree.getNameList(fullName)) {
            String name = simpleName.getName();
            if (simpleName.isAsPackage()) {
                Pk pk = ti;
                ti = pk.getPackage(name);
            } else if (simpleName.isAsClass()) {
                PkCl pkCl = ti;
                ti = pkCl.getClass(name);
            } else {
                throw new ClassFileException("Internal error: illegal package/class name tag");
            }
            if (ti != null) continue;
            return null;
        }
        if (!(ti instanceof Cl)) {
            return null;
        }
        return (Cl)ti;
    }

    public Pk getPk(String fullName) throws ClassFileException {
        Pk ti = this.root;
        Iterator<SimpleName> i$ = ClassTree.getNameList(fullName).iterator();
        while (i$.hasNext()) {
            Pk pk = ti;
            SimpleName simpleName = i$.next();
            String name = simpleName.getName();
            if ((ti = pk.getPackage(name)) == null) {
                return null;
            }
            if (ti instanceof Pk) continue;
            throw new ClassFileException("Inconsistent package.");
        }
        return ti;
    }

    public Md getMd(String fullName, String descriptor) throws ClassFileException {
        int pos = fullName.lastIndexOf(47);
        String className = fullName.substring(0, pos);
        String methodName = fullName.substring(pos + 1);
        Cl cl = this.getCl(className);
        if (cl == null) {
            return null;
        }
        return cl.getMethod(methodName, descriptor);
    }

    public Fd getFd(String fullName) throws ClassFileException {
        int pos = fullName.lastIndexOf(47);
        String className = fullName.substring(0, pos);
        String fieldName = fullName.substring(pos + 1);
        Cl cl = this.getCl(className);
        if (cl == null) {
            return null;
        }
        return cl.getField(fieldName);
    }

    @Override
    public String mapClass(String className) throws ClassFileException {
        if (className.length() > 0 && className.charAt(0) == '[') {
            StringBuilder newName = new StringBuilder();
            int i = 0;
            block4: while (i < className.length()) {
                char ch = className.charAt(i++);
                switch (ch) {
                    case ';': 
                    case '[': {
                        newName.append(ch);
                        continue block4;
                    }
                    case 'L': {
                        newName.append(ch);
                        int pos = className.indexOf(59, i);
                        if (pos < 0) {
                            throw new ClassFileException("Invalid class name encountered: " + className);
                        }
                        newName.append(this.mapClass(className.substring(i, pos)));
                        i = pos;
                        continue block4;
                    }
                }
                return className;
            }
            return newName.toString();
        }
        Cl cl = this.getCl(className);
        if (cl != null) {
            return cl.getFullOutName();
        }
        return className;
    }

    @Override
    public String mapMethod(String className, String methodName, String descriptor) throws ClassFileException {
        String outName = methodName;
        if (!methodName.equals("<init>")) {
            Stack<Cl> s = new Stack<Cl>();
            Cl nextCl = this.getCl(className);
            if (nextCl != null) {
                s.push(nextCl);
            }
            while (!s.empty()) {
                Cl cl = (Cl)s.pop();
                Md md = cl.getMethod(methodName, descriptor);
                if (md != null) {
                    outName = md.getOutName();
                    break;
                }
                Cl superCl = cl.getSuperCl();
                if (superCl != null) {
                    s.push(superCl);
                }
                for (Cl intfCl : cl.getSuperInterfaces()) {
                    if (intfCl == null) continue;
                    s.push(intfCl);
                }
            }
        }
        return outName;
    }

    @Override
    public String mapField(String className, String fieldName) throws ClassFileException {
        String outName = fieldName;
        if (!fieldName.equals("<init>")) {
            Stack<Cl> s = new Stack<Cl>();
            Cl nextCl = this.getCl(className);
            if (nextCl != null) {
                s.push(nextCl);
            }
            while (!s.empty()) {
                Cl cl = (Cl)s.pop();
                Fd fd = cl.getField(fieldName);
                if (fd != null) {
                    outName = fd.getOutName();
                    break;
                }
                Cl superCl = cl.getSuperCl();
                if (superCl != null) {
                    s.push(superCl);
                }
                for (Cl intfCl : cl.getSuperInterfaces()) {
                    if (intfCl == null) continue;
                    s.push(intfCl);
                }
            }
        }
        return outName;
    }

    private String mapSignature(String signature, ClassConstants.AttrSource source) throws ClassFileException {
        SignatureWriter sw = new SignatureWriter();
        MapSignatureAdapter sa = new MapSignatureAdapter(sw, this);
        SignatureReader sr = new SignatureReader(signature);
        try {
            switch (source) {
                case CLASS: {
                    sr.acceptClassType(sa);
                    break;
                }
                case METHOD: {
                    sr.acceptMethodType(sa);
                    break;
                }
                case FIELD: {
                    sr.acceptFieldType(sa);
                    break;
                }
                default: {
                    throw new ClassFileException("Invalid attribute source");
                }
            }
        }
        catch (SignatureException e) {
            if (e.getCause() instanceof ClassFileException) {
                throw (ClassFileException)e.getCause();
            }
            throw new ClassFileException(e);
        }
        String newSig = sw.toString();
        return newSig;
    }

    @Override
    public String mapSignatureClass(String signature) throws ClassFileException {
        String newSig = this.mapSignature(signature, ClassConstants.AttrSource.CLASS);
        System.err.println("!c " + signature + " => " + newSig);
        return newSig;
    }

    @Override
    public String mapSignatureMethod(String signature) throws ClassFileException {
        String newSig = this.mapSignature(signature, ClassConstants.AttrSource.METHOD);
        System.err.println("!m " + signature + " => " + newSig);
        return newSig;
    }

    @Override
    public String mapSignatureField(String signature) throws ClassFileException {
        String newSig = this.mapSignature(signature, ClassConstants.AttrSource.FIELD);
        System.err.println("!f " + signature + " => " + newSig);
        return newSig;
    }

    @Override
    public String mapDescriptor(String descriptor) throws ClassFileException {
        StringBuilder newDesc = new StringBuilder();
        int i = 0;
        block4: while (i < descriptor.length()) {
            char ch = descriptor.charAt(i++);
            switch (ch) {
                case '(': 
                case ')': 
                case ';': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': 
                case '[': {
                    newDesc.append(ch);
                    continue block4;
                }
                case 'L': {
                    newDesc.append(ch);
                    int pos = descriptor.indexOf(59, i);
                    if (pos < 0) {
                        throw new ClassFileException("Invalid descriptor string encountered.");
                    }
                    newDesc.append(this.mapClass(descriptor.substring(i, pos)));
                    i = pos;
                    continue block4;
                }
            }
            throw new ClassFileException("Invalid descriptor string encountered.");
        }
        return newDesc.toString();
    }

    public void dump(final PrintWriter log) {
        try {
            log.println("#");
            log.println(LOG_PRE_UNOBFUSCATED);
            log.println("#");
            this.walkTree(new TreeAction(){

                @Override
                public void classAction(Cl cl) {
                    if (cl.isFromScript()) {
                        log.println((Object)((Object)RgsEntryType.CLASS) + " " + cl.getFullInName());
                    }
                }

                @Override
                public void methodAction(Md md) {
                    if (md.isFromScript()) {
                        log.println((Object)((Object)RgsEntryType.METHOD) + " " + md.getFullInName() + " " + md.getDescriptor());
                    }
                }

                @Override
                public void fieldAction(Fd fd) {
                    if (fd.isFromScript()) {
                        log.println((Object)((Object)RgsEntryType.FIELD) + " " + fd.getFullInName() + " " + fd.getDescriptor());
                    }
                }

                @Override
                public void packageAction(Pk pk) {
                }
            });
            log.println("#");
            log.println("#");
            log.println(LOG_PRE_OBFUSCATED);
            log.println("#");
            this.walkTree(new TreeAction(){

                @Override
                public void classAction(Cl cl) {
                    if (!cl.isFromScript()) {
                        log.println((Object)((Object)RgsEntryType.CLASS_MAP) + " " + cl.getFullInName() + " " + cl.getOutName());
                    }
                }

                @Override
                public void methodAction(Md md) {
                    if (!md.isFromScript()) {
                        log.println((Object)((Object)RgsEntryType.METHOD_MAP) + " " + md.getFullInName() + " " + md.getDescriptor() + " " + md.getOutName());
                    }
                }

                @Override
                public void fieldAction(Fd fd) {
                    if (!fd.isFromScript()) {
                        log.println((Object)((Object)RgsEntryType.FIELD_MAP) + " " + fd.getFullInName() + " " + fd.getOutName());
                    }
                }

                @Override
                public void packageAction(Pk pk) {
                    if (!pk.isFromScript()) {
                        if (pk.getRepackageName() != null) {
                            log.println((Object)((Object)RgsEntryType.REPACKAGE_MAP) + " " + pk.getFullInName(true) + " " + pk.getRepackageName(true));
                        } else {
                            log.println((Object)((Object)RgsEntryType.PACKAGE_MAP) + " " + pk.getFullInName(true) + " " + pk.getOutName(true));
                        }
                    }
                }
            });
            this.walkTree(new TreeAction(){

                @Override
                public void classAction(Cl cl) {
                    if (cl.isOutput()) {
                        NameProvider.outputClass(cl);
                    }
                }

                @Override
                public void methodAction(Md md) {
                    if (md.isOutput()) {
                        NameProvider.outputMethod(md);
                    }
                }

                @Override
                public void fieldAction(Fd fd) {
                    if (fd.isOutput()) {
                        NameProvider.outputField(fd);
                    }
                }

                @Override
                public void packageAction(Pk pk) {
                    if (pk.isOutput()) {
                        NameProvider.outputPackage(pk);
                    }
                }
            });
        }
        catch (ClassFileException classFileException) {
            // empty catch block
        }
    }

    private void retainHierarchy(TreeItem ti, boolean invert) {
        if (invert) {
            if (!(ti instanceof Pk)) {
                ti.setOutName(null);
                ti.clearFromScript();
            }
        } else if (!ti.isFixed()) {
            ti.setOutName(ti.getInName());
            ti.setFromScript();
        }
        if (ti.parent != null) {
            this.retainHierarchy(ti.parent, invert);
        }
    }

    public void walkTree(TreeAction ta) throws ClassFileException {
        this.walkTree(ta, this.root);
    }

    private void walkTree(TreeAction ta, TreeItem ti) throws ClassFileException {
        if (ti instanceof Pk) {
            Pk pk = (Pk)ti;
            Collection<Pk> packages = pk.getPackages();
            ta.packageAction(pk);
            for (TreeItem treeItem : packages) {
                this.walkTree(ta, treeItem);
            }
        }
        if (ti instanceof PkCl) {
            PkCl pkCl = (PkCl)ti;
            Collection<Cl> classes = pkCl.getClasses();
            for (TreeItem treeItem : classes) {
                this.walkTree(ta, treeItem);
            }
        }
        if (ti instanceof Cl) {
            Cl cl = (Cl)ti;
            Collection<Fd> fields = cl.getFields();
            Collection<Md> methods = cl.getMethods();
            ta.classAction(cl);
            for (Fd fd : fields) {
                ta.fieldAction(fd);
            }
            for (Md md : methods) {
                ta.methodAction(md);
            }
        }
    }
}

