/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf.classfile;

import COM.rl.obf.classfile.AnnotationInfo;
import COM.rl.obf.classfile.AttrInfo;
import COM.rl.obf.classfile.ClassFile;
import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.ConstantPool;
import COM.rl.obf.classfile.NameMapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AnnotationsAttrInfo
extends AttrInfo {
    private List<AnnotationInfo> annotationTable;

    protected AnnotationsAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) throws ClassFileException {
        for (AnnotationInfo ai : this.annotationTable) {
            ai.markUtf8Refs(pool);
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException, ClassFileException {
        int u2numAnnotations = din.readUnsignedShort();
        this.annotationTable = new ArrayList<AnnotationInfo>(u2numAnnotations);
        for (int i = 0; i < u2numAnnotations; ++i) {
            this.annotationTable.add(AnnotationInfo.create(din));
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException, ClassFileException {
        dout.writeShort(this.annotationTable.size());
        for (AnnotationInfo ai : this.annotationTable) {
            ai.write(dout);
        }
    }

    @Override
    protected void remap(ClassFile cf, NameMapper nm) throws ClassFileException {
        for (AnnotationInfo ai : this.annotationTable) {
            ai.remap(cf, nm);
        }
    }
}

