/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf.classfile;

import COM.rl.obf.classfile.ClassFile;
import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.CpInfo;
import COM.rl.obf.classfile.Utf8CpInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ConstantPool
implements Iterable<CpInfo> {
    private ClassFile myClassFile;
    private List<CpInfo> pool;

    public ConstantPool(ClassFile classFile, List<CpInfo> cpInfo) {
        this.myClassFile = classFile;
        this.pool = new ArrayList<CpInfo>(cpInfo);
    }

    @Override
    public Iterator<CpInfo> iterator() {
        return this.pool.iterator();
    }

    public int length() {
        return this.pool.size();
    }

    public CpInfo getCpEntry(int i) throws ClassFileException {
        try {
            return this.pool.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ClassFileException("Constant Pool index out of range.");
        }
    }

    public void updateRefCount() throws ClassFileException {
        this.walkPool(new PoolAction(){

            @Override
            public void defaultAction(CpInfo cpInfo) {
                cpInfo.resetRefCount();
            }
        });
        this.myClassFile.markUtf8Refs();
        this.myClassFile.markNTRefs();
        this.walkPool(new PoolAction(){

            @Override
            public void utf8Action(Utf8CpInfo cpInfo) {
                if (cpInfo.getRefCount() == 0) {
                    cpInfo.clearString();
                }
            }
        });
    }

    public void incRefCount(int i) throws ClassFileException {
        CpInfo cpInfo = this.getCpEntry(i);
        if (cpInfo == null) {
            return;
        }
        cpInfo.incRefCount();
    }

    public int remapUtf8To(String newString, int oldIndex) throws ClassFileException {
        this.decRefCount(oldIndex);
        return this.addUtf8Entry(newString);
    }

    public void decRefCount(int i) throws ClassFileException {
        CpInfo cpInfo = this.getCpEntry(i);
        if (cpInfo == null) {
            return;
        }
        cpInfo.decRefCount();
    }

    public int addEntry(CpInfo entry) {
        int index = this.pool.size();
        this.pool.add(entry);
        return index;
    }

    protected int addUtf8Entry(String s) {
        Utf8CpInfo entry;
        CpInfo cpInfo;
        int i;
        ListIterator<CpInfo> iter = this.pool.listIterator();
        while (iter.hasNext()) {
            i = iter.nextIndex();
            cpInfo = iter.next();
            if (!(cpInfo instanceof Utf8CpInfo) || !(entry = (Utf8CpInfo)cpInfo).getString().equals(s)) continue;
            entry.incRefCount();
            return i;
        }
        iter = this.pool.listIterator();
        while (iter.hasNext()) {
            i = iter.nextIndex();
            cpInfo = iter.next();
            if (!(cpInfo instanceof Utf8CpInfo) || (entry = (Utf8CpInfo)cpInfo).getRefCount() != 0) continue;
            entry.setString(s);
            entry.incRefCount();
            return i;
        }
        return this.addEntry(new Utf8CpInfo(s));
    }

    private void walkPool(PoolAction pa) {
        for (CpInfo cpInfo : this.pool) {
            if (cpInfo instanceof Utf8CpInfo) {
                pa.utf8Action((Utf8CpInfo)cpInfo);
                continue;
            }
            if (cpInfo == null) continue;
            pa.defaultAction(cpInfo);
        }
    }

    class PoolAction {
        PoolAction() {
        }

        public void utf8Action(Utf8CpInfo cpInfo) {
            this.defaultAction(cpInfo);
        }

        public void defaultAction(CpInfo cpInfo) {
        }
    }
}

