/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf.classfile;

import COM.rl.obf.classfile.AttrInfo;
import COM.rl.obf.classfile.ClassFile;
import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.ConstantPool;
import COM.rl.obf.classfile.LocalVariableInfo;
import COM.rl.obf.classfile.NameMapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LocalVariableTableAttrInfo
extends AttrInfo {
    private List<LocalVariableInfo> localVariableTable;

    protected LocalVariableTableAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "LocalVariableTable";
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) throws ClassFileException {
        for (LocalVariableInfo lv : this.localVariableTable) {
            lv.markUtf8Refs(pool);
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException, ClassFileException {
        int u2localVariableTableLength = din.readUnsignedShort();
        this.localVariableTable = new ArrayList<LocalVariableInfo>(u2localVariableTableLength);
        for (int i = 0; i < u2localVariableTableLength; ++i) {
            this.localVariableTable.add(LocalVariableInfo.create(din));
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException, ClassFileException {
        dout.writeShort(this.localVariableTable.size());
        for (LocalVariableInfo lv : this.localVariableTable) {
            lv.write(dout);
        }
    }

    @Override
    protected void remap(ClassFile cf, NameMapper nm) throws ClassFileException {
        for (LocalVariableInfo lv : this.localVariableTable) {
            lv.remap(cf, nm);
        }
    }
}

