/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionEdge;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionNode;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionsGraph;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.util.FastSparseSetFactory;
import org.jetbrains.java.decompiler.util.SFormsFastMapDirect;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class DotExporter {
    private static final String DOTS_FOLDER = "Z:/dots/";
    private static final boolean DUMP_DOTS = false;

    private static String toDotFormat(Statement stat) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("digraph G {\r\n");
        for (Statement st : stat.getStats()) {
            String destid;
            String sourceid = st.id + (st.getSuccessorEdges(2).isEmpty() ? "" : "000000");
            buffer.append(sourceid + " [shape=box,label=\"" + sourceid + "\"];\r\n");
            for (StatEdge edge : st.getSuccessorEdges(0x40000000)) {
                destid = edge.getDestination().id + (edge.getDestination().getSuccessorEdges(2).isEmpty() ? "" : "000000");
                buffer.append(sourceid + "->" + destid + ";\r\n");
                if (stat.getStats().contains(edge.getDestination())) continue;
                buffer.append(destid + " [label=\"" + destid + "\"];\r\n");
            }
            for (StatEdge edge : st.getSuccessorEdges(2)) {
                destid = edge.getDestination().id + (edge.getDestination().getSuccessorEdges(2).isEmpty() ? "" : "000000");
                buffer.append(sourceid + " -> " + destid + " [style=dotted];\r\n");
                if (stat.getStats().contains(edge.getDestination())) continue;
                buffer.append(destid + " [label=\"" + destid + "\"];\r\n");
            }
        }
        buffer.append("}");
        return buffer.toString();
    }

    private static String toDotFormat(ControlFlowGraph graph, boolean showMultipleEdges) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("digraph G {\r\n");
        VBStyleCollection<BasicBlock, Integer> blocks = graph.getBlocks();
        for (int i = 0; i < blocks.size(); ++i) {
            BasicBlock block = (BasicBlock)blocks.get(i);
            buffer.append(block.id + " [shape=box,label=\"" + block.id + "\"];\r\n");
            List<BasicBlock> suc = block.getSuccs();
            if (!showMultipleEdges) {
                HashSet<BasicBlock> set = new HashSet<BasicBlock>();
                set.addAll(suc);
                suc = Collections.list(Collections.enumeration(set));
            }
            for (int j = 0; j < suc.size(); ++j) {
                buffer.append(block.id + "->" + suc.get((int)j).id + ";\r\n");
            }
            suc = block.getSuccExceptions();
            if (!showMultipleEdges) {
                HashSet<BasicBlock> set = new HashSet<BasicBlock>();
                set.addAll(suc);
                suc = Collections.list(Collections.enumeration(set));
            }
            for (int j = 0; j < suc.size(); ++j) {
                buffer.append(block.id + " -> " + suc.get((int)j).id + " [style=dotted];\r\n");
            }
        }
        buffer.append("}");
        return buffer.toString();
    }

    private static String toDotFormat(VarVersionsGraph graph) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("digraph G {\r\n");
        VBStyleCollection<VarVersionNode, VarVersionPair> blocks = graph.nodes;
        for (int i = 0; i < blocks.size(); ++i) {
            VarVersionNode block = (VarVersionNode)blocks.get(i);
            buffer.append(block.var * 1000 + block.version + " [shape=box,label=\"" + block.var + "_" + block.version + "\"];\r\n");
            for (VarVersionEdge edge : block.succs) {
                VarVersionNode dest = edge.dest;
                buffer.append(block.var * 1000 + block.version + "->" + (dest.var * 1000 + dest.version) + (edge.type == 1 ? " [style=dotted]" : "") + ";\r\n");
            }
        }
        buffer.append("}");
        return buffer.toString();
    }

    private static String toDotFormat(DirectGraph graph, Map<String, SFormsFastMapDirect> vars) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("digraph G {\r\n");
        VBStyleCollection<DirectNode, String> blocks = graph.nodes;
        for (int i = 0; i < blocks.size(); ++i) {
            SFormsFastMapDirect map;
            List<Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>>> lst;
            DirectNode block = (DirectNode)blocks.get(i);
            StringBuilder label = new StringBuilder(block.id);
            if (vars != null && vars.containsKey(block.id) && (lst = (map = vars.get(block.id)).entryList()) != null) {
                for (Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>> entry : lst) {
                    label.append("\\n").append(entry.getKey());
                    Set<Integer> set = entry.getValue().toPlainSet();
                    label.append("=").append(set.toString());
                }
            }
            buffer.append(DotExporter.directBlockIdToDot(block.id) + " [shape=box,label=\"" + label + "\"];\r\n");
            for (DirectNode dest : block.succs) {
                buffer.append(DotExporter.directBlockIdToDot(block.id) + "->" + DotExporter.directBlockIdToDot(dest.id) + ";\r\n");
            }
        }
        buffer.append("}");
        return buffer.toString();
    }

    private static String directBlockIdToDot(String id) {
        id = id.replaceAll("_try", "999");
        id = id.replaceAll("_tail", "888");
        id = id.replaceAll("_init", "111");
        id = id.replaceAll("_cond", "222");
        id = id.replaceAll("_inc", "333");
        return id;
    }

    private static File getFile(StructMethod mt, String suffix) {
        File root = new File(DOTS_FOLDER + mt.getClassStruct().qualifiedName);
        if (!root.isDirectory()) {
            root.mkdirs();
        }
        return new File(root, mt.getName().replace('<', '.').replace('>', '_') + mt.getDescriptor().replace('/', '.') + '_' + suffix + ".dot");
    }

    public static void toDotFile(DirectGraph dgraph, StructMethod mt, String suffix) {
        DotExporter.toDotFile(dgraph, mt, suffix, null);
    }

    public static void toDotFile(DirectGraph dgraph, StructMethod mt, String suffix, Map<String, SFormsFastMapDirect> vars) {
    }

    public static void toDotFile(Statement stat, StructMethod mt, String suffix) {
    }

    public static void toDotFile(VarVersionsGraph graph, StructMethod mt, String suffix) {
    }

    public static void toDotFile(ControlFlowGraph graph, StructMethod mt, String suffix, boolean showMultipleEdges) {
    }
}

