/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

public class ExprentUtil {
    public static boolean isVarReferenced(VarExprent var, Statement stat, VarExprent ... whitelist) {
        if (stat.getExprents() == null) {
            for (Object obj : stat.getSequentialObjects()) {
                if (!(obj instanceof Statement ? ExprentUtil.isVarReferenced(var, (Statement)obj, whitelist) : obj instanceof Exprent && ExprentUtil.isVarReferenced(var, (Exprent)obj, whitelist))) continue;
                return true;
            }
        } else {
            for (Exprent exp : stat.getExprents()) {
                if (!ExprentUtil.isVarReferenced(var, exp, whitelist)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isVarReferenced(VarExprent target, Exprent exp, VarExprent ... whitelist) {
        List<Exprent> lst = exp.getAllExprents(true);
        lst.add(exp);
        for (Exprent ex : lst) {
            VarExprent var;
            if (ex == target || ex.type != 12 || (var = (VarExprent)ex).getIndex() != target.getIndex() || var.getVersion() != target.getVersion()) continue;
            boolean allowed = false;
            for (VarExprent white : whitelist) {
                if (var != white) continue;
                allowed = true;
            }
            if (allowed) continue;
            return true;
        }
        return false;
    }
}

