/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.database;

import java.util.Set;
import jetbrains.exodus.core.dataStructures.hash.LinkedHashSet;
import jetbrains.exodus.database.LinkChangeType;
import jetbrains.exodus.database.TransientEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0007J\u000e\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0007J\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\u0003H\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u0011\u0010\u0017\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0019\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\fR\u0011\u0010\u001d\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0010\u00a8\u0006'"}, d2={"Ljetbrains/exodus/database/LinkChange;", "", "linkName", "", "(Ljava/lang/String;)V", "_addedEntities", "", "Ljetbrains/exodus/database/TransientEntity;", "_deletedEntities", "_removedEntities", "addedEntities", "getAddedEntities", "()Ljava/util/Set;", "addedEntitiesSize", "", "getAddedEntitiesSize", "()I", "changeType", "Ljetbrains/exodus/database/LinkChangeType;", "getChangeType", "()Ljetbrains/exodus/database/LinkChangeType;", "deletedEntities", "getDeletedEntities", "deletedEntitiesSize", "getDeletedEntitiesSize", "getLinkName", "()Ljava/lang/String;", "removedEntities", "getRemovedEntities", "removedEntitiesSize", "getRemovedEntitiesSize", "addAdded", "", "e", "addDeleted", "addRemoved", "isNotEmpty", "", "toString", "dnq-open-api"})
public final class LinkChange {
    private Set<TransientEntity> _addedEntities;
    private Set<TransientEntity> _removedEntities;
    private Set<TransientEntity> _deletedEntities;
    @NotNull
    private final String linkName;

    @Nullable
    public final Set<TransientEntity> getAddedEntities() {
        return this._addedEntities;
    }

    public final int getAddedEntitiesSize() {
        Set<TransientEntity> set = this._addedEntities;
        return set != null ? set.size() : 0;
    }

    @Nullable
    public final Set<TransientEntity> getRemovedEntities() {
        return this._removedEntities;
    }

    public final int getRemovedEntitiesSize() {
        Set<TransientEntity> set = this._removedEntities;
        return set != null ? set.size() : 0;
    }

    @Nullable
    public final Set<TransientEntity> getDeletedEntities() {
        return this._deletedEntities;
    }

    public final int getDeletedEntitiesSize() {
        Set<TransientEntity> set = this._deletedEntities;
        return set != null ? set.size() : 0;
    }

    @NotNull
    public final LinkChangeType getChangeType() {
        LinkChangeType linkChangeType;
        int added = this.getAddedEntitiesSize();
        int removed = this.getRemovedEntitiesSize() + this.getDeletedEntitiesSize();
        if (added != 0 && removed == 0) {
            linkChangeType = LinkChangeType.ADD;
        } else if (added == 0 && removed != 0) {
            linkChangeType = LinkChangeType.REMOVE;
        } else if (added != 0 && removed != 0) {
            linkChangeType = LinkChangeType.ADD_AND_REMOVE;
        } else {
            throw (Throwable)new IllegalStateException("No added or removed links.");
        }
        return linkChangeType;
    }

    public final boolean isNotEmpty() {
        return this.getAddedEntitiesSize() > 0 || this.getRemovedEntitiesSize() > 0 || this.getDeletedEntitiesSize() > 0;
    }

    @NotNull
    public String toString() {
        return this.linkName + ':' + (Object)((Object)this.getChangeType());
    }

    public final void addAdded(@NotNull TransientEntity e) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Set<TransientEntity> set2 = this._removedEntities;
        if (set2 != null) {
            if (set2.remove(e)) {
                return;
            }
        }
        if ((set = this._addedEntities) == null) {
            LinkedHashSet linkedHashSet;
            LinkedHashSet newSet = linkedHashSet = new LinkedHashSet();
            boolean bl = false;
            this._addedEntities = (Set)newSet;
            set = (Set)linkedHashSet;
        }
        Set addedEntities = set;
        addedEntities.add((TransientEntity)e);
    }

    public final void addRemoved(@NotNull TransientEntity e) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Set<TransientEntity> set2 = this._addedEntities;
        if (set2 != null) {
            if (set2.remove(e)) {
                return;
            }
        }
        if ((set = this._removedEntities) == null) {
            LinkedHashSet linkedHashSet;
            LinkedHashSet newSet = linkedHashSet = new LinkedHashSet();
            boolean bl = false;
            this._removedEntities = (Set)newSet;
            set = (Set)linkedHashSet;
        }
        Set removedEntities = set;
        removedEntities.add((TransientEntity)e);
    }

    public final void addDeleted(@NotNull TransientEntity e) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Set<TransientEntity> set2 = this._removedEntities;
        if (set2 != null) {
            set2.remove(e);
        }
        Set<TransientEntity> set3 = this._addedEntities;
        if (set3 != null) {
            set3.remove(e);
        }
        if ((set = this._deletedEntities) == null) {
            LinkedHashSet linkedHashSet;
            LinkedHashSet newSet = linkedHashSet = new LinkedHashSet();
            boolean bl = false;
            this._deletedEntities = (Set)newSet;
            set = (Set)linkedHashSet;
        }
        Set deletedEntities = set;
        deletedEntities.add((TransientEntity)e);
    }

    @NotNull
    public final String getLinkName() {
        return this.linkName;
    }

    public LinkChange(@NotNull String linkName) {
        Intrinsics.checkParameterIsNotNull((Object)linkName, (String)"linkName");
        this.linkName = linkName;
    }
}

