/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.database.exceptions;

import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.EntityFieldHandler;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.query.metadata.AssociationEndMetaData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Ljetbrains/exodus/database/exceptions/CardinalityViolationException;", "Ljetbrains/exodus/database/exceptions/DataIntegrityViolationException;", "entity", "Ljetbrains/exodus/database/TransientEntity;", "md", "Ljetbrains/exodus/query/metadata/AssociationEndMetaData;", "(Ljetbrains/exodus/database/TransientEntity;Ljetbrains/exodus/query/metadata/AssociationEndMetaData;)V", "message", "", "associationEndName", "(Ljava/lang/String;Ljetbrains/exodus/database/TransientEntity;Ljava/lang/String;)V", "entityFieldHandler", "Ljetbrains/exodus/database/exceptions/EntityFieldHandler;", "getEntityFieldHandler", "()Ljetbrains/exodus/database/exceptions/EntityFieldHandler;", "relatesTo", "", "fieldIdentity", "", "dnq-open-api"})
public class CardinalityViolationException
extends DataIntegrityViolationException {
    @NotNull
    private final EntityFieldHandler entityFieldHandler;

    @Override
    @NotNull
    public EntityFieldHandler getEntityFieldHandler() {
        return this.entityFieldHandler;
    }

    @Override
    public boolean relatesTo(@NotNull TransientEntity entity, @Nullable Object fieldIdentity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return super.relatesTo(entity, fieldIdentity) && Intrinsics.areEqual((Object)fieldIdentity, (Object)this.getEntityFieldHandler().getFieldName());
    }

    public CardinalityViolationException(@NotNull String message, @NotNull TransientEntity entity, @NotNull String associationEndName) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)associationEndName, (String)"associationEndName");
        super(message, "Value is required", entity);
        EntityId entityId = entity.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"entity.id");
        this.entityFieldHandler = new EntityFieldHandler(entityId, associationEndName);
    }

    public CardinalityViolationException(@NotNull TransientEntity entity, @NotNull AssociationEndMetaData md) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)md, (String)"md");
        String string = "Cardinality violation for [" + entity + '.' + md.getName() + "]. Required cardinality is [" + md.getCardinality().getName() + ']';
        String string2 = md.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"md.name");
        this(string, entity, string2);
    }
}

