/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.database.exceptions;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.SimplePropertyValidationException;
import jetbrains.exodus.database.exceptions.UniqueIndexViolationExceptionKt;
import jetbrains.exodus.query.metadata.Index;
import jetbrains.exodus.query.metadata.IndexField;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Ljetbrains/exodus/database/exceptions/UniqueIndexViolationException;", "Ljetbrains/exodus/database/exceptions/SimplePropertyValidationException;", "entity", "Ljetbrains/exodus/database/TransientEntity;", "index", "Ljetbrains/exodus/query/metadata/Index;", "(Ljetbrains/exodus/database/TransientEntity;Ljetbrains/exodus/query/metadata/Index;)V", "getIndex", "()Ljetbrains/exodus/query/metadata/Index;", "relatesTo", "", "fieldIdentity", "", "dnq-open-api"})
public class UniqueIndexViolationException
extends SimplePropertyValidationException {
    @NotNull
    private final Index index;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean relatesTo(@NotNull TransientEntity entity, @Nullable Object fieldIdentity) {
        IndexField indexField;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        if (!super.relatesTo(entity, fieldIdentity)) return false;
        if (fieldIdentity == null) return true;
        List list = this.index.getFields();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"index.fields");
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            IndexField it = (IndexField)element$iv;
            boolean bl = false;
            indexField = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)indexField, (String)"it");
        } while (!Intrinsics.areEqual((Object)indexField.getName(), (Object)fieldIdentity));
        return true;
    }

    @NotNull
    public final Index getIndex() {
        return this.index;
    }

    public UniqueIndexViolationException(@NotNull TransientEntity entity, @NotNull Index index) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        String string = UniqueIndexViolationExceptionKt.access$buildMessage(entity, index);
        List list = index.getFields();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"index.fields");
        Object object = CollectionsKt.first((List)list);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"index.fields.first()");
        String string2 = ((IndexField)object).getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"index.fields.first().name");
        super(string, "Value should be unique", entity, string2);
        this.index = index;
    }
}

