/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.dnq.simple;

import com.jetbrains.teamsys.dnq.database.PropertyConstraint;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.SimplePropertyValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.metadata.PropertyMetaData;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\b\u0012\u0004\u0012\u0002H\u00030\u0004B(\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010\u000bJ'\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001eR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lkotlinx/dnq/simple/RequireIfConstraint;", "R", "Lkotlinx/dnq/XdEntity;", "T", "Lcom/jetbrains/teamsys/dnq/database/PropertyConstraint;", "message", "", "predicate", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getMessage", "()Ljava/lang/String;", "getPredicate", "()Lkotlin/jvm/functions/Function1;", "check", "Ljetbrains/exodus/database/exceptions/SimplePropertyValidationException;", "entity", "Ljetbrains/exodus/database/TransientEntity;", "propertyMetaData", "Ljetbrains/exodus/query/metadata/PropertyMetaData;", "value", "(Ljetbrains/exodus/database/TransientEntity;Ljetbrains/exodus/query/metadata/PropertyMetaData;Ljava/lang/Object;)Ljetbrains/exodus/database/exceptions/SimplePropertyValidationException;", "getDisplayMessage", "propertyName", "propertyValue", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;", "getExceptionMessage", "isValid", "(Ljava/lang/Object;)Z", "dnq"})
public final class RequireIfConstraint<R extends XdEntity, T>
extends PropertyConstraint<T> {
    @Nullable
    private final String message;
    @NotNull
    private final Function1<R, Boolean> predicate;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public SimplePropertyValidationException check(@NotNull TransientEntity entity, @NotNull PropertyMetaData propertyMetaData, T value) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)propertyMetaData, (String)"propertyMetaData");
        if (value != null) return null;
        XdEntity xdEntity = XdExtensionsKt.getWrapper((Entity)entity);
        if (xdEntity == null) {
            throw new TypeCastException("null cannot be cast to non-null type R");
        }
        if ((Boolean)this.predicate.invoke((Object)xdEntity) == false) return null;
        String string = propertyMetaData.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"propertyMetaData.name");
        String propertyName = string;
        SimplePropertyValidationException simplePropertyValidationException = new SimplePropertyValidationException(this.getExceptionMessage(propertyName, value), this.getDisplayMessage(propertyName, value), entity, propertyName);
        return simplePropertyValidationException;
    }

    public boolean isValid(T value) {
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public String getExceptionMessage(@NotNull String propertyName, T propertyValue) {
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        return "Value for " + propertyName + " is required";
    }

    @NotNull
    public String getDisplayMessage(@NotNull String propertyName, T propertyValue) {
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        String string = this.message;
        if (string == null) {
            string = "required";
        }
        return string;
    }

    @Nullable
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public final Function1<R, Boolean> getPredicate() {
        return this.predicate;
    }

    public RequireIfConstraint(@Nullable String message, @NotNull Function1<? super R, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        this.message = message;
        this.predicate = predicate;
    }
}

