/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.ideaVim;

import com.github.copilot.actions.CopilotActionPromoter;
import com.github.copilot.editor.CopilotEditorManager;
import com.github.copilot.editor.InlayDisposeContext;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.VimPlugin;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import org.jetbrains.annotations.NotNull;

public class IdeaVimActionListener
implements AnActionListener {
    public void afterActionPerformed(@NotNull AnAction action, @NotNull AnActionEvent event, @NotNull AnActionResult result) {
        if (!VimPlugin.isEnabled()) {
            return;
        }
        if (CopilotActionPromoter.isIdeaVimAction((AnAction)action) && this.isEscapeKeypress(event)) {
            CopilotEditorManager copilotEditorManager = CopilotEditorManager.getInstance();
            Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor != null && copilotEditorManager.hasCompletionInlays(editor)) {
                copilotEditorManager.disposeInlays(editor, InlayDisposeContext.UserAction);
            }
        }
    }

    private boolean isEscapeKeypress(@NotNull AnActionEvent event) {
        InputEvent inputEvent = event.getInputEvent();
        return inputEvent instanceof KeyEvent && inputEvent.getModifiersEx() == 0 && ((KeyEvent)inputEvent).getKeyCode() == 27;
    }
}

