/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationFullContent;
import com.intellij.openapi.util.NlsContexts;
import org.jetbrains.annotations.NotNull;

public final class CopilotNotifications {
    private static final String GROUP_ID = "GitHub Copilot";
    private static boolean quotaExceedNotificationShown = false;
    private static final String QUOTA_EXCEED_NOTIFICATION_PREFIX = "You've reached your monthly code completion limit.";

    private CopilotNotifications() {
    }

    public static Notification createFullContentNotification(@NotNull String title, @NotNull String content, @NotNull NotificationType type, boolean expireOnLinkClick) {
        if (content.contains(QUOTA_EXCEED_NOTIFICATION_PREFIX)) {
            if (quotaExceedNotificationShown) {
                return null;
            }
            quotaExceedNotificationShown = true;
        }
        FullContent notification = new FullContent(GROUP_ID, title, content, type);
        notification.setListener((NotificationListener)new NotificationListener.UrlOpeningListener(expireOnLinkClick));
        return notification;
    }

    private static class FullContent
    extends Notification
    implements NotificationFullContent {
        public FullContent(@NotNull String groupId, @NotNull @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String content, @NotNull NotificationType type) {
            super(groupId, title, content, type);
        }
    }
}

