/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CopilotPlugin {
    public static final PluginId COPILOT_ID = PluginId.getId((String)"com.github.copilot");

    private CopilotPlugin() {
    }

    @NotNull
    public static String getPluginName() {
        return "copilot-intellij";
    }

    public static boolean isCopilotPlugin(@NotNull PluginDescriptor pluginDescriptor) {
        return pluginDescriptor.getPluginId().equals((Object)COPILOT_ID);
    }

    @NotNull
    public static String getVersion() {
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)COPILOT_ID);
        return plugin == null ? "unknown" : plugin.getVersion();
    }

    @NotNull
    public static Path getPluginBasePath() {
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)COPILOT_ID);
        assert (plugin != null);
        return plugin.getPluginPath();
    }

    @NotNull
    public static String getEditorName() {
        try {
            return "JetBrains-" + ApplicationInfo.getInstance().getBuild().getProductCode();
        }
        catch (Exception e) {
            return "JetBrains-??";
        }
    }

    @NotNull
    public static String getReadableEditorName() {
        try {
            return ApplicationInfo.getInstance().getFullApplicationName();
        }
        catch (Exception e) {
            return "JetBrains IDE";
        }
    }

    @NotNull
    public static String getEditorVersion() {
        try {
            return ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
        }
        catch (Exception e) {
            return "ERROR";
        }
    }

    @NotNull
    public static String editorVersionString() {
        return CopilotPlugin.getEditorName() + "/" + CopilotPlugin.getEditorVersion();
    }

    @NotNull
    public static String pluginVersionString() {
        try {
            return CopilotPlugin.getPluginName() + "/" + CopilotPlugin.getVersion();
        }
        catch (Exception e) {
            return "copilot-intellij/ERROR";
        }
    }

    public static boolean isSupportedIDE(@Nullable Project project) {
        if (CopilotPlugin.isRemoteIDE()) {
            return true;
        }
        return !LightEdit.owns((Project)project);
    }

    public static boolean isRemoteIDE() {
        return "true".equals(System.getProperty("org.jetbrains.projector.server.enable"));
    }
}

