/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotPlugin;
import com.github.copilot.editor.CopilotEditorManager;
import com.github.copilot.editor.CopilotEditorUtil;
import com.github.copilot.editor.InlayDisposeContext;
import com.github.copilot.util.ApplicationUtil;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class CopilotPluginUnloadListener
implements DynamicPluginListener {
    public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
        if (CopilotPlugin.isCopilotPlugin((PluginDescriptor)pluginDescriptor)) {
            CopilotPluginUnloadListener.disposeEditorInlays();
            CopilotBundle.INSTANCE.clearLocaleCache();
        }
    }

    private static void disposeEditorInlays() {
        for (Project project : ApplicationUtil.findValidProjects()) {
            Editor editor = CopilotEditorUtil.getSelectedEditorSafely(project);
            if (editor == null || editor.isDisposed()) continue;
            CopilotEditorManager.getInstance().disposeInlays(editor, InlayDisposeContext.UserAction);
        }
    }
}

