/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.actions;

import com.github.copilot.CopilotBundle;
import com.github.copilot.actions.CopilotAction;
import com.github.copilot.editor.CopilotEditorManager;
import com.github.copilot.util.CopilotScreenReaderUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import org.jetbrains.annotations.NotNull;

abstract class AbstractCopilotCycleAction
extends AnAction
implements DumbAware,
CopilotAction {
    AbstractCopilotCycleAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    protected abstract boolean doCycleAction(@NotNull Editor var1);

    @NotNull
    protected String getWarningHintText() {
        return CopilotBundle.get("action.copilot.cycleNextInlays.noMoreAvailableError");
    }

    public void update(@NotNull AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        boolean hasInlays = editor != null && CopilotEditorManager.getInstance().hasCompletionInlays(editor);
        e.getPresentation().setEnabled(hasInlays);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        if (!this.doCycleAction(editor)) {
            AbstractCopilotCycleAction.showCycleWarning(editor, this.getWarningHintText());
        }
    }

    private static void showCycleWarning(@NotNull Editor editor, @NotNull String hintText) {
        int offset = editor.getCaretModel().getOffset();
        HintManager.getInstance().showErrorHint(editor, hintText, offset, offset, (short)4, 1033, 1500);
        CopilotScreenReaderUtil.announce(hintText, true);
    }
}

