/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.actions;

import com.github.copilot.CopilotBundle;
import com.github.copilot.actions.CopilotAction;
import com.github.copilot.editor.CopilotEditorManager;
import com.github.copilot.editor.InlayDisposeContext;
import com.github.copilot.lang.agent.commands.EditorSettings;
import com.github.copilot.lsp.LSPManager;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.github.copilot.settings.CopilotApplicationState;
import com.github.copilot.statusBar.CopilotStatusBarWidget;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiFile;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

abstract class AbstractDisableCopilotCompletionsAction
extends AnAction
implements CopilotAction {
    private final boolean forCurrentFile;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        boolean enabledGlobally = CopilotApplicationSettings.settings().enableCompletions;
        boolean enabledForFile = file != null && CopilotApplicationSettings.settings().isEnabled(file.getLanguage());
        e.getPresentation().setEnabledAndVisible(enabledGlobally && enabledForFile);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        StatusBar bar;
        boolean global;
        Project project = e.getProject();
        if (project == null || project.isDisposed()) {
            return;
        }
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        boolean bl = global = !this.forCurrentFile || file == null;
        if (global) {
            CopilotApplicationSettings.settings().enableCompletions = false;
        } else {
            CopilotApplicationSettings.settings().disableLanguage(file.getLanguage());
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            CopilotEditorManager.getInstance().disposeInlays(editor, InlayDisposeContext.SettingsChange);
        }
        if ((bar = WindowManager.getInstance().getStatusBar(project)) != null) {
            bar.setInfo(CopilotBundle.get("action.copilot.disableCopilot.statusEnabled"));
        }
        CopilotStatusBarWidget.update(project);
        CopilotApplicationState settings = CopilotApplicationSettings.settings();
        EditorSettings agentSettings = EditorSettings.basedOn(settings);
        LSPManager.getInstance().notifyConfigurationChanged(agentSettings);
    }

    public boolean isDumbAware() {
        return true;
    }

    @Generated
    public AbstractDisableCopilotCompletionsAction(boolean forCurrentFile) {
        this.forCurrentFile = forCurrentFile;
    }
}

