/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.actions;

import com.github.copilot.actions.CopilotAction;
import com.github.copilot.actions.CopilotApplyInlaysAction;
import com.github.copilot.actions.CopilotDisposeInlaysEditorHandler;
import com.github.copilot.editor.CopilotEditorManager;
import com.intellij.openapi.actionSystem.ActionPromoter;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CopilotActionPromoter
implements ActionPromoter {
    public List<AnAction> promote(@NotNull List<? extends AnAction> actions, @NotNull DataContext context) {
        if (this.isDisabledForEditor((Editor)CommonDataKeys.EDITOR.getData(context))) {
            return null;
        }
        if (actions.stream().noneMatch(action2 -> action2 instanceof CopilotAction && action2 instanceof EditorAction)) {
            return null;
        }
        ArrayList<AnAction> result = new ArrayList<AnAction>(actions);
        result.sort((a, b) -> {
            boolean bIsCopilot;
            boolean aIsCopilot = a instanceof CopilotAction && a instanceof EditorAction;
            boolean bl = bIsCopilot = b instanceof CopilotAction && b instanceof EditorAction;
            if (aIsCopilot && bIsCopilot) {
                if (a instanceof CopilotApplyInlaysAction) {
                    return -1;
                }
                if (b instanceof CopilotApplyInlaysAction) {
                    return -1;
                }
            }
            if (CopilotActionPromoter.isIdeaVimAction(a) || CopilotActionPromoter.isIdeaVimAction(b)) {
                return 0;
            }
            if (aIsCopilot) {
                return -1;
            }
            if (bIsCopilot) {
                return 1;
            }
            return 0;
        });
        return result;
    }

    private boolean isDisabledForEditor(Editor editor) {
        return editor == null || !CopilotEditorManager.getInstance().isAvailable(editor) || !CopilotApplyInlaysAction.isSupported(editor) && !CopilotDisposeInlaysEditorHandler.isEditorSupported(editor);
    }

    public static boolean isIdeaVimAction(@NotNull AnAction action2) {
        String packagePrefix = "com.maddyhome.idea.vim";
        if (action2.getClass().getName().startsWith(packagePrefix)) {
            return true;
        }
        if (action2 instanceof ActionWithDelegate) {
            Object delegate = ((ActionWithDelegate)action2).getDelegate();
            return delegate.getClass().getName().startsWith(packagePrefix);
        }
        return false;
    }
}

