/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.actions;

import com.github.copilot.actions.CopilotAction;
import com.github.copilot.editor.CopilotApplyInlayStrategy;
import com.github.copilot.editor.CopilotEditorManager;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.github.copilot.util.CopilotStringUtil;
import com.github.copilot.util.EditorUtilCopy;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.awt.event.KeyEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopilotApplyInlaysAction
extends EditorAction
implements DumbAware,
CopilotAction {
    public static final String ID = "copilot.applyInlays";

    public CopilotApplyInlaysAction() {
        super((EditorActionHandler)new ApplyInlaysHandler());
        this.setInjectedContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (this.isIgnoredKeyboardEvent(e)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        super.update(e);
    }

    private boolean isIgnoredKeyboardEvent(@NotNull AnActionEvent e) {
        if (!(e.getInputEvent() instanceof KeyEvent)) {
            return false;
        }
        if (((KeyEvent)e.getInputEvent()).getKeyChar() != '\t') {
            return false;
        }
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Editor editor = this.getEditor(e.getDataContext());
        if (editor == null) {
            return false;
        }
        Document document = editor.getDocument();
        int blockIndent = CodeStyle.getIndentOptions((Project)project, (Document)document).INDENT_SIZE;
        int caretOffset = editor.getCaretModel().getOffset();
        int line = document.getLineNumber(caretOffset);
        if (CopilotApplyInlaysAction.isNonEmptyLinePrefix(document, line, caretOffset)) {
            return false;
        }
        int caretOffsetAfterTab = EditorUtilCopy.indentLine(project, editor, line, blockIndent, caretOffset);
        if (caretOffsetAfterTab < caretOffset) {
            return false;
        }
        TextRange tabRange = TextRange.create((int)caretOffset, (int)caretOffsetAfterTab);
        CopilotEditorManager editorManager = CopilotEditorManager.getInstance();
        if (editorManager.countCompletionInlays(editor, tabRange, true, false, false, false) > 0L) {
            return false;
        }
        long endOfLineInlays = editorManager.countCompletionInlays(editor, tabRange, false, true, false, false);
        if (endOfLineInlays > 0L) {
            return false;
        }
        long blockInlays = editorManager.countCompletionInlays(editor, tabRange, false, false, true, false);
        if (blockInlays > 0L) {
            TextRange caretToEndOfLineRange = TextRange.create((int)caretOffset, (int)document.getLineEndOffset(line));
            return editorManager.countCompletionInlays(editor, caretToEndOfLineRange, true, true, false, true) > 0L;
        }
        return true;
    }

    private static boolean isNonEmptyLinePrefix(Document document, int lineNumber, int caretOffset) {
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        if (lineStartOffset == caretOffset) {
            return false;
        }
        String linePrefix = document.getText(TextRange.create((int)lineStartOffset, (int)caretOffset));
        return !CopilotStringUtil.isSpacesOrTabs(linePrefix, false);
    }

    static boolean isSupported(@NotNull Editor editor) {
        Project project = editor.getProject();
        boolean ideCompletionsSupported = CopilotApplicationSettings.settings().isShowIdeCompletions();
        return project != null && editor.getCaretModel().getCaretCount() == 1 && (ideCompletionsSupported || LookupManager.getActiveLookup((Editor)editor) == null) && CopilotEditorManager.getInstance().hasCompletionInlays(editor) && TemplateManager.getInstance((Project)project).getActiveTemplate(editor) == null;
    }

    private static class ApplyInlaysHandler
    extends EditorActionHandler {
        private ApplyInlaysHandler() {
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            return CopilotApplyInlaysAction.isSupported(editor);
        }

        public boolean executeInCommand(@NotNull Editor editor, DataContext dataContext) {
            return false;
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            CopilotEditorManager.getInstance().applyCompletion(editor, CopilotApplyInlayStrategy.WHOLE);
        }
    }
}

