/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.actions;

import com.github.copilot.editor.CopilotEditorManager;
import com.github.copilot.editor.InlayDisposeContext;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopilotDisposeInlaysEditorHandler
extends EditorActionHandler {
    @Nullable
    private final EditorActionHandler baseHandler;

    public CopilotDisposeInlaysEditorHandler(@Nullable EditorActionHandler baseHandler) {
        this.baseHandler = baseHandler;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        return CopilotDisposeInlaysEditorHandler.isEditorSupported(editor) || this.baseHandler != null && this.baseHandler.isEnabled(editor, caret, dataContext);
    }

    public boolean executeInCommand(@NotNull Editor editor, DataContext dataContext) {
        return this.baseHandler != null && this.baseHandler.executeInCommand(editor, dataContext);
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (CopilotDisposeInlaysEditorHandler.isEditorSupported(editor)) {
            CopilotEditorManager.getInstance().disposeInlays(editor, InlayDisposeContext.CaretChange);
        }
        if (this.baseHandler != null && this.baseHandler.isEnabled(editor, caret, dataContext)) {
            this.baseHandler.execute(editor, caret, dataContext);
        }
    }

    static boolean isEditorSupported(@NotNull Editor editor) {
        CopilotEditorManager manager = CopilotEditorManager.getInstance();
        return manager.isAvailable(editor) && manager.hasCompletionInlays(editor) && LookupManager.getActiveLookup((Editor)editor) == null;
    }
}

