/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.actions;

import com.github.copilot.CopilotBundle;
import com.github.copilot.actions.CopilotAction;
import com.github.copilot.lang.agent.commands.EditorSettings;
import com.github.copilot.lsp.LSPManager;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.github.copilot.settings.CopilotApplicationState;
import com.github.copilot.statusBar.CopilotStatusBarWidget;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class EnableCopilotCompletionsAction
extends AnAction
implements CopilotAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        boolean currentlyDisabled = !CopilotApplicationSettings.settings().enableCompletions || file != null && !CopilotApplicationSettings.isCopilotEnabled(file);
        e.getPresentation().setEnabledAndVisible(currentlyDisabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        StatusBar bar;
        Project project = e.getProject();
        if (project == null || project.isDisposed()) {
            return;
        }
        CopilotApplicationState settings = CopilotApplicationSettings.settings();
        settings.enableCompletions = true;
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file != null) {
            settings.enableLanguage(file.getLanguage());
        }
        if ((bar = WindowManager.getInstance().getStatusBar(project)) != null) {
            bar.setInfo(CopilotBundle.get("action.copilot.enableCopilot.statusEnabled"));
        }
        CopilotStatusBarWidget.update(project);
        EditorSettings agentSettings = EditorSettings.basedOn(settings);
        LSPManager.getInstance().notifyConfigurationChanged(agentSettings);
    }

    public boolean isDumbAware() {
        return true;
    }
}

