/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.actions;

import com.github.copilot.CopilotBundle;
import com.github.copilot.editor.CopilotEditorManager;
import com.github.copilot.editor.CopilotEditorUtil;
import com.github.copilot.toolWindow.OpenCopilotToolWindowManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class RefreshCopilotToolWindowAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public RefreshCopilotToolWindowAction() {
        super(CopilotBundle.get("openCopilot.refreshAction"), null, AllIcons.Actions.Refresh);
        AnAction refreshAction = ActionManager.getInstance().getAction("Refresh");
        if (refreshAction != null) {
            this.copyShortcutFrom(refreshAction);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Editor editor = CopilotEditorUtil.getSelectedEditorSafely(project);
        if (editor == null || !CopilotEditorManager.getInstance().isAvailable(editor)) {
            return;
        }
        OpenCopilotToolWindowManager.getInstance().openCopilot(editor, true);
    }
}

