/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.agent;

import com.github.copilot.chat.agent.avatar.RemoteAgentAvatarService;
import com.github.copilot.chat.agent.avatar.RemoteAgentAvatarServiceKt;
import com.github.copilot.chat.conversation.agent.rpc.ConfirmationResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/github/copilot/chat/agent/RemoteAgent;", "", "slug", "", "name", "description", "avatarUrl", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getSlug", "()Ljava/lang/String;", "getName", "getDescription", "getAvatarUrl", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "core"})
public final class RemoteAgent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String slug;
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @Nullable
    private final String avatarUrl;
    @NotNull
    public static final String INPUT_PREFIX = "@";
    @NotNull
    private static final String SLUG = "slug";
    @NotNull
    private static final Regex slugFromInputRegex = new Regex("^@(?<slug>\\S+)");
    @NotNull
    private static RemoteAgentAvatarService avatarService = RemoteAgentAvatarServiceKt.RemoteAgentAvatarService();

    public RemoteAgent(@NotNull String slug, @NotNull String name, @NotNull String description, @Nullable String avatarUrl) {
        Intrinsics.checkNotNullParameter((Object)slug, (String)SLUG);
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.slug = slug;
        this.name = name;
        this.description = description;
        this.avatarUrl = avatarUrl;
    }

    @NotNull
    public final String getSlug() {
        return this.slug;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @Nullable
    public final String getAvatarUrl() {
        return this.avatarUrl;
    }

    @NotNull
    public final String component1() {
        return this.slug;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final String component3() {
        return this.description;
    }

    @Nullable
    public final String component4() {
        return this.avatarUrl;
    }

    @NotNull
    public final RemoteAgent copy(@NotNull String slug, @NotNull String name, @NotNull String description, @Nullable String avatarUrl) {
        Intrinsics.checkNotNullParameter((Object)slug, (String)SLUG);
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return new RemoteAgent(slug, name, description, avatarUrl);
    }

    public static /* synthetic */ RemoteAgent copy$default(RemoteAgent remoteAgent, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = remoteAgent.slug;
        }
        if ((n & 2) != 0) {
            string2 = remoteAgent.name;
        }
        if ((n & 4) != 0) {
            string3 = remoteAgent.description;
        }
        if ((n & 8) != 0) {
            string4 = remoteAgent.avatarUrl;
        }
        return remoteAgent.copy(string, string2, string3, string4);
    }

    @NotNull
    public String toString() {
        return "RemoteAgent(slug=" + this.slug + ", name=" + this.name + ", description=" + this.description + ", avatarUrl=" + this.avatarUrl + ")";
    }

    public int hashCode() {
        int result = this.slug.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.description.hashCode();
        result = result * 31 + (this.avatarUrl == null ? 0 : this.avatarUrl.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RemoteAgent)) {
            return false;
        }
        RemoteAgent remoteAgent = (RemoteAgent)other;
        if (!Intrinsics.areEqual((Object)this.slug, (Object)remoteAgent.slug)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)remoteAgent.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)remoteAgent.description)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.avatarUrl, (Object)remoteAgent.avatarUrl);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00052\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/github/copilot/chat/agent/RemoteAgent$Companion;", "", "<init>", "()V", "INPUT_PREFIX", "", "SLUG", "slugFromInputRegex", "Lkotlin/text/Regex;", "avatarService", "Lcom/github/copilot/chat/agent/avatar/RemoteAgentAvatarService;", "getAvatarService", "()Lcom/github/copilot/chat/agent/avatar/RemoteAgentAvatarService;", "setAvatarService", "(Lcom/github/copilot/chat/agent/avatar/RemoteAgentAvatarService;)V", "slugFromUserMessage", "input", "confirmation", "Lcom/github/copilot/chat/conversation/agent/rpc/ConfirmationResponse;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RemoteAgentAvatarService getAvatarService() {
            return avatarService;
        }

        public final void setAvatarService(@NotNull RemoteAgentAvatarService remoteAgentAvatarService) {
            Intrinsics.checkNotNullParameter((Object)remoteAgentAvatarService, (String)"<set-?>");
            avatarService = remoteAgentAvatarService;
        }

        @Nullable
        public final String slugFromUserMessage(@NotNull String input, @Nullable ConfirmationResponse confirmation) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Object object = confirmation;
            if (object == null || (object = ((ConfirmationResponse)object).getAgentSlug()) == null) {
                MatchResult matchResult = Regex.find$default((Regex)slugFromInputRegex, (CharSequence)((Object)StringsKt.trim((CharSequence)input)).toString(), (int)0, (int)2, null);
                object = matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult, (String)RemoteAgent.SLUG)) != null ? matchResult.getValue() : null;
            }
            return object;
        }

        public static /* synthetic */ String slugFromUserMessage$default(Companion companion, String string, ConfirmationResponse confirmationResponse, int n, Object object) {
            if ((n & 2) != 0) {
                confirmationResponse = null;
            }
            return companion.slugFromUserMessage(string, confirmationResponse);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

