/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.agent.avatar;

import com.github.copilot.chat.agent.RemoteAgent;
import com.github.copilot.chat.agent.avatar.CachedAvatar;
import com.github.copilot.chat.agent.avatar.RemoteAgentAvatar;
import com.github.copilot.chat.agent.avatar.RemoteAgentAvatarService;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/copilot/chat/agent/avatar/AgentAvatarService;", "Lcom/github/copilot/chat/agent/avatar/RemoteAgentAvatarService;", "<init>", "()V", "log", "Lcom/github/copilot/platform/utils/observability/GitHubLogger;", "getLog", "()Lcom/github/copilot/platform/utils/observability/GitHubLogger;", "avatars", "", "", "Lcom/github/copilot/chat/agent/avatar/CachedAvatar;", "cacheAvatar", "", "agent", "Lcom/github/copilot/chat/agent/RemoteAgent;", "getAvatar", "Lcom/github/copilot/chat/agent/avatar/RemoteAgentAvatar;", "agentSlug", "core"})
@SourceDebugExtension(value={"SMAP\nRemoteAgentAvatarService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteAgentAvatarService.kt\ncom/github/copilot/chat/agent/avatar/AgentAvatarService\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,96:1\n39#2:97\n*S KotlinDebug\n*F\n+ 1 RemoteAgentAvatarService.kt\ncom/github/copilot/chat/agent/avatar/AgentAvatarService\n*L\n28#1:97\n*E\n"})
final class AgentAvatarService
implements RemoteAgentAvatarService {
    @NotNull
    public static final AgentAvatarService INSTANCE = new AgentAvatarService();
    @NotNull
    private static final GitHubLogger log;
    @NotNull
    private static final Map<String, CachedAvatar> avatars;

    private AgentAvatarService() {
    }

    @NotNull
    public final GitHubLogger getLog() {
        return log;
    }

    @Override
    public void cacheAvatar(@NotNull RemoteAgent agent) {
        Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
        avatars.putIfAbsent(agent.getSlug(), new CachedAvatar(agent));
    }

    @Override
    @Nullable
    public RemoteAgentAvatar getAvatar(@NotNull String agentSlug) {
        Intrinsics.checkNotNullParameter((Object)agentSlug, (String)"agentSlug");
        CachedAvatar cachedAvatar = avatars.get(agentSlug);
        return cachedAvatar != null ? cachedAvatar.get() : null;
    }

    static {
        boolean $i$f$Logger = false;
        log = new GitHubLogger(RemoteAgentAvatarService.class);
        avatars = new ConcurrentHashMap();
    }
}

