/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.contentExclusion;

import com.github.copilot.chat.contentExclusion.CachingContentExclusionStatusService;
import com.github.copilot.chat.contentExclusion.ContentExclusionStatusService;
import com.github.copilot.chat.contentExclusion.EditorFile;
import com.github.copilot.chat.contentExclusion.FileListener;
import com.github.copilot.chat.contentExclusion.Project;
import com.github.copilot.chat.contentExclusion.StatusProjectServiceKt;
import com.github.copilot.lang.agent.commands.CheckFileStatusResult;
import com.github.copilot.platform.utils.ProjectService;
import com.github.copilot.status.FileStatusService;
import com.github.copilot.status.FileStatusServiceKt;
import io.ktor.util.collections.ConcurrentMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004*\u0001\u001d\b\u0000\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0012\b\u0002\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0018\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\fH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\r\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/github/copilot/chat/contentExclusion/CachingContentExclusionStatusService;", "Lcom/github/copilot/chat/contentExclusion/ContentExclusionStatusService;", "fileStatusService", "Lcom/github/copilot/status/FileStatusService;", "projectService", "Lcom/github/copilot/platform/utils/ProjectService;", "Lcom/github/copilot/chat/contentExclusion/Project;", "Lcom/github/copilot/chat/contentExclusion/StatusProjectService;", "<init>", "(Lcom/github/copilot/status/FileStatusService;Lcom/github/copilot/platform/utils/ProjectService;)V", "results", "Lio/ktor/util/collections/ConcurrentMap;", "", "Lcom/github/copilot/lang/agent/commands/CheckFileStatusResult;", "statusFutures", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "isExcluded", "", "fileUri", "isExcludedFuture", "blockedReason", "initOpenFilesAndFileListeners", "", "checkOpenFiles", "openFiles", "", "Lcom/github/copilot/chat/contentExclusion/EditorFile;", "contentExclusionFileListener", "com/github/copilot/chat/contentExclusion/CachingContentExclusionStatusService$contentExclusionFileListener$1", "()Lcom/github/copilot/chat/contentExclusion/CachingContentExclusionStatusService$contentExclusionFileListener$1;", "fetchAndCacheStatus", "core"})
@SourceDebugExtension(value={"SMAP\nCachingContentExclusionStatusService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachingContentExclusionStatusService.kt\ncom/github/copilot/chat/contentExclusion/CachingContentExclusionStatusService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1855#2,2:89\n1855#2,2:91\n*S KotlinDebug\n*F\n+ 1 CachingContentExclusionStatusService.kt\ncom/github/copilot/chat/contentExclusion/CachingContentExclusionStatusService\n*L\n34#1:89,2\n50#1:91,2\n*E\n"})
public final class CachingContentExclusionStatusService
implements ContentExclusionStatusService {
    @NotNull
    private final FileStatusService fileStatusService;
    @NotNull
    private final ProjectService<Project> projectService;
    @NotNull
    private final ConcurrentMap<String, CheckFileStatusResult> results;
    @NotNull
    private final ConcurrentMap<String, CompletableFuture<Void>> statusFutures;

    public CachingContentExclusionStatusService(@NotNull FileStatusService fileStatusService, @NotNull ProjectService<Project> projectService) {
        Intrinsics.checkNotNullParameter((Object)fileStatusService, (String)"fileStatusService");
        Intrinsics.checkNotNullParameter(projectService, (String)"projectService");
        this.fileStatusService = fileStatusService;
        this.projectService = projectService;
        this.results = new ConcurrentMap(0, 1, null);
        this.statusFutures = new ConcurrentMap(0, 1, null);
        this.initOpenFilesAndFileListeners();
    }

    public /* synthetic */ CachingContentExclusionStatusService(FileStatusService fileStatusService, ProjectService projectService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fileStatusService = FileStatusService.Companion.getDEFAULT();
        }
        if ((n & 2) != 0) {
            projectService = StatusProjectServiceKt.StatusProjectService();
        }
        this(fileStatusService, projectService);
    }

    @Override
    public boolean isExcluded(@NotNull String fileUri) {
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        CheckFileStatusResult checkFileStatusResult = (CheckFileStatusResult)this.results.get((Object)fileUri);
        return checkFileStatusResult != null ? FileStatusServiceKt.isBlocked(checkFileStatusResult) : false;
    }

    @Override
    @Nullable
    public CompletableFuture<Void> isExcludedFuture(@NotNull String fileUri) {
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        return (CompletableFuture)this.statusFutures.get((Object)fileUri);
    }

    @Override
    @Nullable
    public String blockedReason(@NotNull String fileUri) {
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        if (!this.isExcluded(fileUri)) {
            return null;
        }
        CheckFileStatusResult checkFileStatusResult = (CheckFileStatusResult)this.results.get((Object)fileUri);
        return checkFileStatusResult != null ? checkFileStatusResult.reason : null;
    }

    private final void initOpenFilesAndFileListeners() {
        ProjectService<Project> $this$initOpenFilesAndFileListeners_u24lambda_u244 = this.projectService;
        boolean bl = false;
        contentExclusionFileListener.1 listener2 = this.contentExclusionFileListener();
        Iterable $this$forEach$iv = $this$initOpenFilesAndFileListeners_u24lambda_u244.getAllProjects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project project = (Project)element$iv;
            boolean bl2 = false;
            project.runWhenInitialized((Function0<Unit>)((Function0)() -> CachingContentExclusionStatusService.initOpenFilesAndFileListeners$lambda$4$lambda$1$lambda$0(this, project)));
            project.addFileListener(listener2);
        }
        $this$initOpenFilesAndFileListeners_u24lambda_u244.onProjectOpened((Function1<Project, Unit>)((Function1)arg_0 -> CachingContentExclusionStatusService.initOpenFilesAndFileListeners$lambda$4$lambda$3(listener2, this, arg_0)));
    }

    private final void checkOpenFiles(List<? extends EditorFile> openFiles) {
        Iterable $this$forEach$iv = openFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorFile it = (EditorFile)element$iv;
            boolean bl = false;
            this.fetchAndCacheStatus(it.getUri());
        }
    }

    private final contentExclusionFileListener.1 contentExclusionFileListener() {
        return new FileListener(this){
            final /* synthetic */ CachingContentExclusionStatusService this$0;
            {
                this.this$0 = $receiver;
            }

            public void fileOpened(EditorFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                CachingContentExclusionStatusService.access$fetchAndCacheStatus(this.this$0, file.getUri());
            }

            public void fileClosed(EditorFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                String string = file.getUri();
                CachingContentExclusionStatusService cachingContentExclusionStatusService = this.this$0;
                String uri = string;
                boolean bl = false;
                CachingContentExclusionStatusService.access$getResults$p(cachingContentExclusionStatusService).remove((Object)uri);
                CompletableFuture cfr_ignored_0 = (CompletableFuture)CachingContentExclusionStatusService.access$getStatusFutures$p(cachingContentExclusionStatusService).remove((Object)uri);
            }
        };
    }

    private final void fetchAndCacheStatus(String fileUri) {
        if (this.statusFutures.containsKey((Object)fileUri) || ((Map)this.results).containsKey(fileUri)) {
            return;
        }
        this.statusFutures.computeIfAbsent((Object)fileUri, CachingContentExclusionStatusService::fetchAndCacheStatus$lambda$6);
        this.fileStatusService.checkFileStatus(fileUri, (Function1<? super Throwable, Unit>)((Function1)arg_0 -> CachingContentExclusionStatusService.fetchAndCacheStatus$lambda$7(this, fileUri, arg_0)), (Function1<? super CheckFileStatusResult, Unit>)((Function1)arg_0 -> CachingContentExclusionStatusService.fetchAndCacheStatus$lambda$8(this, fileUri, arg_0)));
    }

    private static final Unit initOpenFilesAndFileListeners$lambda$4$lambda$1$lambda$0(CachingContentExclusionStatusService this$0, Project $project) {
        this$0.checkOpenFiles($project.getAllOpenFiles());
        return Unit.INSTANCE;
    }

    private static final Unit initOpenFilesAndFileListeners$lambda$4$lambda$3$lambda$2(CachingContentExclusionStatusService this$0, Project $project) {
        this$0.checkOpenFiles($project.getAllOpenFiles());
        return Unit.INSTANCE;
    }

    private static final Unit initOpenFilesAndFileListeners$lambda$4$lambda$3(contentExclusionFileListener.1 $listener, CachingContentExclusionStatusService this$0, Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.runWhenInitialized((Function0<Unit>)((Function0)() -> CachingContentExclusionStatusService.initOpenFilesAndFileListeners$lambda$4$lambda$3$lambda$2(this$0, project)));
        project.addFileListener($listener);
        return Unit.INSTANCE;
    }

    private static final CompletableFuture fetchAndCacheStatus$lambda$6() {
        return new CompletableFuture();
    }

    private static final Unit fetchAndCacheStatus$lambda$7(CachingContentExclusionStatusService this$0, String $fileUri, Throwable it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ((Map)this$0.results).put($fileUri, new CheckFileStatusResult("included", ""));
            CompletableFuture completableFuture = (CompletableFuture)this$0.statusFutures.get((Object)$fileUri);
            if (completableFuture == null) break block0;
            completableFuture.complete(null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit fetchAndCacheStatus$lambda$8(CachingContentExclusionStatusService this$0, String $fileUri, CheckFileStatusResult it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ((Map)this$0.results).put($fileUri, it);
            CompletableFuture completableFuture = (CompletableFuture)this$0.statusFutures.get((Object)$fileUri);
            if (completableFuture == null) break block0;
            completableFuture.complete(null);
        }
        return Unit.INSTANCE;
    }

    public CachingContentExclusionStatusService() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ void access$fetchAndCacheStatus(CachingContentExclusionStatusService $this, String fileUri) {
        $this.fetchAndCacheStatus(fileUri);
    }

    public static final /* synthetic */ ConcurrentMap access$getResults$p(CachingContentExclusionStatusService $this) {
        return $this.results;
    }

    public static final /* synthetic */ ConcurrentMap access$getStatusFutures$p(CachingContentExclusionStatusService $this) {
        return $this.statusFutures;
    }
}

