/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.conversation.agent;

import com.github.copilot.chat.agent.RemoteAgent;
import com.github.copilot.chat.conversation.ConversationProgressHandler;
import com.github.copilot.chat.conversation.ConversationService;
import com.github.copilot.chat.conversation.agent.ContinueConversationResult;
import com.github.copilot.chat.conversation.agent.CopilotAgentConversationClient;
import com.github.copilot.chat.conversation.agent.CopilotAgentConversationClientKt;
import com.github.copilot.chat.conversation.agent.CopyCodeBlockResult;
import com.github.copilot.chat.conversation.agent.CreateConversationResult;
import com.github.copilot.chat.conversation.agent.DeleteTurnResult;
import com.github.copilot.chat.conversation.agent.DestroyConversationResult;
import com.github.copilot.chat.conversation.agent.InsertCodeBlockResult;
import com.github.copilot.chat.conversation.agent.RateConversationMessageResult;
import com.github.copilot.chat.conversation.agent.RetryConversationHandler;
import com.github.copilot.chat.conversation.agent.SendMessageToAgentResult;
import com.github.copilot.chat.conversation.agent.context.ConversationContextListener;
import com.github.copilot.chat.conversation.agent.context.CopilotAgentConversationContextListener;
import com.github.copilot.chat.conversation.agent.rpc.Capabilities;
import com.github.copilot.chat.conversation.agent.rpc.ConfirmationResponse;
import com.github.copilot.chat.conversation.agent.rpc.Document;
import com.github.copilot.chat.conversation.agent.rpc.FileReference;
import com.github.copilot.chat.conversation.agent.rpc.PartialFollowUp;
import com.github.copilot.chat.conversation.agent.rpc.Turn;
import com.github.copilot.chat.conversation.agent.rpc.TurnKt;
import com.github.copilot.chat.conversation.agent.rpc.TurnsBuilder;
import com.github.copilot.chat.conversation.agent.rpc.WorkDoneTokenKt;
import com.github.copilot.chat.conversation.agent.rpc.command.ConversationCreateCommand;
import com.github.copilot.chat.conversation.agent.rpc.command.ConversationCreateCommandResponse;
import com.github.copilot.chat.conversation.agent.rpc.command.ConversationDestroyCommand;
import com.github.copilot.chat.conversation.agent.rpc.command.ConversationRatingCommand;
import com.github.copilot.chat.conversation.agent.rpc.command.ConversationTurnCommand;
import com.github.copilot.chat.conversation.agent.rpc.command.ConversationTurnCommandResponse;
import com.github.copilot.chat.conversation.agent.rpc.command.CopyCodeBlockCommand;
import com.github.copilot.chat.conversation.agent.rpc.command.DeleteTurnCommand;
import com.github.copilot.chat.conversation.agent.rpc.command.InsertCodeBlockCommand;
import com.github.copilot.chat.conversation.agent.rpc.message.ConversationError;
import com.github.copilot.chat.conversation.agent.rpc.message.ConversationProgress;
import com.github.copilot.chat.message.ChatFollowUp;
import com.github.copilot.chat.message.ChatMessage;
import com.github.copilot.chat.message.ChatMessageType;
import com.github.copilot.chat.message.references.ChatReference;
import com.github.copilot.chat.message.references.ChatReferenceKt;
import com.github.copilot.chat.message.references.FileChatReference;
import com.github.copilot.chat.session.SessionController;
import com.github.copilot.lang.agent.lsp.AgentWorkspaceFolders;
import com.github.copilot.lang.agent.lsp.VirtualFileUri;
import com.github.copilot.lang.agent.lsp.WorkspaceFolder;
import com.github.copilot.platform.utils.DisposableKt;
import com.github.copilot.platform.utils.File;
import com.github.copilot.platform.utils.FileService;
import com.github.copilot.platform.utils.FileServiceKt;
import com.github.copilot.platform.utils.ProjectUtils;
import com.github.copilot.platform.utils.PromiseKt;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.github.copilot.settings.CopilotChatLocale;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 I2\u00020\u0001:\u0001IB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cJ&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001f\u001a\u00060 j\u0002`!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J*\u0010$\u001a\u00020%2\n\u0010\u001f\u001a\u00060 j\u0002`!2\u0006\u0010&\u001a\u00020\u00192\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190(H\u0002J(\u0010)\u001a\u00020*2\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001f\u001a\u00060 j\u0002`!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\b\u0010+\u001a\u00020\u0017H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0019H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016J\f\u0010?\u001a\u00020#*\u00020@H\u0002J\u001c\u0010A\u001a\b\u0012\u0004\u0012\u00020B0(*\f\u0012\u0004\u0012\u00020C0(j\u0002`DH\u0002J\f\u0010E\u001a\u00020B*\u00020FH\u0002J\n\u0010G\u001a\u0004\u0018\u00010HH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/github/copilot/chat/conversation/agent/CopilotAgentConversationService;", "Lcom/github/copilot/chat/conversation/ConversationService;", "sessionController", "Lcom/github/copilot/chat/session/SessionController;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "client", "Lcom/github/copilot/chat/conversation/agent/CopilotAgentConversationClient;", "fileService", "Lcom/github/copilot/platform/utils/FileService;", "contextListener", "Lcom/github/copilot/chat/conversation/agent/context/ConversationContextListener;", "<init>", "(Lcom/github/copilot/chat/session/SessionController;Lcom/github/copilot/platform/utils/observability/Logger;Lcom/github/copilot/chat/conversation/agent/CopilotAgentConversationClient;Lcom/github/copilot/platform/utils/FileService;Lcom/github/copilot/chat/conversation/agent/context/ConversationContextListener;)V", "getSessionController", "()Lcom/github/copilot/chat/session/SessionController;", "conversationProgressPromises", "", "Lorg/jetbrains/concurrency/CancellablePromise;", "", "retryConversationHandler", "Lcom/github/copilot/chat/conversation/agent/RetryConversationHandler;", "onReply", "", "message", "Lcom/github/copilot/chat/message/ChatMessage;", "handler", "Lcom/github/copilot/chat/conversation/ConversationProgressHandler;", "(Lcom/github/copilot/chat/message/ChatMessage;Lcom/github/copilot/chat/conversation/ConversationProgressHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendMessageToAgent", "Lcom/github/copilot/chat/conversation/agent/SendMessageToAgentResult;", "workDoneToken", "", "Lcom/github/copilot/chat/conversation/agent/rpc/WorkDoneToken;", "followUp", "Lcom/github/copilot/chat/conversation/agent/rpc/PartialFollowUp;", "createConversation", "Lcom/github/copilot/chat/conversation/agent/CreateConversationResult;", "initialMessage", "persistedMessages", "", "continueConversation", "Lcom/github/copilot/chat/conversation/agent/ContinueConversationResult;", "cancelReplies", "rateChatMessage", "Lcom/github/copilot/chat/conversation/agent/RateConversationMessageResult;", "chatMessage", "copyCodeBlock", "Lcom/github/copilot/chat/conversation/agent/CopyCodeBlockResult;", "copyCodeBlockCommand", "Lcom/github/copilot/chat/conversation/agent/rpc/command/CopyCodeBlockCommand;", "insertCodeBlock", "Lcom/github/copilot/chat/conversation/agent/InsertCodeBlockResult;", "insertCodeBlockCommand", "Lcom/github/copilot/chat/conversation/agent/rpc/command/InsertCodeBlockCommand;", "deleteTurn", "Lcom/github/copilot/chat/conversation/agent/DeleteTurnResult;", "deleteTurnCommand", "Lcom/github/copilot/chat/conversation/agent/rpc/command/DeleteTurnCommand;", "destroyConversation", "Lcom/github/copilot/chat/conversation/agent/DestroyConversationResult;", "destroyConversationCommand", "Lcom/github/copilot/chat/conversation/agent/rpc/command/ConversationDestroyCommand;", "toPartial", "Lcom/github/copilot/chat/message/ChatFollowUp;", "toFileReferences", "Lcom/github/copilot/chat/conversation/agent/rpc/FileReference;", "Lcom/github/copilot/chat/message/references/ChatReference;", "Lcom/github/copilot/chat/message/references/ChatReferences;", "toFileReference", "Lcom/github/copilot/chat/message/references/FileChatReference;", "getCurrentDocument", "Lcom/github/copilot/chat/conversation/agent/rpc/Document;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCopilotAgentConversationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopilotAgentConversationService.kt\ncom/github/copilot/chat/conversation/agent/CopilotAgentConversationService\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n+ 3 CopilotAgentConversationClient.kt\ncom/github/copilot/chat/conversation/agent/CopilotAgentConversationClientKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,432:1\n39#2:433\n75#3:434\n1#4:435\n1549#5:436\n1620#5,3:437\n1855#5,2:440\n*S KotlinDebug\n*F\n+ 1 CopilotAgentConversationService.kt\ncom/github/copilot/chat/conversation/agent/CopilotAgentConversationService\n*L\n32#1:433\n55#1:434\n353#1:436\n353#1:437,3\n143#1:440,2\n*E\n"})
public final class CopilotAgentConversationService
implements ConversationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SessionController sessionController;
    @NotNull
    private final Logger log;
    @NotNull
    private final CopilotAgentConversationClient client;
    @NotNull
    private final FileService fileService;
    @NotNull
    private final ConversationContextListener contextListener;
    @NotNull
    private final List<CancellablePromise<? extends Object>> conversationProgressPromises;
    @NotNull
    private final RetryConversationHandler retryConversationHandler;
    @Nullable
    private static ConversationContextListener agentContextListener;

    public CopilotAgentConversationService(@NotNull SessionController sessionController, @NotNull Logger log, @NotNull CopilotAgentConversationClient client, @NotNull FileService fileService, @Nullable ConversationContextListener contextListener) {
        Intrinsics.checkNotNullParameter((Object)sessionController, (String)"sessionController");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)fileService, (String)"fileService");
        this.sessionController = sessionController;
        this.log = log;
        this.client = client;
        this.fileService = fileService;
        ConversationContextListener conversationContextListener = contextListener;
        if (conversationContextListener == null) {
            conversationContextListener = CopilotAgentConversationService.Companion.getDefaultContextListener();
        }
        this.contextListener = conversationContextListener;
        this.conversationProgressPromises = new ArrayList();
        this.retryConversationHandler = new RetryConversationHandler();
        this.contextListener.start();
        this.retryConversationHandler.start();
    }

    public /* synthetic */ CopilotAgentConversationService(SessionController sessionController, Logger logger, CopilotAgentConversationClient copilotAgentConversationClient, FileService fileService, ConversationContextListener conversationContextListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(CopilotAgentConversationService.class);
        }
        if ((n & 4) != 0) {
            copilotAgentConversationClient = CopilotAgentConversationClientKt.CopilotAgentConversationClient();
        }
        if ((n & 8) != 0) {
            fileService = FileServiceKt.FileService();
        }
        if ((n & 0x10) != 0) {
            conversationContextListener = null;
        }
        this(sessionController, logger, copilotAgentConversationClient, fileService, conversationContextListener);
    }

    @Override
    @NotNull
    public SessionController getSessionController() {
        return this.sessionController;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object onReply(@NotNull ChatMessage message, @NotNull ConversationProgressHandler handler, @NotNull Continuation<? super Unit> $completion) {
        SendMessageToAgentResult sendMessageResult;
        void $this$registerProgressListener$iv;
        String workDoneToken = WorkDoneTokenKt.workDoneToken$default(null, 1, null);
        this.retryConversationHandler.rememberCallback((Function0<Unit>)((Function0)() -> CopilotAgentConversationService.onReply$lambda$0(this, message, handler)));
        CopilotAgentConversationClient copilotAgentConversationClient = this.client;
        Function2 listener$iv = (arg_0, arg_1) -> CopilotAgentConversationService.onReply$lambda$1(workDoneToken, handler, arg_0, arg_1);
        boolean $i$f$registerProgressListener = false;
        $this$registerProgressListener$iv.registerProgressListener(listener$iv, ConversationProgress.class);
        ChatFollowUp chatFollowUp = message.getFollowUp();
        SendMessageToAgentResult sendMessageToAgentResult = sendMessageResult = this.sendMessageToAgent(message, workDoneToken, chatFollowUp != null ? this.toPartial(chatFollowUp) : null);
        if (!(sendMessageToAgentResult instanceof SendMessageToAgentResult.Success)) {
            if (sendMessageToAgentResult instanceof SendMessageToAgentResult.Error) {
                this.getSessionController().unlockSession();
                String string = ((SendMessageToAgentResult.Error)sendMessageResult).getCause().getMessage();
                if (string == null) {
                    string = "";
                }
                handler.onError(new ConversationError(string, Boxing.boxBoolean((boolean)false), Boxing.boxBoolean((boolean)false), null, 8, null));
                return Unit.INSTANCE;
            }
            throw new NoWhenBranchMatchedException();
        }
        this.conversationProgressPromises.add(((SendMessageToAgentResult.Success)sendMessageResult).getPromise());
        return Unit.INSTANCE;
    }

    private final SendMessageToAgentResult sendMessageToAgent(ChatMessage message, String workDoneToken, PartialFollowUp followUp) {
        SendMessageToAgentResult sendMessageToAgentResult;
        if (this.getSessionController().getSession().isNotInitialized()) {
            SendMessageToAgentResult sendMessageToAgentResult2;
            CreateConversationResult result = this.createConversation(workDoneToken, message, this.getSessionController().getSession().getMessages());
            CreateConversationResult createConversationResult = result;
            if (createConversationResult instanceof CreateConversationResult.Error) {
                sendMessageToAgentResult2 = new SendMessageToAgentResult.Error(((CreateConversationResult.Error)result).getCause());
            } else if (createConversationResult instanceof CreateConversationResult.Success) {
                sendMessageToAgentResult2 = new SendMessageToAgentResult.Success<ConversationCreateCommandResponse>(((CreateConversationResult.Success)result).getCancellablePromise());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return sendMessageToAgentResult2;
        }
        ContinueConversationResult result = this.continueConversation(message, workDoneToken, followUp);
        if (result instanceof ContinueConversationResult.Error) {
            sendMessageToAgentResult = new SendMessageToAgentResult.Error(((ContinueConversationResult.Error)result).getCause());
        } else if (result instanceof ContinueConversationResult.Success) {
            sendMessageToAgentResult = new SendMessageToAgentResult.Success<ConversationTurnCommandResponse>(((ContinueConversationResult.Success)result).getCancellablePromise());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sendMessageToAgentResult;
    }

    private final CreateConversationResult createConversation(String workDoneToken, ChatMessage initialMessage, List<ChatMessage> persistedMessages) {
        List<Turn> turns = TurnKt.turnsBuilder((Function1<? super TurnsBuilder, Unit>)((Function1)arg_0 -> CopilotAgentConversationService.createConversation$lambda$3(persistedMessages, initialMessage, arg_0)));
        Object object = new Capabilities(this.contextListener.getSkillRegistry().getSkillIds());
        List<FileReference> list = this.toFileReferences(initialMessage.getReferences());
        Document document = this.getCurrentDocument();
        Object object2 = AgentWorkspaceFolders.asWorkspaceFolder(ProjectUtils.INSTANCE.getBestProject());
        String string = object2 != null && (object2 = ((WorkspaceFolder)object2).getUri()) != null ? ((VirtualFileUri)object2).getUri() : null;
        String string2 = this.getSessionController().getSession().getSource().getRpcValue();
        String string3 = CopilotApplicationSettings.settings().chatNaturalLanguage;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"chatNaturalLanguage");
        String string4 = CopilotChatLocale.INSTANCE.getLocaleByLanguageName(string3).getLanguage();
        List<String> list2 = initialMessage.getIgnoredSkills();
        String string5 = initialMessage.getModel();
        ConversationCreateCommand createCommand = new ConversationCreateCommand(turns, workDoneToken, (Capabilities)object, list, document, list2, string2, string, string4, string5);
        try {
            CreateConversationResult createConversationResult;
            CancellablePromise<ConversationCreateCommandResponse> promise = this.client.createConversation(createCommand);
            if (PromiseKt.isRejected((Promise)promise)) {
                createConversationResult = new CreateConversationResult.PromiseRejectedError();
            } else {
                List<FileReference> $this$createConversation_u24lambda_u248 = list = promise;
                boolean bl = false;
                $this$createConversation_u24lambda_u248.onError(arg_0 -> CopilotAgentConversationService.createConversation$lambda$8$lambda$5(arg_0 -> CopilotAgentConversationService.createConversation$lambda$8$lambda$4(this, arg_0), arg_0));
                $this$createConversation_u24lambda_u248.onSuccess(arg_0 -> CopilotAgentConversationService.createConversation$lambda$8$lambda$7(arg_0 -> CopilotAgentConversationService.createConversation$lambda$8$lambda$6(this, arg_0), arg_0));
                createConversationResult = new CreateConversationResult.Success(promise);
            }
            object = createConversationResult;
        }
        catch (Throwable ex) {
            object = new CreateConversationResult.Error(ex);
        }
        return object;
    }

    private final ContinueConversationResult continueConversation(ChatMessage message, String workDoneToken, PartialFollowUp followUp) {
        Object object = this.getSessionController().getSession().getConversationId();
        CancellablePromise<ConversationTurnCommandResponse> cancellablePromise = message.getContent();
        List<FileReference> list = this.toFileReferences(message.getReferences());
        Document document = this.getCurrentDocument();
        Object object2 = AgentWorkspaceFolders.asWorkspaceFolder(ProjectUtils.INSTANCE.getBestProject());
        String string = object2 != null && (object2 = ((WorkspaceFolder)object2).getUri()) != null ? ((VirtualFileUri)object2).getUri() : null;
        ConfirmationResponse confirmationResponse = message.getConfirmationResponse();
        List<String> list2 = message.getIgnoredSkills();
        String string2 = message.getModel();
        ConversationTurnCommand continueCommand = new ConversationTurnCommand((String)cancellablePromise, (String)object, workDoneToken, followUp, list, document, list2, string, confirmationResponse, string2);
        try {
            ContinueConversationResult continueConversationResult;
            CancellablePromise<ConversationTurnCommandResponse> promise = this.client.continueConversation(continueCommand);
            if (PromiseKt.isRejected((Promise)promise)) {
                continueConversationResult = new ContinueConversationResult.PromiseRejectedError();
            } else {
                CancellablePromise<ConversationTurnCommandResponse> $this$continueConversation_u24lambda_u2413 = cancellablePromise = promise;
                boolean bl = false;
                $this$continueConversation_u24lambda_u2413.onError(arg_0 -> CopilotAgentConversationService.continueConversation$lambda$13$lambda$10(arg_0 -> CopilotAgentConversationService.continueConversation$lambda$13$lambda$9(this, arg_0), arg_0));
                $this$continueConversation_u24lambda_u2413.onSuccess(arg_0 -> CopilotAgentConversationService.continueConversation$lambda$13$lambda$12(arg_0 -> CopilotAgentConversationService.continueConversation$lambda$13$lambda$11(this, arg_0), arg_0));
                continueConversationResult = new ContinueConversationResult.Success(promise);
            }
            object = continueConversationResult;
        }
        catch (Throwable ex) {
            object = new ContinueConversationResult.Error(ex);
        }
        return object;
    }

    static /* synthetic */ ContinueConversationResult continueConversation$default(CopilotAgentConversationService copilotAgentConversationService, ChatMessage chatMessage, String string, PartialFollowUp partialFollowUp, int n, Object object) {
        if ((n & 4) != 0) {
            partialFollowUp = null;
        }
        return copilotAgentConversationService.continueConversation(chatMessage, string, partialFollowUp);
    }

    @Override
    public void cancelReplies() {
        for (CancellablePromise<? extends Object> conversationProgressPromise : this.conversationProgressPromises) {
            try {
                conversationProgressPromise.cancel();
            }
            catch (Exception e) {
                this.log.warn(e);
            }
        }
        this.conversationProgressPromises.clear();
    }

    @Override
    @NotNull
    public RateConversationMessageResult rateChatMessage(@NotNull ChatMessage chatMessage) {
        RateConversationMessageResult rateConversationMessageResult;
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        try {
            RateConversationMessageResult rateConversationMessageResult2;
            ConversationRatingCommand conversationRatingCommand = ConversationRatingCommand.Companion.forMessage(this.getSessionController().getSession(), chatMessage, this.getCurrentDocument());
            CancellablePromise<String> promise = this.client.rateConversationMessage(conversationRatingCommand);
            if (PromiseKt.isRejected((Promise)promise)) {
                rateConversationMessageResult2 = new RateConversationMessageResult.PromiseRejectedError();
            } else {
                CancellablePromise<String> cancellablePromise;
                CancellablePromise<String> $this$rateChatMessage_u24lambda_u2418 = cancellablePromise = promise;
                boolean bl = false;
                $this$rateChatMessage_u24lambda_u2418.onError(arg_0 -> CopilotAgentConversationService.rateChatMessage$lambda$18$lambda$15(arg_0 -> CopilotAgentConversationService.rateChatMessage$lambda$18$lambda$14(this, arg_0), arg_0));
                $this$rateChatMessage_u24lambda_u2418.onSuccess(arg_0 -> CopilotAgentConversationService.rateChatMessage$lambda$18$lambda$17(arg_0 -> CopilotAgentConversationService.rateChatMessage$lambda$18$lambda$16(this, arg_0), arg_0));
                rateConversationMessageResult2 = RateConversationMessageResult.Success.INSTANCE;
            }
            rateConversationMessageResult = rateConversationMessageResult2;
        }
        catch (Exception e) {
            rateConversationMessageResult = new RateConversationMessageResult.Error(e);
        }
        return rateConversationMessageResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CopyCodeBlockResult copyCodeBlock(@NotNull CopyCodeBlockCommand copyCodeBlockCommand) {
        CopyCodeBlockResult copyCodeBlockResult;
        Intrinsics.checkNotNullParameter((Object)copyCodeBlockCommand, (String)"copyCodeBlockCommand");
        try {
            CopyCodeBlockResult copyCodeBlockResult2;
            void $this$copyCodeBlock_u24lambda_u2419;
            CancellablePromise<String> cancellablePromise;
            CancellablePromise<String> cancellablePromise2 = cancellablePromise = copyCodeBlockCommand;
            CopilotAgentConversationClient copilotAgentConversationClient = this.client;
            boolean bl = false;
            $this$copyCodeBlock_u24lambda_u2419.setDoc(this.getCurrentDocument());
            CancellablePromise<String> promise = copilotAgentConversationClient.copyCodeBlock((CopyCodeBlockCommand)cancellablePromise);
            if (PromiseKt.isRejected((Promise)promise)) {
                copyCodeBlockResult2 = new CopyCodeBlockResult.PromiseRejectedError();
            } else {
                CancellablePromise<String> $this$copyCodeBlock_u24lambda_u2424 = cancellablePromise = promise;
                boolean bl2 = false;
                $this$copyCodeBlock_u24lambda_u2424.onError(arg_0 -> CopilotAgentConversationService.copyCodeBlock$lambda$24$lambda$21(arg_0 -> CopilotAgentConversationService.copyCodeBlock$lambda$24$lambda$20(this, arg_0), arg_0));
                $this$copyCodeBlock_u24lambda_u2424.onSuccess(arg_0 -> CopilotAgentConversationService.copyCodeBlock$lambda$24$lambda$23(arg_0 -> CopilotAgentConversationService.copyCodeBlock$lambda$24$lambda$22(this, arg_0), arg_0));
                copyCodeBlockResult2 = CopyCodeBlockResult.Success.INSTANCE;
            }
            copyCodeBlockResult = copyCodeBlockResult2;
        }
        catch (Exception e) {
            copyCodeBlockResult = new CopyCodeBlockResult.Error(e);
        }
        return copyCodeBlockResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public InsertCodeBlockResult insertCodeBlock(@NotNull InsertCodeBlockCommand insertCodeBlockCommand) {
        InsertCodeBlockResult insertCodeBlockResult;
        Intrinsics.checkNotNullParameter((Object)insertCodeBlockCommand, (String)"insertCodeBlockCommand");
        try {
            InsertCodeBlockResult insertCodeBlockResult2;
            void $this$insertCodeBlock_u24lambda_u2425;
            CancellablePromise<String> cancellablePromise;
            CancellablePromise<String> cancellablePromise2 = cancellablePromise = insertCodeBlockCommand;
            CopilotAgentConversationClient copilotAgentConversationClient = this.client;
            boolean bl = false;
            $this$insertCodeBlock_u24lambda_u2425.setDoc(this.getCurrentDocument());
            CancellablePromise<String> promise = copilotAgentConversationClient.insertCodeBlock((InsertCodeBlockCommand)cancellablePromise);
            if (PromiseKt.isRejected((Promise)promise)) {
                insertCodeBlockResult2 = new InsertCodeBlockResult.PromiseRejectedError();
            } else {
                CancellablePromise<String> $this$insertCodeBlock_u24lambda_u2430 = cancellablePromise = promise;
                boolean bl2 = false;
                $this$insertCodeBlock_u24lambda_u2430.onError(arg_0 -> CopilotAgentConversationService.insertCodeBlock$lambda$30$lambda$27(arg_0 -> CopilotAgentConversationService.insertCodeBlock$lambda$30$lambda$26(this, arg_0), arg_0));
                $this$insertCodeBlock_u24lambda_u2430.onSuccess(arg_0 -> CopilotAgentConversationService.insertCodeBlock$lambda$30$lambda$29(arg_0 -> CopilotAgentConversationService.insertCodeBlock$lambda$30$lambda$28(this, arg_0), arg_0));
                insertCodeBlockResult2 = InsertCodeBlockResult.Success.INSTANCE;
            }
            insertCodeBlockResult = insertCodeBlockResult2;
        }
        catch (Exception e) {
            insertCodeBlockResult = new InsertCodeBlockResult.Error(e);
        }
        return insertCodeBlockResult;
    }

    @Override
    @NotNull
    public DeleteTurnResult deleteTurn(@NotNull DeleteTurnCommand deleteTurnCommand) {
        DeleteTurnResult deleteTurnResult;
        Intrinsics.checkNotNullParameter((Object)deleteTurnCommand, (String)"deleteTurnCommand");
        try {
            DeleteTurnResult deleteTurnResult2;
            CancellablePromise<String> promise = this.client.deleteTurn(deleteTurnCommand);
            if (PromiseKt.isRejected((Promise)promise)) {
                deleteTurnResult2 = new DeleteTurnResult.PromiseRejectedError();
            } else {
                CancellablePromise<String> cancellablePromise;
                CancellablePromise<String> $this$deleteTurn_u24lambda_u2435 = cancellablePromise = promise;
                boolean bl = false;
                $this$deleteTurn_u24lambda_u2435.onError(arg_0 -> CopilotAgentConversationService.deleteTurn$lambda$35$lambda$32(arg_0 -> CopilotAgentConversationService.deleteTurn$lambda$35$lambda$31(this, arg_0), arg_0));
                $this$deleteTurn_u24lambda_u2435.onSuccess(arg_0 -> CopilotAgentConversationService.deleteTurn$lambda$35$lambda$34(arg_0 -> CopilotAgentConversationService.deleteTurn$lambda$35$lambda$33(this, arg_0), arg_0));
                deleteTurnResult2 = DeleteTurnResult.Success.INSTANCE;
            }
            deleteTurnResult = deleteTurnResult2;
        }
        catch (Exception e) {
            deleteTurnResult = new DeleteTurnResult.Error(e);
        }
        return deleteTurnResult;
    }

    @Override
    @NotNull
    public DestroyConversationResult destroyConversation(@NotNull ConversationDestroyCommand destroyConversationCommand) {
        DestroyConversationResult destroyConversationResult;
        Intrinsics.checkNotNullParameter((Object)destroyConversationCommand, (String)"destroyConversationCommand");
        try {
            DestroyConversationResult destroyConversationResult2;
            Disposer.dispose((Disposable)this.retryConversationHandler);
            CancellablePromise<String> promise = this.client.destroyConversation(destroyConversationCommand);
            if (PromiseKt.isRejected((Promise)promise)) {
                destroyConversationResult2 = new DestroyConversationResult.PromiseRejectedError();
            } else {
                CancellablePromise<String> cancellablePromise;
                CancellablePromise<String> $this$destroyConversation_u24lambda_u2440 = cancellablePromise = promise;
                boolean bl = false;
                $this$destroyConversation_u24lambda_u2440.onError(arg_0 -> CopilotAgentConversationService.destroyConversation$lambda$40$lambda$37(arg_0 -> CopilotAgentConversationService.destroyConversation$lambda$40$lambda$36(this, arg_0), arg_0));
                $this$destroyConversation_u24lambda_u2440.onSuccess(arg_0 -> CopilotAgentConversationService.destroyConversation$lambda$40$lambda$39(arg_0 -> CopilotAgentConversationService.destroyConversation$lambda$40$lambda$38(this, arg_0), arg_0));
                destroyConversationResult2 = DestroyConversationResult.Success.INSTANCE;
            }
            destroyConversationResult = destroyConversationResult2;
        }
        catch (Exception e) {
            destroyConversationResult = new DestroyConversationResult.Error(e);
        }
        return destroyConversationResult;
    }

    private final PartialFollowUp toPartial(ChatFollowUp $this$toPartial) {
        return new PartialFollowUp($this$toPartial.getId(), $this$toPartial.getType());
    }

    /*
     * WARNING - void declaration
     */
    private final List<FileReference> toFileReferences(List<? extends ChatReference> $this$toFileReferences) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ChatReferenceKt.toFileChatReferences($this$toFileReferences);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FileChatReference fileChatReference = (FileChatReference)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toFileReference((FileChatReference)it));
        }
        return (List)destination$iv$iv;
    }

    private final FileReference toFileReference(FileChatReference $this$toFileReference) {
        return new FileReference(null, null, $this$toFileReference.getUri(), null, null, null, null, null, 251, null);
    }

    private final Document getCurrentDocument() {
        Document document;
        File file = this.fileService.getCurrentFile();
        if (file != null) {
            File currentFile = file;
            boolean bl = false;
            document = new Document(currentFile.getUri(), null, null, null, null, null, 62, null);
        } else {
            document = null;
        }
        return document;
    }

    private static final Unit onReply$lambda$0(CopilotAgentConversationService this$0, ChatMessage $message, ConversationProgressHandler $handler) {
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $message, $handler, null){
            int label;
            final /* synthetic */ CopilotAgentConversationService this$0;
            final /* synthetic */ ChatMessage $message;
            final /* synthetic */ ConversationProgressHandler $handler;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                this.$handler = $handler;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.onReply(this.$message, this.$handler, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final boolean onReply$lambda$1(String $workDoneToken, ConversationProgressHandler $handler, ConversationProgress progress, Disposable disposable) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        if (!Intrinsics.areEqual((Object)progress.getToken(), (Object)$workDoneToken)) {
            bl = false;
        } else {
            if (progress.isBegin()) {
                $handler.onBegin(disposable);
            } else if (progress.isReport()) {
                $handler.onProgress(progress.getValue());
            } else if (progress.isEnd()) {
                if (progress.getValue().getUnauthorized() != null) {
                    $handler.onUnauthorized(progress.getValue().getUnauthorized());
                } else if (progress.getValue().getError() != null) {
                    $handler.onError(progress.getValue().getError());
                } else {
                    $handler.onComplete(progress.getValue());
                }
                DisposableKt.safelyDispose(disposable);
            }
            bl = true;
        }
        return bl;
    }

    private static final Unit createConversation$lambda$3(List $persistedMessages, ChatMessage $initialMessage, TurnsBuilder $this$turnsBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$turnsBuilder, (String)"$this$turnsBuilder");
        Iterable $this$forEach$iv = $persistedMessages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatMessage msg = (ChatMessage)element$iv;
            boolean bl = false;
            if (msg.getStatus().isOk()) {
                switch (WhenMappings.$EnumSwitchMapping$0[msg.getType().ordinal()]) {
                    case 1: {
                        $this$turnsBuilder.addRequest(msg.getContent());
                        break;
                    }
                    case 2: {
                        $this$turnsBuilder.addResponse(msg.getContent());
                    }
                }
            }
            RemoteAgent remoteAgent = msg.getAgent();
            $this$turnsBuilder.addAgentSlug(remoteAgent != null ? remoteAgent.getSlug() : null);
        }
        $this$turnsBuilder.addRequest($initialMessage.getContent());
        return Unit.INSTANCE;
    }

    private static final Unit createConversation$lambda$8$lambda$4(CopilotAgentConversationService this$0, Throwable error) {
        Logger logger = this$0.log;
        Intrinsics.checkNotNull((Object)error);
        logger.warn(error);
        return Unit.INSTANCE;
    }

    private static final void createConversation$lambda$8$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createConversation$lambda$8$lambda$6(CopilotAgentConversationService this$0, ConversationCreateCommandResponse response) {
        this$0.getSessionController().getSession().setConversationId(response.getConversationId());
        return Unit.INSTANCE;
    }

    private static final void createConversation$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit continueConversation$lambda$13$lambda$9(CopilotAgentConversationService this$0, Throwable error) {
        Logger logger = this$0.log;
        Intrinsics.checkNotNull((Object)error);
        logger.warn(error);
        return Unit.INSTANCE;
    }

    private static final void continueConversation$lambda$13$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit continueConversation$lambda$13$lambda$11(CopilotAgentConversationService this$0, ConversationTurnCommandResponse response) {
        this$0.getSessionController().getSession().setConversationId(response.getConversationId());
        return Unit.INSTANCE;
    }

    private static final void continueConversation$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit rateChatMessage$lambda$18$lambda$14(CopilotAgentConversationService this$0, Throwable error) {
        Logger logger = this$0.log;
        Intrinsics.checkNotNull((Object)error);
        logger.warn(error);
        return Unit.INSTANCE;
    }

    private static final void rateChatMessage$lambda$18$lambda$15(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit rateChatMessage$lambda$18$lambda$16(CopilotAgentConversationService this$0, String response) {
        this$0.log.info("Successfully rated message: " + response);
        return Unit.INSTANCE;
    }

    private static final void rateChatMessage$lambda$18$lambda$17(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit copyCodeBlock$lambda$24$lambda$20(CopilotAgentConversationService this$0, Throwable error) {
        Logger logger = this$0.log;
        Intrinsics.checkNotNull((Object)error);
        logger.warn(error);
        return Unit.INSTANCE;
    }

    private static final void copyCodeBlock$lambda$24$lambda$21(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit copyCodeBlock$lambda$24$lambda$22(CopilotAgentConversationService this$0, String response) {
        this$0.log.info("Successfully copied code block: " + response);
        return Unit.INSTANCE;
    }

    private static final void copyCodeBlock$lambda$24$lambda$23(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit insertCodeBlock$lambda$30$lambda$26(CopilotAgentConversationService this$0, Throwable error) {
        Logger logger = this$0.log;
        Intrinsics.checkNotNull((Object)error);
        logger.warn(error);
        return Unit.INSTANCE;
    }

    private static final void insertCodeBlock$lambda$30$lambda$27(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit insertCodeBlock$lambda$30$lambda$28(CopilotAgentConversationService this$0, String response) {
        this$0.log.info("Successfully inserted code block: " + response);
        return Unit.INSTANCE;
    }

    private static final void insertCodeBlock$lambda$30$lambda$29(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit deleteTurn$lambda$35$lambda$31(CopilotAgentConversationService this$0, Throwable error) {
        Logger logger = this$0.log;
        Intrinsics.checkNotNull((Object)error);
        logger.warn(error);
        return Unit.INSTANCE;
    }

    private static final void deleteTurn$lambda$35$lambda$32(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit deleteTurn$lambda$35$lambda$33(CopilotAgentConversationService this$0, String response) {
        this$0.log.info("Successfully deleted turn: " + response);
        return Unit.INSTANCE;
    }

    private static final void deleteTurn$lambda$35$lambda$34(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit destroyConversation$lambda$40$lambda$36(CopilotAgentConversationService this$0, Throwable error) {
        Logger logger = this$0.log;
        Intrinsics.checkNotNull((Object)error);
        logger.warn(error);
        return Unit.INSTANCE;
    }

    private static final void destroyConversation$lambda$40$lambda$37(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit destroyConversation$lambda$40$lambda$38(CopilotAgentConversationService this$0, String response) {
        this$0.log.info("Successfully destroyed conversation: " + response);
        return Unit.INSTANCE;
    }

    private static final void destroyConversation$lambda$40$lambda$39(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/copilot/chat/conversation/agent/CopilotAgentConversationService$Companion;", "", "<init>", "()V", "agentContextListener", "Lcom/github/copilot/chat/conversation/agent/context/ConversationContextListener;", "getDefaultContextListener", "core"})
    @SourceDebugExtension(value={"SMAP\nCopilotAgentConversationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopilotAgentConversationService.kt\ncom/github/copilot/chat/conversation/agent/CopilotAgentConversationService$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,432:1\n1#2:433\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ConversationContextListener getDefaultContextListener() {
            ConversationContextListener conversationContextListener = agentContextListener;
            if (conversationContextListener == null) {
                CopilotAgentConversationContextListener copilotAgentConversationContextListener;
                CopilotAgentConversationContextListener $this$getDefaultContextListener_u24lambda_u240 = copilotAgentConversationContextListener = new CopilotAgentConversationContextListener(null, null, null, 7, null);
                boolean bl = false;
                agentContextListener = $this$getDefaultContextListener_u24lambda_u240;
                conversationContextListener = copilotAgentConversationContextListener;
            }
            return conversationContextListener;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChatMessageType.values().length];
            try {
                nArray[ChatMessageType.QUERY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatMessageType.RESPONSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

