/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.conversation.agent.context;

import com.github.copilot.chat.conversation.agent.context.ConversationContextClient;
import com.github.copilot.chat.conversation.agent.context.ConversationContextClientKt;
import com.github.copilot.chat.conversation.agent.context.ConversationContextListener;
import com.github.copilot.chat.conversation.agent.context.ConversationContextRequest;
import com.github.copilot.chat.conversation.agent.context.RpcError;
import com.github.copilot.chat.conversation.agent.context.skill.ConversationSkill;
import com.github.copilot.chat.conversation.agent.context.skill.ConversationSkillRegistry;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001b\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/copilot/chat/conversation/agent/context/CopilotAgentConversationContextListener;", "Lcom/github/copilot/chat/conversation/agent/context/ConversationContextListener;", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "client", "Lcom/github/copilot/chat/conversation/agent/context/ConversationContextClient;", "skillRegistry", "Lcom/github/copilot/chat/conversation/agent/context/skill/ConversationSkillRegistry;", "<init>", "(Lcom/github/copilot/platform/utils/observability/Logger;Lcom/github/copilot/chat/conversation/agent/context/ConversationContextClient;Lcom/github/copilot/chat/conversation/agent/context/skill/ConversationSkillRegistry;)V", "getSkillRegistry", "()Lcom/github/copilot/chat/conversation/agent/context/skill/ConversationSkillRegistry;", "isListening", "", "start", "", "handleMessage", "", "", "request", "Lcom/github/copilot/chat/conversation/agent/context/ConversationContextRequest;", "(Lcom/github/copilot/chat/conversation/agent/context/ConversationContextRequest;)[Ljava/lang/Object;", "core"})
@SourceDebugExtension(value={"SMAP\nConversationContextListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversationContextListener.kt\ncom/github/copilot/chat/conversation/agent/context/CopilotAgentConversationContextListener\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,53:1\n39#2:54\n*S KotlinDebug\n*F\n+ 1 ConversationContextListener.kt\ncom/github/copilot/chat/conversation/agent/context/CopilotAgentConversationContextListener\n*L\n15#1:54\n*E\n"})
public final class CopilotAgentConversationContextListener
implements ConversationContextListener {
    @NotNull
    private final Logger log;
    @NotNull
    private final ConversationContextClient client;
    @NotNull
    private final ConversationSkillRegistry skillRegistry;
    private boolean isListening;

    public CopilotAgentConversationContextListener(@NotNull Logger log, @NotNull ConversationContextClient client, @NotNull ConversationSkillRegistry skillRegistry) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)skillRegistry, (String)"skillRegistry");
        this.log = log;
        this.client = client;
        this.skillRegistry = skillRegistry;
    }

    public /* synthetic */ CopilotAgentConversationContextListener(Logger logger, ConversationContextClient conversationContextClient, ConversationSkillRegistry conversationSkillRegistry, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(CopilotAgentConversationContextListener.class);
        }
        if ((n & 2) != 0) {
            conversationContextClient = ConversationContextClientKt.ConversationContextClient();
        }
        if ((n & 4) != 0) {
            conversationSkillRegistry = ConversationSkill.Companion.getRegistry();
        }
        this(logger, conversationContextClient, conversationSkillRegistry);
    }

    @Override
    @NotNull
    public ConversationSkillRegistry getSkillRegistry() {
        return this.skillRegistry;
    }

    @Override
    public void start() {
        if (!this.isListening) {
            this.client.registerConversationContextListener((Function1<? super ConversationContextRequest, Object[]>)((Function1)new Function1<ConversationContextRequest, Object[]>((Object)this){

                public final Object[] invoke(ConversationContextRequest p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((CopilotAgentConversationContextListener)this.receiver).handleMessage(p0);
                }
            }));
            this.isListening = true;
        }
    }

    @NotNull
    public final Object[] handleMessage(@NotNull ConversationContextRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            ConversationSkill conversationSkill = this.getSkillRegistry().getSkill(request.getSkillId());
            if (conversationSkill == null) {
                CopilotAgentConversationContextListener $this$handleMessage_u24lambda_u240 = this;
                boolean bl = false;
                $this$handleMessage_u24lambda_u240.log.info("could not resolve skill, unknown skill id: " + request.getSkillId());
                Object[] objectArray = new Object[]{null, new RpcError(404, "unknown skill id: " + request.getSkillId(), null, 4, null)};
                return objectArray;
            }
            ConversationSkill skill = conversationSkill;
            Object[] objectArray = new Object[]{skill.resolveSkill(), null};
            return objectArray;
        }
        catch (Throwable e) {
            Object[] objectArray = new Object[2];
            objectArray[0] = null;
            String string = e.getMessage();
            if (string == null) {
                string = "unknown error";
            }
            objectArray[1] = new RpcError(500, string, null, 4, null);
            return objectArray;
        }
    }

    public CopilotAgentConversationContextListener() {
        this(null, null, null, 7, null);
    }
}

