/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.conversation.agent.context.skill.git;

import com.github.copilot.chat.conversation.agent.context.skill.git.GitHead;
import com.github.copilot.chat.conversation.agent.context.skill.git.GitMetadata;
import com.github.copilot.chat.conversation.agent.context.skill.git.GitMetadataService;
import com.github.copilot.chat.conversation.agent.context.skill.git.GitMetadataServiceKt;
import com.github.copilot.chat.conversation.agent.context.skill.git.GitRemote;
import com.github.copilot.platform.utils.ApplicationKt;
import com.github.copilot.platform.utils.ProjectKt;
import com.github.copilot.platform.utils.VirtualFileKt;
import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0002\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"log", "Lcom/github/copilot/platform/utils/observability/Logger;", "GitMetadataService", "Lcom/github/copilot/chat/conversation/agent/context/skill/git/GitMetadataService;", "core"})
@SourceDebugExtension(value={"SMAP\nGitMetadataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitMetadataService.kt\ncom/github/copilot/chat/conversation/agent/context/skill/git/GitMetadataServiceKt\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,87:1\n39#2:88\n*S KotlinDebug\n*F\n+ 1 GitMetadataService.kt\ncom/github/copilot/chat/conversation/agent/context/skill/git/GitMetadataServiceKt\n*L\n17#1:88\n*E\n"})
public final class GitMetadataServiceKt {
    @NotNull
    private static final Logger log;

    @NotNull
    public static final GitMetadataService GitMetadataService() {
        return new GitMetadataService(){

            public GitMetadata getMetadata() {
                return (GitMetadata)ApplicationKt.runReadAction(() -> GitMetadataService.1._get_metadata_$lambda$0(this));
            }

            private final GitRepository getGitRepo(Project $this$gitRepo) {
                return GitBranchUtil.guessWidgetRepository((Project)$this$gitRepo, (VirtualFile)ProjectKt.getDir($this$gitRepo));
            }

            private final GitHead getHead(GitRepository $this$head) {
                GitLocalBranch gitLocalBranch = $this$head.getCurrentBranch();
                if (gitLocalBranch == null) {
                    return null;
                }
                GitLocalBranch branch = gitLocalBranch;
                GitRemoteBranch remote = branch.findTrackedBranch($this$head);
                String string = branch.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                GitRemoteBranch gitRemoteBranch = remote;
                return new GitHead(string, gitRemoteBranch != null ? this.toGitRemote(gitRemoteBranch) : null);
            }

            private final List<GitRemote> remotes(GitRepository $this$remotes) {
                List gitRemotes = new ArrayList<E>();
                Collection collection = $this$remotes.getRemotes();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRemotes(...)");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String url;
                    git4idea.repo.GitRemote remote = (git4idea.repo.GitRemote)element$iv;
                    boolean bl = false;
                    if (remote.getFirstUrl() == null) continue;
                    boolean bl2 = false;
                    String string = remote.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    gitRemotes.add(new GitRemote(string, url));
                }
                if (gitRemotes.isEmpty()) {
                    return null;
                }
                return gitRemotes;
            }

            private final GitRemote toGitRemote(GitRemoteBranch $this$toGitRemote) {
                String string = $this$toGitRemote.getRemote().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = $this$toGitRemote.getRemote().getFirstUrl();
                if (string2 == null) {
                    return null;
                }
                return new GitRemote(string, string2);
            }

            private static final GitMetadata _get_metadata_$lambda$0(GitMetadataService.1 this$0) {
                Project currentProject = ProjectKt.getProject();
                try {
                    GitRepository gitRepository = this$0.getGitRepo(currentProject);
                    if (gitRepository == null) {
                        return null;
                    }
                    GitRepository repo = gitRepository;
                    Object object = ProjectKt.getDir(currentProject);
                    if (object == null || (object = VirtualFileKt.getUri(object)) == null) {
                        return null;
                    }
                    Object path = object;
                    return new GitMetadata((String)path, this$0.getHead(repo), this$0.remotes(repo));
                }
                catch (NoClassDefFoundError e) {
                    GitMetadataServiceKt.access$getLog$p().debug("Git4Idea plugin not found:\n" + ExceptionsKt.stackTraceToString((Throwable)e));
                    return null;
                }
            }
        };
    }

    public static final /* synthetic */ Logger access$getLog$p() {
        return log;
    }

    static {
        boolean $i$f$Logger = false;
        log = new GitHubLogger(GitMetadataService.class);
    }
}

