/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.conversation.agent.context.skill.labels;

import com.github.copilot.chat.conversation.agent.context.skill.ConversationSkill;
import com.github.copilot.chat.conversation.agent.context.skill.labels.ProjectFile;
import com.github.copilot.chat.conversation.agent.context.skill.labels.ProjectFileSystem;
import com.github.copilot.chat.conversation.agent.context.skill.labels.ProjectFileSystemKt;
import com.github.copilot.chat.conversation.agent.context.skill.labels.ProjectLabelsIndicators;
import com.github.copilot.chat.conversation.agent.context.skill.labels.ProjectLabelsIndicatorsKt;
import com.github.copilot.chat.conversation.agent.context.skill.labels.ProjectLabelsResponse;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/github/copilot/chat/conversation/agent/context/skill/labels/ProjectLabelsSkill;", "Lcom/github/copilot/chat/conversation/agent/context/skill/ConversationSkill;", "fs", "Lcom/github/copilot/chat/conversation/agent/context/skill/labels/ProjectFileSystem;", "<init>", "(Lcom/github/copilot/chat/conversation/agent/context/skill/labels/ProjectFileSystem;)V", "id", "", "getId", "()Ljava/lang/String;", "resolveSkill", "Lcom/github/copilot/chat/conversation/agent/context/skill/labels/ProjectLabelsResponse;", "Companion", "core"})
public final class ProjectLabelsSkill
implements ConversationSkill {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectFileSystem fs;
    @NotNull
    private final String id;
    @NotNull
    public static final String ID = "project-labels";
    @NotNull
    private static final ProjectLabelsIndicators indicators = ProjectLabelsIndicators.Companion.init((Function1<? super ProjectLabelsIndicators, Unit>)((Function1)ProjectLabelsSkill::indicators$lambda$1));

    public ProjectLabelsSkill(@NotNull ProjectFileSystem fs) {
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        this.fs = fs;
        this.id = ID;
    }

    public /* synthetic */ ProjectLabelsSkill(ProjectFileSystem projectFileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            projectFileSystem = ProjectFileSystemKt.ProjectFileSystem();
        }
        this(projectFileSystem);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public ProjectLabelsResponse resolveSkill() {
        Set labels = new LinkedHashSet();
        this.fs.walkProjectFiles((Function1<? super ProjectFile, Unit>)((Function1)arg_0 -> ProjectLabelsSkill.resolveSkill$lambda$0(labels, arg_0)));
        if (labels.isEmpty()) {
            return null;
        }
        return new ProjectLabelsResponse(CollectionsKt.toList((Iterable)labels));
    }

    private static final Unit resolveSkill$lambda$0(Set $labels, ProjectFile projectFile) {
        Intrinsics.checkNotNullParameter((Object)projectFile, (String)"projectFile");
        $labels.addAll((Collection)indicators.getLabelsForFile(projectFile));
        return Unit.INSTANCE;
    }

    private static final Unit indicators$lambda$1(ProjectLabelsIndicators $this$init) {
        Intrinsics.checkNotNullParameter((Object)$this$init, (String)"$this$init");
        ProjectLabelsIndicatorsKt.addPythonExtIndicator($this$init);
        ProjectLabelsIndicatorsKt.addCExtIndicator($this$init);
        ProjectLabelsIndicatorsKt.addCppExtIndicator($this$init);
        ProjectLabelsIndicatorsKt.addCSharpExtIndicator($this$init);
        ProjectLabelsIndicatorsKt.addJavaExtIndicator($this$init);
        ProjectLabelsIndicatorsKt.addJavaScriptExtIndicator($this$init);
        ProjectLabelsIndicatorsKt.addTypeScriptExtIndicator($this$init);
        ProjectLabelsIndicatorsKt.addPhpExtIndicator($this$init);
        ProjectLabelsIndicatorsKt.addSqlExtIndicator($this$init);
        ProjectLabelsIndicatorsKt.addGoExtIndicator($this$init);
        ProjectLabelsIndicatorsKt.addRustExtIndicator($this$init);
        ProjectLabelsIndicatorsKt.addRubyExtIndicator($this$init);
        ProjectLabelsIndicatorsKt.addKotlinExtIndicator($this$init);
        ProjectLabelsIndicatorsKt.addScalaExtIndicator($this$init);
        ProjectLabelsIndicatorsKt.addPackageJsonIndicator($this$init);
        ProjectLabelsIndicatorsKt.addTsConfigJsonIndicator($this$init);
        ProjectLabelsIndicatorsKt.addPomXmlIndicator($this$init);
        ProjectLabelsIndicatorsKt.addBuildGradleIndicator($this$init);
        ProjectLabelsIndicatorsKt.addRequirementsTxtIndicator($this$init);
        ProjectLabelsIndicatorsKt.addPipFileIndicator($this$init);
        ProjectLabelsIndicatorsKt.addCargoTomlIndicator($this$init);
        ProjectLabelsIndicatorsKt.addGoModIndicator($this$init);
        ProjectLabelsIndicatorsKt.addPubspecYamlIndicator($this$init);
        ProjectLabelsIndicatorsKt.addBuildSbtIndicator($this$init);
        ProjectLabelsIndicatorsKt.addBuildBootIndicator($this$init);
        ProjectLabelsIndicatorsKt.addProjectCljIndicator($this$init);
        ProjectLabelsIndicatorsKt.addMixExsIndicator($this$init);
        ProjectLabelsIndicatorsKt.addComposerJsonIndicator($this$init);
        ProjectLabelsIndicatorsKt.addGemfileIndicator($this$init);
        ProjectLabelsIndicatorsKt.addBuildXmlIndicator($this$init);
        ProjectLabelsIndicatorsKt.addBuildGradleKtsIndicator($this$init);
        ProjectLabelsIndicatorsKt.addYarnLockIndicator($this$init);
        ProjectLabelsIndicatorsKt.addApplicationPropertiesIndicator($this$init);
        ProjectLabelsIndicatorsKt.addApplicationYmlIndicator($this$init);
        return Unit.INSTANCE;
    }

    public ProjectLabelsSkill() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/github/copilot/chat/conversation/agent/context/skill/labels/ProjectLabelsSkill$Companion;", "", "<init>", "()V", "ID", "", "indicators", "Lcom/github/copilot/chat/conversation/agent/context/skill/labels/ProjectLabelsIndicators;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

