/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.conversation.agent.context.skill.metadata;

import com.github.copilot.chat.conversation.agent.context.skill.metadata.AggregateMetadata;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.AggregateMetadataKt;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.AsyncExecutor;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.BuildTool;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.DirectoryMetadata;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.FileListener;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.Language;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.Library;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.Project;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.ProjectFile;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.ProjectMetadata;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.ProjectMetadataService;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.ProjectServiceKt;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.ProjectStatus;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.buildtool.ProjectBuildTool;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.language.LanguageService;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.language.ProjectLanguage;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.library.LibraryService;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.library.ProjectLibraries;
import com.github.copilot.chat.conversation.agent.context.skill.metadata.library.ProjectLibrary;
import com.github.copilot.platform.utils.ProjectService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BV\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012+\u0010\n\u001a'\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\u000bj\u0002`\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\b\u0010\u001e\u001a\u00020\rH\u0002J\b\u0010\u001f\u001a\u00020\rH\u0002J\u000e\u0010 \u001a\u0004\u0018\u00010\u0019*\u00020\u0004H\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010\u0019*\u00020\u0004H\u0002J\f\u0010!\u001a\u00020\r*\u00020\u0004H\u0002J\f\u0010\"\u001a\u00020\r*\u00020\u0004H\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010\u001b*\u00020\u00042\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0010\u0010&\u001a\u00060'j\u0002`(*\u00020)H\u0002J \u0010*\u001a\f\u0012\b\u0012\u00060,j\u0002`-0+*\f\u0012\u0004\u0012\u00020/0.j\u0002`0H\u0002J\u0010\u00101\u001a\u00060,j\u0002`-*\u000202H\u0002J\u0016\u00103\u001a\f\u0012\b\u0012\u000604j\u0002`50+*\u000206H\u0002J\u0010\u00107\u001a\u000604j\u0002`5*\u000208H\u0002R\u0018\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\n\u001a'\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\u000bj\u0002`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00069"}, d2={"Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/MetadataService;", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/ProjectMetadataService;", "projectService", "Lcom/github/copilot/platform/utils/ProjectService;", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/Project;", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/ProjectService;", "languageService", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/LanguageService;", "libraryService", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/library/LibraryService;", "asyncExecutor", "Lkotlin/Function1;", "Lkotlin/Function0;", "", "Lkotlin/ParameterName;", "name", "block", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/AsyncExecutor;", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/AsyncExecutorProvider;", "<init>", "(Lcom/github/copilot/platform/utils/ProjectService;Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/LanguageService;Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/library/LibraryService;Lkotlin/jvm/functions/Function1;)V", "projectsStatus", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/ProjectStatus;", "projectsDirectoryMetadata", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/DirectoryMetadata;", "projectMetadata", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/ProjectMetadata;", "getProjectMetadata", "()Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/ProjectMetadata;", "initProjectsMetadata", "updateDirectoryMetadata", "initDirectoryMetadata", "removeDirectoryMetadata", "initStatusListener", "getMetadata", "file", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/ProjectFile;", "toProjectMetadataLanguage", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/Language;", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/ProjectMetadataLanguage;", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/ProjectLanguage;", "toProjectMetadataBuildTools", "", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/BuildTool;", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/ProjectMetadataBuildTool;", "", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/buildtool/ProjectBuildTool;", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/buildtool/ProjectBuildTools;", "toProjectMetadataBuildTool", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/buildtool/BuildTool;", "toProjectMetadataLibraries", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/Library;", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/ProjectMetadataLibrary;", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/library/ProjectLibraries;", "toProjectMetadataLibrary", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/library/ProjectLibrary;", "core"})
@SourceDebugExtension(value={"SMAP\nProjectMetadataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectMetadataService.kt\ncom/github/copilot/chat/conversation/agent/context/skill/metadata/MetadataService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1855#2,2:164\n1549#2:169\n1620#2,3:170\n1549#2:173\n1620#2,3:174\n215#3,2:166\n1#4:168\n*S KotlinDebug\n*F\n+ 1 ProjectMetadataService.kt\ncom/github/copilot/chat/conversation/agent/context/skill/metadata/MetadataService\n*L\n48#1:164,2\n124#1:169\n124#1:170,3\n131#1:173\n131#1:174,3\n58#1:166,2\n*E\n"})
final class MetadataService
implements ProjectMetadataService {
    @NotNull
    private final ProjectService<Project> projectService;
    @NotNull
    private final LanguageService languageService;
    @NotNull
    private final LibraryService libraryService;
    @NotNull
    private final Function1<Function0<Unit>, AsyncExecutor> asyncExecutor;
    @NotNull
    private final ConcurrentHashMap<Project, ProjectStatus> projectsStatus;
    @NotNull
    private final ConcurrentHashMap<Project, DirectoryMetadata> projectsDirectoryMetadata;

    public MetadataService(@NotNull ProjectService<Project> projectService, @NotNull LanguageService languageService, @NotNull LibraryService libraryService, @NotNull Function1<? super Function0<Unit>, ? extends AsyncExecutor> asyncExecutor) {
        Intrinsics.checkNotNullParameter(projectService, (String)"projectService");
        Intrinsics.checkNotNullParameter((Object)languageService, (String)"languageService");
        Intrinsics.checkNotNullParameter((Object)libraryService, (String)"libraryService");
        Intrinsics.checkNotNullParameter(asyncExecutor, (String)"asyncExecutor");
        this.projectService = projectService;
        this.languageService = languageService;
        this.libraryService = libraryService;
        this.asyncExecutor = asyncExecutor;
        this.projectsStatus = new ConcurrentHashMap();
        this.projectsDirectoryMetadata = new ConcurrentHashMap();
        this.initProjectsMetadata();
    }

    @Override
    @Nullable
    public ProjectMetadata getProjectMetadata() {
        return MetadataService.getMetadata$default(this, this.projectService.getCurrentProject(), null, 1, null);
    }

    private final void initProjectsMetadata() {
        Iterable $this$forEach$iv = this.projectService.getAllProjects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project project = (Project)element$iv;
            boolean bl = false;
            this.initDirectoryMetadata(project);
        }
        this.projectService.onProjectOpened((Function1<Project, Unit>)((Function1)arg_0 -> MetadataService.initProjectsMetadata$lambda$1(this, arg_0)));
        this.projectService.onProjectClosed((Function1<Project, Unit>)((Function1)arg_0 -> MetadataService.initProjectsMetadata$lambda$2(this, arg_0)));
        ((AsyncExecutor)this.asyncExecutor.invoke(() -> MetadataService.initProjectsMetadata$lambda$3(this))).start();
    }

    private final void updateDirectoryMetadata() {
        Map $this$forEach$iv = this.projectsStatus;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Project project = (Project)entry.getKey();
            ProjectStatus status = (ProjectStatus)entry.getValue();
            status.update((Function0<Unit>)((Function0)() -> MetadataService.updateDirectoryMetadata$lambda$5$lambda$4(this, project)));
        }
    }

    private final DirectoryMetadata initDirectoryMetadata(Project $this$initDirectoryMetadata) {
        DirectoryMetadata directoryMetadata;
        DirectoryMetadata it = directoryMetadata = this.updateDirectoryMetadata($this$initDirectoryMetadata);
        boolean bl = false;
        this.initStatusListener($this$initDirectoryMetadata);
        return directoryMetadata;
    }

    private final DirectoryMetadata updateDirectoryMetadata(Project $this$updateDirectoryMetadata) {
        DirectoryMetadata directoryMetadata;
        DirectoryMetadata directoryMetadata2 = ProjectServiceKt.getDirectoryMetadata($this$updateDirectoryMetadata);
        if (directoryMetadata2 != null) {
            DirectoryMetadata directoryMetadata3;
            DirectoryMetadata it = directoryMetadata3 = directoryMetadata2;
            boolean bl = false;
            ((Map)this.projectsDirectoryMetadata).put($this$updateDirectoryMetadata, it);
            directoryMetadata = directoryMetadata3;
        } else {
            directoryMetadata = null;
        }
        return directoryMetadata;
    }

    private final void removeDirectoryMetadata(Project $this$removeDirectoryMetadata) {
        this.projectsStatus.remove($this$removeDirectoryMetadata);
        this.projectsDirectoryMetadata.remove($this$removeDirectoryMetadata);
    }

    private final void initStatusListener(Project $this$initStatusListener) {
        ((Map)this.projectsStatus).put($this$initStatusListener, new ProjectStatus(false, false, 2, null));
        $this$initStatusListener.addFileListener(new FileListener(this, $this$initStatusListener){
            final /* synthetic */ MetadataService this$0;
            final /* synthetic */ Project $this_initStatusListener;
            {
                this.this$0 = $receiver;
                this.$this_initStatusListener = $receiver2;
            }

            public void onCreateOrDelete() {
                block0: {
                    ProjectStatus projectStatus = (ProjectStatus)MetadataService.access$getProjectsStatus$p(this.this$0).get(this.$this_initStatusListener);
                    if (projectStatus == null) break block0;
                    projectStatus.setHasChanges(true);
                }
            }
        });
    }

    private final ProjectMetadata getMetadata(Project $this$getMetadata, ProjectFile file) {
        DirectoryMetadata projectDirectoryMetadata;
        Object object;
        DirectoryMetadata directoryMetadata;
        DirectoryMetadata directoryMetadata2 = this.projectsDirectoryMetadata.get($this$getMetadata);
        if (directoryMetadata2 == null && (directoryMetadata2 = this.initDirectoryMetadata($this$getMetadata)) == null) {
            return null;
        }
        DirectoryMetadata rootDirectoryMetadata = directoryMetadata2;
        ProjectFile projectFile = file;
        if (projectFile != null) {
            ProjectFile it = projectFile;
            boolean bl = false;
            directoryMetadata = rootDirectoryMetadata.getClosestProjectRootDirectoryToFile(it);
        } else {
            directoryMetadata = null;
        }
        if ((object = (projectDirectoryMetadata = directoryMetadata)) == null || (object = AggregateMetadataKt.aggregateProject((DirectoryMetadata)object)) == null) {
            object = AggregateMetadataKt.aggregateDirectory(rootDirectoryMetadata);
        }
        Object aggregateMetadata = object;
        ProjectLanguage projectLanguage = this.languageService.getProjectLanguage($this$getMetadata, file, (AggregateMetadata)aggregateMetadata);
        if (projectLanguage == null) {
            return null;
        }
        ProjectLanguage language = projectLanguage;
        ProjectLibraries libraries = this.libraryService.getProjectLibraries(language.getLanguage(), $this$getMetadata, file);
        return new ProjectMetadata(this.toProjectMetadataLanguage(language), this.toProjectMetadataBuildTools(((AggregateMetadata)aggregateMetadata).getBuildTools()), this.toProjectMetadataLibraries(libraries));
    }

    static /* synthetic */ ProjectMetadata getMetadata$default(MetadataService metadataService, Project project, ProjectFile projectFile, int n, Object object) {
        if ((n & 1) != 0) {
            projectFile = project.getCurrentFile();
        }
        return metadataService.getMetadata(project, projectFile);
    }

    private final Language toProjectMetadataLanguage(ProjectLanguage $this$toProjectMetadataLanguage) {
        return new Language($this$toProjectMetadataLanguage.getLanguage().getId(), $this$toProjectMetadataLanguage.getLanguage().getLangName(), $this$toProjectMetadataLanguage.getVersion());
    }

    private final List<BuildTool> toProjectMetadataBuildTools(Set<ProjectBuildTool> $this$toProjectMetadataBuildTools) {
        com.github.copilot.chat.conversation.agent.context.skill.metadata.buildtool.BuildTool it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toProjectMetadataBuildTools;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ProjectBuildTool projectBuildTool = (ProjectBuildTool)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((ProjectBuildTool)((Object)it)).getBuildTool());
        }
        $this$map$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (com.github.copilot.chat.conversation.agent.context.skill.metadata.buildtool.BuildTool)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toProjectMetadataBuildTool(it));
        }
        return (List)destination$iv$iv;
    }

    private final BuildTool toProjectMetadataBuildTool(com.github.copilot.chat.conversation.agent.context.skill.metadata.buildtool.BuildTool $this$toProjectMetadataBuildTool) {
        return new BuildTool($this$toProjectMetadataBuildTool.getDisplayName(), null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Library> toProjectMetadataLibraries(ProjectLibraries $this$toProjectMetadataLibraries) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toProjectMetadataLibraries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProjectLibrary projectLibrary = (ProjectLibrary)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toProjectMetadataLibrary((ProjectLibrary)it));
        }
        return (List)destination$iv$iv;
    }

    private final Library toProjectMetadataLibrary(ProjectLibrary $this$toProjectMetadataLibrary) {
        return new Library($this$toProjectMetadataLibrary.getName(), $this$toProjectMetadataLibrary.getVersion());
    }

    private static final Unit initProjectsMetadata$lambda$1(MetadataService this$0, Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this$0.initDirectoryMetadata(project);
        return Unit.INSTANCE;
    }

    private static final Unit initProjectsMetadata$lambda$2(MetadataService this$0, Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this$0.removeDirectoryMetadata(project);
        return Unit.INSTANCE;
    }

    private static final Unit initProjectsMetadata$lambda$3(MetadataService this$0) {
        this$0.updateDirectoryMetadata();
        return Unit.INSTANCE;
    }

    private static final Unit updateDirectoryMetadata$lambda$5$lambda$4(MetadataService this$0, Project $project) {
        this$0.updateDirectoryMetadata($project);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getProjectsStatus$p(MetadataService $this) {
        return $this.projectsStatus;
    }
}

