/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.chat.conversation.agent.context.skill.metadata.language;

import com.github.copilot.chat.conversation.agent.context.skill.metadata.language.ProjectLanguageKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0018\b\u0086\u0081\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001dB'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001c\u00a8\u0006\u001e"}, d2={"Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/Language;", "", "id", "", "langName", "fileExtensions", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getId", "()Ljava/lang/String;", "getLangName", "getFileExtensions", "()Ljava/util/List;", "JAVA", "KOTLIN", "JAVASCRIPT", "TYPESCRIPT", "GO", "PYTHON", "PHP", "C", "C_PLUS_PLUS", "C_SHARP", "SQL", "RUST", "RUBY", "SCALA", "GROOVY", "Companion", "core"})
public final class Language
extends Enum<Language> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String id;
    @NotNull
    private final String langName;
    @NotNull
    private final List<String> fileExtensions;
    @NotNull
    private static final String EXTENSION_SEPARATOR = ".";
    public static final /* enum */ Language JAVA;
    public static final /* enum */ Language KOTLIN;
    public static final /* enum */ Language JAVASCRIPT;
    public static final /* enum */ Language TYPESCRIPT;
    public static final /* enum */ Language GO;
    public static final /* enum */ Language PYTHON;
    public static final /* enum */ Language PHP;
    public static final /* enum */ Language C;
    public static final /* enum */ Language C_PLUS_PLUS;
    public static final /* enum */ Language C_SHARP;
    public static final /* enum */ Language SQL;
    public static final /* enum */ Language RUST;
    public static final /* enum */ Language RUBY;
    public static final /* enum */ Language SCALA;
    public static final /* enum */ Language GROOVY;
    private static final /* synthetic */ Language[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private Language(String id, String langName, List<String> fileExtensions) {
        this.id = id;
        this.langName = langName;
        this.fileExtensions = fileExtensions;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getLangName() {
        return this.langName;
    }

    @NotNull
    public final List<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public static Language[] values() {
        return (Language[])$VALUES.clone();
    }

    public static Language valueOf(String value) {
        return Enum.valueOf(Language.class, value);
    }

    @NotNull
    public static EnumEntries<Language> getEntries() {
        return $ENTRIES;
    }

    static {
        String[] stringArray = new String[]{".java"};
        JAVA = new Language("java", "Java", ProjectLanguageKt.access$fileExtensions(stringArray));
        stringArray = new String[]{".kt", ".kts"};
        KOTLIN = new Language("kotlin", "Kotlin", ProjectLanguageKt.access$fileExtensions(stringArray));
        stringArray = new String[]{".js", ".jsx"};
        JAVASCRIPT = new Language("javascript", "JavaScript", ProjectLanguageKt.access$fileExtensions(stringArray));
        stringArray = new String[]{".ts", ".tsx"};
        TYPESCRIPT = new Language("typescript", "TypeScript", ProjectLanguageKt.access$fileExtensions(stringArray));
        stringArray = new String[]{".go"};
        GO = new Language("go", "Go", ProjectLanguageKt.access$fileExtensions(stringArray));
        stringArray = new String[]{".py"};
        PYTHON = new Language("python", "Python", ProjectLanguageKt.access$fileExtensions(stringArray));
        stringArray = new String[]{".php", ".php3", ".php4", ".php5", ".phtml"};
        PHP = new Language("php", "PHP", ProjectLanguageKt.access$fileExtensions(stringArray));
        stringArray = new String[]{".c", ".h"};
        C = new Language("c", "C", ProjectLanguageKt.access$fileExtensions(stringArray));
        stringArray = new String[]{".cpp"};
        C_PLUS_PLUS = new Language("c++", "C++", ProjectLanguageKt.access$fileExtensions(stringArray));
        stringArray = new String[]{".cs", ".csx"};
        C_SHARP = new Language("c#", "C#", ProjectLanguageKt.access$fileExtensions(stringArray));
        stringArray = new String[]{".sql"};
        SQL = new Language("sql", "SQL", ProjectLanguageKt.access$fileExtensions(stringArray));
        stringArray = new String[]{".rs"};
        RUST = new Language("rust", "Rust", ProjectLanguageKt.access$fileExtensions(stringArray));
        stringArray = new String[]{".rb", ".ru"};
        RUBY = new Language("ruby", "Ruby", ProjectLanguageKt.access$fileExtensions(stringArray));
        stringArray = new String[]{".scala", ".sc"};
        SCALA = new Language("scala", "Scala", ProjectLanguageKt.access$fileExtensions(stringArray));
        stringArray = new String[]{".groovy"};
        GROOVY = new Language("groovy", "Groovy", ProjectLanguageKt.access$fileExtensions(stringArray));
        $VALUES = languageArray = new Language[]{Language.JAVA, Language.KOTLIN, Language.JAVASCRIPT, Language.TYPESCRIPT, Language.GO, Language.PYTHON, Language.PHP, Language.C, Language.C_PLUS_PLUS, Language.C_SHARP, Language.SQL, Language.RUST, Language.RUBY, Language.SCALA, Language.GROOVY};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0005J\f\u0010\u000b\u001a\u00020\u0005*\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/Language$Companion;", "", "<init>", "()V", "EXTENSION_SEPARATOR", "", "forId", "Lcom/github/copilot/chat/conversation/agent/context/skill/metadata/language/Language;", "id", "forFileExtension", "extension", "normalizeExtension", "core"})
    @SourceDebugExtension(value={"SMAP\nProjectLanguage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectLanguage.kt\ncom/github/copilot/chat/conversation/agent/context/skill/metadata/language/Language$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n13579#2,2:180\n13579#2:182\n13580#2:185\n1855#3,2:183\n*S KotlinDebug\n*F\n+ 1 ProjectLanguage.kt\ncom/github/copilot/chat/conversation/agent/context/skill/metadata/language/Language$Companion\n*L\n45#1:180,2\n58#1:182\n58#1:185\n59#1:183,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Language forId(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            String normalizedId = ProjectLanguageKt.access$normalize(id);
            Language[] $this$forEach$iv = Language.values();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Language element$iv;
                Language language = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)ProjectLanguageKt.access$normalize(language.getId()), (Object)normalizedId)) continue;
                return language;
            }
            return null;
        }

        @Nullable
        public final Language forFileExtension(@NotNull String extension) {
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            String normalizedExt = this.normalizeExtension(extension);
            Language[] $this$forEach$iv = Language.values();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Language element$iv;
                Language language = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Iterable $this$forEach$iv2 = language.getFileExtensions();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String fileExtension = (String)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)ProjectLanguageKt.access$normalize(fileExtension), (Object)normalizedExt)) continue;
                    return language;
                }
            }
            return null;
        }

        private final String normalizeExtension(String $this$normalizeExtension) {
            String normalized = ProjectLanguageKt.access$normalize($this$normalizeExtension);
            boolean bl = false;
            return StringsKt.startsWith$default((String)normalized, (String)Language.EXTENSION_SEPARATOR, (boolean)false, (int)2, null) ? normalized : Language.EXTENSION_SEPARATOR + normalized;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

